/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.wand;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.event.ClientRenderEventHandler;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationBotania;
import hellfirepvp.astralsorcery.common.item.ItemAlignmentChargeConsumer;
import hellfirepvp.astralsorcery.common.item.ItemBlockStorage;
import hellfirepvp.astralsorcery.common.item.ItemHandRender;
import hellfirepvp.astralsorcery.common.item.ItemHudRender;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.lwjgl.opengl.GL11;

public class ItemArchitectWand
extends ItemBlockStorage
implements ItemHandRender,
ItemHudRender,
ItemAlignmentChargeConsumer {
    private static final double architectRange = 60.0;

    public ItemArchitectWand() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderInHandHUD(ItemStack lastCacheInstance, float fadeAlpha, float pTicks) {
        ItemStack blockStackStored = ItemArchitectWand.getStoredStateAsStack(lastCacheInstance);
        if (blockStackStored == null) {
            return;
        }
        int amtFound = 0;
        if (Mods.BOTANIA.isPresent()) {
            amtFound = ModIntegrationBotania.getItemCount((EntityPlayer)Minecraft.func_71410_x().field_71439_g, lastCacheInstance, ItemUtils.createBlockState(blockStackStored));
        } else {
            Collection<ItemStack> stacks = ItemUtils.scanInventoryForMatching((IItemHandler)new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by), blockStackStored, false);
            for (ItemStack stack : stacks) {
                amtFound += stack.field_77994_a;
            }
        }
        int height = 26;
        int width = 26;
        int offsetX = 30;
        int offsetY = 15;
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        Blending.DEFAULT.apply();
        ClientRenderEventHandler.texHUDItemFrame.bind();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(fadeAlpha * 0.9f));
        Tessellator tes = Tessellator.func_178181_a();
        VertexBuffer vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)offsetX, (double)(offsetY + height), 10.0).func_187315_a(0.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(offsetX + width), (double)(offsetY + height), 10.0).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(offsetX + width), (double)offsetY, 10.0).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b((double)offsetX, (double)offsetY, 10.0).func_187315_a(0.0, 0.0).func_181675_d();
        tes.func_78381_a();
        TextureHelper.refreshTextureBindState();
        TextureHelper.setActiveTextureToAtlasSprite();
        RenderHelper.func_74520_c();
        RenderItem ri = Minecraft.func_71410_x().func_175599_af();
        ri.func_184391_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, blockStackStored, offsetX + 5, offsetY + 5);
        RenderHelper.func_74518_a();
        GlStateManager.func_179141_d();
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offsetX + 14), (double)(offsetY + 16), (double)0.0);
        String amtString = String.valueOf(amtFound);
        if (amtFound == -1) {
            amtString = "\u00e2\u02c6\u017e";
        }
        GL11.glTranslated((double)(-Minecraft.func_71410_x().field_71466_p.func_78256_a(amtString) / 3), (double)0.0, (double)0.0);
        GL11.glScaled((double)0.7, (double)0.7, (double)0.7);
        if (amtString.length() > 3) {
            GL11.glScaled((double)0.9, (double)0.9, (double)0.9);
        }
        int c = 0xDDDDDD;
        Minecraft.func_71410_x().field_71466_p.func_175063_a(amtString, 0.0f, 0.0f, c);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureHelper.refreshTextureBindState();
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderWhileInHand(ItemStack stack, EnumHand hand, float pTicks) {
        IBlockState stored = ItemArchitectWand.getStoredState(stack);
        if (stored == null || stored.func_177230_c().equals(Blocks.field_150350_a)) {
            return;
        }
        Deque<BlockPos> placeable = this.filterBlocksToPlace((Entity)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e, 60.0);
        if (!placeable.isEmpty()) {
            GL11.glPushAttrib((int)1048575);
            GL11.glPushMatrix();
            boolean blend = GL11.glGetBoolean((int)3042);
            GL11.glEnable((int)3042);
            Blending.ADDITIVEDARK.apply();
            GL11.glDisable((int)3008);
            RenderingUtils.removeStandartTranslationFromTESRMatrix(pTicks);
            WorldClient w = Minecraft.func_71410_x().field_71441_e;
            Tessellator tes = Tessellator.func_178181_a();
            VertexBuffer vb = tes.func_178180_c();
            vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            for (BlockPos pos : placeable) {
                Minecraft.func_71410_x().func_175602_ab().func_175018_a(stored, pos, (IBlockAccess)w, vb);
            }
            vb.func_181674_a((float)TileEntityRendererDispatcher.field_147554_b, (float)TileEntityRendererDispatcher.field_147555_c, (float)TileEntityRendererDispatcher.field_147552_d);
            tes.func_78381_a();
            Blending.DEFAULT.apply();
            if (!blend) {
                GL11.glDisable((int)3042);
            }
            GL11.glEnable((int)3008);
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer playerIn, EnumHand hand) {
        if (world.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        IBlockState stored = ItemArchitectWand.getStoredState(stack);
        ItemStack consumeStack = ItemArchitectWand.getStoredStateAsStack(stack);
        if (stored == null || stored.func_177230_c().equals(Blocks.field_150350_a) || consumeStack == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        Deque<BlockPos> placeable = this.filterBlocksToPlace((Entity)playerIn, world, 60.0);
        if (!placeable.isEmpty()) {
            for (BlockPos placePos : placeable) {
                if (!this.drainTempCharge(playerIn, Config.architectWandUseCost, true) || !playerIn.func_184812_l_() && !ItemUtils.consumeFromPlayerInventory(playerIn, stack, ItemUtils.copyStackWithSize(consumeStack, 1), true)) continue;
                this.drainTempCharge(playerIn, Config.architectWandUseCost, false);
                this.gainPermCharge(playerIn, Config.architectWandUseCost / 4.0f);
                if (!playerIn.func_184812_l_()) {
                    ItemUtils.consumeFromPlayerInventory(playerIn, stack, ItemUtils.copyStackWithSize(consumeStack, 1), false);
                }
                world.func_175656_a(placePos, stored);
                PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.ARCHITECT_PLACE, (Vec3i)placePos);
                ev.setAdditionalData(Block.func_176210_f((IBlockState)stored));
                PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(world, placePos, 40.0));
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            ItemArchitectWand.tryStoreBlock(stack, world, pos);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public static void playArchitectPlaceEvent(PktParticleEvent event) {
        AstralSorcery.proxy.scheduleClientside(() -> {
            Vector3 at = event.getVec();
            IBlockState state = Block.func_176220_d((int)((int)Math.round(event.getAdditionalData())));
            RenderingUtils.playBlockBreakParticles(at.toBlockPos(), state);
            for (int i = 0; i < 9; ++i) {
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX() + (field_77697_d.nextBoolean() ? -((double)field_77697_d.nextFloat() * 0.1) : 1.0 + (double)field_77697_d.nextFloat() * 0.1), at.getY() + (field_77697_d.nextBoolean() ? -((double)field_77697_d.nextFloat() * 0.1) : 1.0 + (double)field_77697_d.nextFloat() * 0.1), at.getZ() + (field_77697_d.nextBoolean() ? -((double)field_77697_d.nextFloat() * 0.1) : 1.0 + (double)field_77697_d.nextFloat() * 0.1));
                p.motion(field_77697_d.nextFloat() * 0.03f * (float)(field_77697_d.nextBoolean() ? 1 : -1), field_77697_d.nextFloat() * 0.03f * (float)(field_77697_d.nextBoolean() ? 1 : -1), field_77697_d.nextFloat() * 0.03f * (float)(field_77697_d.nextBoolean() ? 1 : -1));
                p.scale(0.35f).setColor(Color.WHITE.brighter());
            }
        }, 1);
    }

    private Deque<BlockPos> filterBlocksToPlace(Entity entity, World world, double range) {
        Deque<BlockPos> placeable = this.getBlocksToPlaceAt(entity, range);
        boolean discard = false;
        Iterator<BlockPos> iterator = placeable.iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            if (discard) {
                iterator.remove();
                continue;
            }
            if (world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) continue;
            discard = true;
            iterator.remove();
        }
        return placeable;
    }

    private Deque<BlockPos> getBlocksToPlaceAt(Entity entity, double range) {
        double cmpTo;
        int cmpFrom;
        RayTraceResult rtr = this.getLookBlock(entity, false, true, range);
        if (rtr == null) {
            return Lists.newLinkedList();
        }
        LinkedList blocks = Lists.newLinkedList();
        EnumFacing sideHit = rtr.field_178784_b;
        BlockPos hitPos = rtr.func_178782_a();
        switch (sideHit.func_176740_k()) {
            case X: {
                cmpFrom = hitPos.func_177958_n();
                cmpTo = entity.field_70165_t;
                break;
            }
            case Y: {
                cmpFrom = hitPos.func_177956_o();
                cmpTo = entity.field_70163_u;
                break;
            }
            case Z: {
                cmpFrom = hitPos.func_177952_p();
                cmpTo = entity.field_70161_v;
                break;
            }
            default: {
                return Lists.newLinkedList();
            }
        }
        int length = (int)Math.min(20.0, Math.abs((double)cmpFrom + 0.5 - cmpTo));
        for (int i = 1; i < length; ++i) {
            blocks.add(hitPos.func_177967_a(sideHit, i));
        }
        return blocks;
    }
}

