/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.client;

import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PktRequestSeed
implements IMessage,
IMessageHandler<PktRequestSeed, PktRequestSeed> {
    private int dimId;
    private int session;
    private long seed;

    public PktRequestSeed() {
    }

    public PktRequestSeed(int session, int dimId) {
        this.dimId = dimId;
        this.session = session;
        this.seed = -1L;
    }

    private PktRequestSeed seed(long seed) {
        this.seed = seed;
        return this;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimId = buf.readInt();
        this.session = buf.readInt();
        this.seed = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimId);
        buf.writeInt(this.session);
        buf.writeLong(this.seed);
    }

    public PktRequestSeed onMessage(PktRequestSeed message, MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            WorldProvider mgr = DimensionManager.getProvider((int)message.dimId);
            return new PktRequestSeed(message.session, message.dimId).seed(mgr.getSeed());
        }
        ConstellationSkyHandler.getInstance().updateSeedCache(message.dimId, message.session, message.seed);
        return null;
    }
}

