/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.block.BlockCustomOre;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectAevitas;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectDiscidia;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectFornax;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectHorologium;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectOctans;
import hellfirepvp.astralsorcery.common.entities.EntityFlare;
import hellfirepvp.astralsorcery.common.entities.EntityItemStardust;
import hellfirepvp.astralsorcery.common.item.tool.ItemWand;
import hellfirepvp.astralsorcery.common.item.wand.ItemArchitectWand;
import hellfirepvp.astralsorcery.common.potion.PotionCheatDeath;
import hellfirepvp.astralsorcery.common.starlight.network.handlers.BlockTransmutationHandler;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.TileCelestialCrystals;
import hellfirepvp.astralsorcery.common.tile.TileMapDrawingTable;
import hellfirepvp.astralsorcery.common.tile.TileTreeBeacon;
import hellfirepvp.astralsorcery.common.tile.TileWell;
import hellfirepvp.astralsorcery.common.tile.network.TileCollectorCrystal;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.effect.CelestialStrike;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktParticleEvent
implements IMessage,
IMessageHandler<PktParticleEvent, IMessage> {
    private int typeOrdinal;
    private double xCoord;
    private double yCoord;
    private double zCoord;
    private double additionalData = 0.0;

    public PktParticleEvent() {
    }

    public PktParticleEvent(ParticleEventType type, Vec3i vec) {
        this(type, vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public PktParticleEvent(ParticleEventType type, Vector3 vec) {
        this(type, vec.getX(), vec.getY(), vec.getZ());
    }

    public PktParticleEvent(ParticleEventType type, double x, double y, double z) {
        this.typeOrdinal = type.ordinal();
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    public void setAdditionalData(double additionalData) {
        this.additionalData = additionalData;
    }

    public double getAdditionalData() {
        return this.additionalData;
    }

    public void fromBytes(ByteBuf buf) {
        this.typeOrdinal = buf.readInt();
        this.xCoord = buf.readDouble();
        this.yCoord = buf.readDouble();
        this.zCoord = buf.readDouble();
        this.additionalData = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.typeOrdinal);
        buf.writeDouble(this.xCoord);
        buf.writeDouble(this.yCoord);
        buf.writeDouble(this.zCoord);
        buf.writeDouble(this.additionalData);
    }

    public IMessage onMessage(PktParticleEvent message, MessageContext ctx) {
        try {
            ParticleEventType type = ParticleEventType.values()[message.typeOrdinal];
            EventAction trigger = type.getTrigger(ctx.side);
            if (trigger != null) {
                this.triggerClientside(trigger, message);
            }
        }
        catch (Exception exc) {
            AstralSorcery.log.warn("Error executing ParticleEventType " + message.typeOrdinal + " at " + this.xCoord + ", " + this.yCoord + ", " + this.zCoord);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void triggerClientside(EventAction trigger, PktParticleEvent message) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        AstralSorcery.proxy.scheduleClientside(() -> trigger.trigger(message));
    }

    public Vector3 getVec() {
        return new Vector3(this.xCoord, this.yCoord, this.zCoord);
    }

    private static interface EventAction {
        public void trigger(PktParticleEvent var1);
    }

    public static enum ParticleEventType {
        COLLECTOR_BURST,
        CELESTIAL_CRYSTAL_BURST,
        CELESTIAL_CRYSTAL_FORM,
        CRAFT_FINISH_BURST,
        STARMETAL_ORE_CHARGE,
        TRANSMUTATION_CHARGE,
        WELL_CATALYST_BREAK,
        WAND_CRYSTAL_HIGHLIGHT,
        PHOENIX_PROC,
        TREE_VORTEX,
        ARCHITECT_PLACE,
        CEL_STRIKE,
        BURN_PARCHMENT,
        ENGRAVE_LENS,
        CE_CROP_INTERACT,
        CE_MELT_BLOCK,
        CE_ACCEL_TILE,
        CE_DMG_ENTITY,
        CE_WATER_FISH,
        FLARE_PROC,
        RT_DEBUG;


        @SideOnly(value=Side.CLIENT)
        private static EventAction getClientTrigger(ParticleEventType type) {
            switch (type) {
                case COLLECTOR_BURST: {
                    return TileCollectorCrystal::breakParticles;
                }
                case CELESTIAL_CRYSTAL_BURST: {
                    return TileCelestialCrystals::breakParticles;
                }
                case CELESTIAL_CRYSTAL_FORM: {
                    return EntityItemStardust::spawnFormationParticles;
                }
                case CRAFT_FINISH_BURST: {
                    return TileAltar::finishBurst;
                }
                case STARMETAL_ORE_CHARGE: {
                    return BlockCustomOre::playStarmetalOreEffects;
                }
                case TRANSMUTATION_CHARGE: {
                    return BlockTransmutationHandler::playTransmutationEffects;
                }
                case WELL_CATALYST_BREAK: {
                    return TileWell::catalystBurst;
                }
                case WAND_CRYSTAL_HIGHLIGHT: {
                    return ItemWand::highlightEffects;
                }
                case PHOENIX_PROC: {
                    return PotionCheatDeath::playEntityDeathEffect;
                }
                case CE_CROP_INTERACT: {
                    return CEffectAevitas::playParticles;
                }
                case ARCHITECT_PLACE: {
                    return ItemArchitectWand::playArchitectPlaceEvent;
                }
                case CE_MELT_BLOCK: {
                    return CEffectFornax::playParticles;
                }
                case FLARE_PROC: {
                    return EntityFlare::playParticles;
                }
                case CE_ACCEL_TILE: {
                    return CEffectHorologium::playParticles;
                }
                case CE_DMG_ENTITY: {
                    return CEffectDiscidia::playParticles;
                }
                case CE_WATER_FISH: {
                    return CEffectOctans::playParticles;
                }
                case TREE_VORTEX: {
                    return TileTreeBeacon::playParticles;
                }
                case RT_DEBUG: {
                    return RaytraceAssist::playDebug;
                }
                case CEL_STRIKE: {
                    return CelestialStrike::playEffects;
                }
                case BURN_PARCHMENT: {
                    return TileMapDrawingTable::burnParchmentEffects;
                }
                case ENGRAVE_LENS: {
                    return TileMapDrawingTable::engraveLensEffects;
                }
            }
            return null;
        }

        public EventAction getTrigger(Side side) {
            if (!side.isClient()) {
                return null;
            }
            return ParticleEventType.getClientTrigger(this);
        }
    }
}

