/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.util.ItemColorizationHelper;
import hellfirepvp.astralsorcery.common.crafting.helper.CraftingAccessManager;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.SerializeableRecipe;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktSyncMinetweakerChanges
implements IMessage,
IMessageHandler<PktSyncMinetweakerChanges, IMessage> {
    public SerializeableRecipe recipe;

    public PktSyncMinetweakerChanges() {
    }

    public PktSyncMinetweakerChanges(SerializeableRecipe recipe) {
        this.recipe = recipe;
    }

    public void fromBytes(ByteBuf buf) {
        int ordType = buf.readInt();
        SerializeableRecipe.CraftingType type = SerializeableRecipe.CraftingType.values()[ordType];
        this.recipe = type.newInstance();
        this.recipe.read(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.recipe.getType().ordinal());
        this.recipe.write(buf);
    }

    public IMessage onMessage(PktSyncMinetweakerChanges p, MessageContext ctx) {
        p.recipe.applyClient();
        return null;
    }

    public static class Compound
    implements IMessage,
    IMessageHandler<Compound, IMessage> {
        public List<PktSyncMinetweakerChanges> parts = Lists.newArrayList();

        public void fromBytes(ByteBuf buf) {
            int count = buf.readInt();
            for (int i = 0; i < count; ++i) {
                PktSyncMinetweakerChanges pkt = new PktSyncMinetweakerChanges();
                pkt.fromBytes(buf);
                this.parts.add(pkt);
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.parts.size());
            for (PktSyncMinetweakerChanges change : this.parts) {
                change.toBytes(buf);
            }
        }

        public IMessage onMessage(Compound p, MessageContext ctx) {
            CraftingAccessManager.clearModifications();
            for (PktSyncMinetweakerChanges change : p.parts) {
                change.onMessage(change, ctx);
            }
            CraftingAccessManager.compile();
            if (p.parts.size() > 0) {
                this.reloadColors();
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private void reloadColors() {
            ItemColorizationHelper.instance.reloadRegistry();
        }
    }
}

