/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import hellfirepvp.astralsorcery.common.base.CelestialGatewaySystem;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PktUpdateGateways
implements IMessage,
IMessageHandler<PktUpdateGateways, IMessage> {
    private Map<Integer, List<BlockPos>> positions;

    public PktUpdateGateways() {
    }

    public PktUpdateGateways(Map<Integer, List<BlockPos>> positions) {
        this.positions = positions;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.positions = new HashMap<Integer, List<BlockPos>>(size);
        for (int i = 0; i < size; ++i) {
            int dimId = buf.readInt();
            int posSize = buf.readInt();
            ArrayList<BlockPos> posList = new ArrayList<BlockPos>(posSize);
            for (int j = 0; j < posSize; ++j) {
                posList.add(ByteBufUtils.readPos(buf));
            }
            this.positions.put(dimId, posList);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.positions.size());
        for (Integer dimKey : this.positions.keySet()) {
            buf.writeInt(dimKey.intValue());
            List<BlockPos> l = this.positions.get(dimKey);
            buf.writeInt(l.size());
            for (BlockPos pos : l) {
                ByteBufUtils.writePos(buf, pos);
            }
        }
    }

    public IMessage onMessage(PktUpdateGateways message, MessageContext ctx) {
        CelestialGatewaySystem.instance.updateClientCache(message.positions);
        return null;
    }
}

