/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.network;

import hellfirepvp.astralsorcery.common.block.network.IBlockStarlightRecipient;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.data.DataLightBlockEndpoints;
import hellfirepvp.astralsorcery.common.data.DataLightConnections;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import hellfirepvp.astralsorcery.common.starlight.IIndependentStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightNetworkRegistry;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionChain;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionReceiver;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class TransmissionWorldHandler {
    private static final Random rand = new Random();
    private Map<ChunkPos, List<IIndependentStarlightSource>> involvedSourceMap = new HashMap<ChunkPos, List<IIndependentStarlightSource>>();
    private Map<IIndependentStarlightSource, List<ChunkPos>> activeChunkMap = new HashMap<IIndependentStarlightSource, List<ChunkPos>>();
    private Map<IIndependentStarlightSource, TransmissionChain> cachedSourceChain = new HashMap<IIndependentStarlightSource, TransmissionChain>();
    private Map<BlockPos, List<IIndependentStarlightSource>> posToSourceMap = new HashMap<BlockPos, List<IIndependentStarlightSource>>();
    private List<BlockPos> sourcePosBuilding = new LinkedList<BlockPos>();
    private final Object accessLock = new Object();
    private final World world;

    public TransmissionWorldHandler(World world) {
        this.world = world;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        WorldNetworkHandler handler = WorldNetworkHandler.getNetworkHandler(this.world);
        for (Tuple<BlockPos, IIndependentStarlightSource> sourceTuple : handler.getAllSources()) {
            BlockPos at = (BlockPos)sourceTuple.key;
            IIndependentStarlightSource source = (IIndependentStarlightSource)sourceTuple.value;
            Object object = this.accessLock;
            synchronized (object) {
                List<ChunkPos> activeChunks;
                if (!this.cachedSourceChain.containsKey(source) && !this.sourcePosBuilding.contains(at)) {
                    this.sourcePosBuilding.add(at);
                    this.buildSourceNetworkThreaded(source, handler, at);
                }
                if ((activeChunks = this.activeChunkMap.get(source)) == null || activeChunks.isEmpty()) {
                    continue;
                }
                TransmissionChain chain = this.cachedSourceChain.get(source);
                double starlight = source.produceStarlightTick(this.world, at);
                IWeakConstellation type = source.getStarlightType();
                if (type == null) {
                    continue;
                }
                Map<BlockPos, Float> lossMultipliers = chain.getLossMultipliers();
                for (ITransmissionReceiver rec : chain.getEndpointsNodes()) {
                    BlockPos pos = rec.getPos();
                    Float multiplier = lossMultipliers.get(pos);
                    if (multiplier == null) continue;
                    rec.onStarlightReceive(this.world, MiscUtils.isChunkLoaded(this.world, new ChunkPos(pos)), type, starlight * (double)multiplier.floatValue());
                }
                if (starlight > 0.1) {
                    for (IPrismTransmissionNode node : chain.getTransmissionUpdateList()) {
                        node.onTransmissionTick(this.world);
                    }
                }
                for (BlockPos endPointPos : chain.getUncheckedEndpointsBlock()) {
                    if (!MiscUtils.isChunkLoaded(this.world, new ChunkPos(endPointPos))) continue;
                    IBlockState endState = this.world.func_180495_p(endPointPos);
                    Block b = endState.func_177230_c();
                    if (b instanceof IBlockStarlightRecipient) {
                        Float multiplier = lossMultipliers.get(endPointPos);
                        if (multiplier == null) continue;
                        ((IBlockStarlightRecipient)b).receiveStarlight(this.world, rand, endPointPos, type, starlight * (double)multiplier.floatValue());
                        continue;
                    }
                    StarlightNetworkRegistry.IStarlightBlockHandler handle = StarlightNetworkRegistry.getStarlightHandler(this.world, endPointPos, endState);
                    if (handle != null) {
                        Float multiplier = lossMultipliers.get(endPointPos);
                        if (multiplier == null) continue;
                        handle.receiveStarlight(this.world, rand, endPointPos, type, starlight * (double)multiplier.floatValue());
                        continue;
                    }
                    chain.updatePosAsResolved(this.world, endPointPos);
                }
            }
        }
    }

    private void buildSourceNetworkThreaded(IIndependentStarlightSource source, WorldNetworkHandler handler, BlockPos sourcePos) {
        TransmissionChain.threadedBuildTransmissionChain(this, source, handler, sourcePos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void threadTransmissionChainCallback(TransmissionChain chain, IIndependentStarlightSource source, WorldNetworkHandler handle, BlockPos sourcePos) {
        Object object = this.accessLock;
        synchronized (object) {
            List<IIndependentStarlightSource> sources;
            this.sourcePosBuilding.remove(sourcePos);
            this.cachedSourceChain.put(source, chain);
            LinkedList<ChunkPos> activeChunks = new LinkedList<ChunkPos>();
            for (ChunkPos chunkPos : chain.getInvolvedChunks()) {
                sources = this.involvedSourceMap.get(chunkPos);
                if (sources == null) {
                    sources = new LinkedList<IIndependentStarlightSource>();
                    this.involvedSourceMap.put(chunkPos, sources);
                }
                sources.add(source);
                if (!MiscUtils.isChunkLoaded(this.world, chunkPos)) continue;
                activeChunks.add(chunkPos);
            }
            if (!activeChunks.isEmpty()) {
                this.activeChunkMap.put(source, activeChunks);
            }
            for (BlockPos blockPos : chain.getLossMultipliers().keySet()) {
                sources = this.posToSourceMap.get(blockPos);
                if (sources == null) {
                    sources = new LinkedList<IIndependentStarlightSource>();
                    this.posToSourceMap.put(blockPos, sources);
                }
                sources.add(source);
            }
            List<IIndependentStarlightSource> sources2 = this.posToSourceMap.get(sourcePos);
            if (sources2 == null) {
                sources2 = new LinkedList<IIndependentStarlightSource>();
                this.posToSourceMap.put(sourcePos, sources2);
            }
            sources2.add(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTransmissionNodeChange(IPrismTransmissionNode node) {
        BlockPos pos = node.getPos();
        Object object = this.accessLock;
        synchronized (object) {
            List<IIndependentStarlightSource> sources = this.posToSourceMap.get(pos);
            if (sources != null) {
                new ArrayList<IIndependentStarlightSource>(sources).forEach(this::breakSourceNetwork);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakSourceNetwork(IIndependentStarlightSource source) {
        Object object = this.accessLock;
        synchronized (object) {
            TransmissionChain knownChain = this.cachedSourceChain.get(source);
            if (knownChain != null) {
                List<IIndependentStarlightSource> sources;
                for (ChunkPos chPos : knownChain.getInvolvedChunks()) {
                    sources = this.involvedSourceMap.get(chPos);
                    if (sources == null) continue;
                    sources.remove(source);
                    if (!sources.isEmpty()) continue;
                    this.involvedSourceMap.remove(chPos);
                }
                for (BlockPos pos : knownChain.getLossMultipliers().keySet()) {
                    sources = this.posToSourceMap.get(pos);
                    if (sources == null) continue;
                    sources.remove(source);
                    if (!sources.isEmpty()) continue;
                    this.posToSourceMap.remove(pos);
                }
                Thread tr = new Thread(() -> {
                    DataLightConnections connections = (DataLightConnections)SyncDataHolder.getDataServer("StarlightNetworkConnections");
                    connections.removeOldConnectionsThreaded(this.world.field_73011_w.getDimension(), knownChain.getFoundConnections());
                });
                tr.start();
                Thread t = new Thread(() -> {
                    DataLightBlockEndpoints connections = (DataLightBlockEndpoints)SyncDataHolder.getDataServer("StarlightNetworkEndpoints");
                    connections.removeEndpoints(this.world.field_73011_w.getDimension(), knownChain.getResolvedNormalBlockPositions());
                });
                t.start();
            }
            this.activeChunkMap.remove(source);
            this.cachedSourceChain.remove(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informChunkUnload(ChunkPos pos) {
        Object object = this.accessLock;
        synchronized (object) {
            List<IIndependentStarlightSource> sources = this.involvedSourceMap.get(pos);
            if (sources != null) {
                for (IIndependentStarlightSource source : sources) {
                    List<ChunkPos> activeChunks = this.activeChunkMap.get(source);
                    if (activeChunks == null) continue;
                    activeChunks.remove(pos);
                    if (!activeChunks.isEmpty()) continue;
                    this.activeChunkMap.remove(source);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informChunkLoad(ChunkPos pos) {
        Object object = this.accessLock;
        synchronized (object) {
            List<IIndependentStarlightSource> sources = this.involvedSourceMap.get(pos);
            if (sources != null) {
                for (IIndependentStarlightSource source : sources) {
                    List<Object> positions;
                    TransmissionChain chain = this.cachedSourceChain.get(source);
                    if (chain == null || !chain.getInvolvedChunks().contains(pos)) continue;
                    if (this.activeChunkMap.containsKey(source)) {
                        positions = this.activeChunkMap.get(source);
                        if (positions.contains(pos)) continue;
                        positions.add(pos);
                        continue;
                    }
                    positions = new LinkedList<ChunkPos>();
                    positions.add(pos);
                    this.activeChunkMap.put(source, positions);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(int dimId) {
        Object object = this.accessLock;
        synchronized (object) {
            this.activeChunkMap.clear();
            this.cachedSourceChain.clear();
            this.involvedSourceMap.clear();
            this.posToSourceMap.clear();
            DataLightConnections connections = (DataLightConnections)SyncDataHolder.getDataServer("StarlightNetworkConnections");
            connections.clearDimensionPositions(dimId);
            DataLightBlockEndpoints endpoints = (DataLightBlockEndpoints)SyncDataHolder.getDataServer("StarlightNetworkEndpoints");
            endpoints.clearDimensionEndpoints(dimId);
        }
    }
}

