/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.transmission.base.crystal;

import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.starlight.IIndependentStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.IStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleIndependentSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.SourceClassRegistry;
import hellfirepvp.astralsorcery.common.tile.base.TileNetworkSkybound;
import hellfirepvp.astralsorcery.common.tile.base.TileSourceBase;
import hellfirepvp.astralsorcery.common.tile.network.TileCollectorCrystal;
import hellfirepvp.astralsorcery.common.util.CrystalCalculations;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.SkyCollectionHelper;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class IndependentCrystalSource
extends SimpleIndependentSource {
    public static final double MIN_DST = 16.0;
    private float posDistribution = -1.0f;
    private CrystalProperties crystalProperties;
    private BlockCollectorCrystalBase.CollectorCrystalType type;
    private boolean doesSeeSky;
    private boolean structural;
    private double collectionDstMultiplier = 1.0;
    private boolean enhanced = false;

    public IndependentCrystalSource(CrystalProperties properties, IWeakConstellation constellation, boolean seesSky, boolean hasBeenLinkedBefore, BlockCollectorCrystalBase.CollectorCrystalType type) {
        super(constellation);
        this.crystalProperties = properties;
        this.doesSeeSky = seesSky;
        this.type = type;
        this.structural = hasBeenLinkedBefore;
    }

    @Override
    public float produceStarlightTick(World world, BlockPos pos) {
        IWeakConstellation cst = this.getStarlightType();
        if (cst == null) {
            return 0.0f;
        }
        if (this.crystalProperties == null || this.type == null) {
            return 0.0f;
        }
        WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler(world);
        if (!this.doesSeeSky || handle == null) {
            return 0.0f;
        }
        if (this.posDistribution == -1.0f) {
            this.posDistribution = SkyCollectionHelper.getSkyNoiseDistribution(world, pos);
        }
        Function<Float, Float> distrFunction = this.getDistributionFunc();
        double perc = distrFunction.apply(Float.valueOf(ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(world))).floatValue();
        perc *= this.collectionDstMultiplier;
        return (float)((perc *= 0.7 + 0.3 * (double)this.posDistribution) * (double)CrystalCalculations.getCollectionAmt(this.crystalProperties, handle.getCurrentDistribution(cst, distrFunction).floatValue()));
    }

    public void setEnhanced(boolean enhanced) {
        this.enhanced = enhanced;
    }

    private Function<Float, Float> getDistributionFunc() {
        if (this.enhanced) {
            return in -> Float.valueOf(0.6f + 1.1f * in.floatValue());
        }
        return in -> Float.valueOf(0.2f + 0.8f * in.floatValue());
    }

    @Override
    public boolean providesAutoLink() {
        return this.structural;
    }

    @Override
    public void informTileStateChange(IStarlightSource sourceTile) {
        TileNetworkSkybound tns = MiscUtils.getTileAt((IBlockAccess)sourceTile.getTrWorld(), sourceTile.getTrPos(), TileNetworkSkybound.class, true);
        if (tns != null) {
            this.doesSeeSky = tns.doesSeeSky();
        }
        if (tns instanceof TileSourceBase && ((TileSourceBase)tns).hasBeenLinked()) {
            this.structural = true;
        }
        if (tns instanceof TileCollectorCrystal) {
            this.crystalProperties = ((TileCollectorCrystal)tns).getCrystalProperties();
            this.type = ((TileCollectorCrystal)tns).getType();
            this.starlightType = ((TileCollectorCrystal)tns).getConstellation();
        }
    }

    @Override
    public void threadedUpdateProximity(BlockPos thisPos, Map<BlockPos, IIndependentStarlightSource> otherSources) {
        double minDstSq = Double.MAX_VALUE;
        for (BlockPos other : otherSources.keySet()) {
            double dstSq;
            if (other.equals((Object)thisPos) || !((dstSq = thisPos.func_177951_i((Vec3i)other)) < minDstSq)) continue;
            minDstSq = dstSq;
        }
        double dst = Math.sqrt(minDstSq);
        this.collectionDstMultiplier = dst <= 16.0 ? dst / 16.0 : 1.0;
    }

    @Override
    public SourceClassRegistry.SourceProvider getProvider() {
        return new Provider();
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.crystalProperties = CrystalProperties.readFromNBT(compound);
        this.doesSeeSky = compound.func_74767_n("seesSky");
        this.structural = compound.func_74767_n("linkedBefore");
        this.type = BlockCollectorCrystalBase.CollectorCrystalType.values()[compound.func_74762_e("collectorType")];
        this.collectionDstMultiplier = compound.func_74769_h("dstMul");
        this.enhanced = compound.func_74767_n("enhanced");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.crystalProperties != null) {
            this.crystalProperties.writeToNBT(compound);
        }
        compound.func_74757_a("seesSky", this.doesSeeSky);
        compound.func_74757_a("linkedBefore", this.structural);
        compound.func_74768_a("collectorType", this.type == null ? 0 : this.type.ordinal());
        compound.func_74780_a("dstMul", this.collectionDstMultiplier);
        compound.func_74757_a("enhanced", this.enhanced);
    }

    public static class Provider
    implements SourceClassRegistry.SourceProvider {
        @Override
        public IIndependentStarlightSource provideEmptySource() {
            return new IndependentCrystalSource(null, null, false, false, null);
        }

        @Override
        public String getIdentifier() {
            return "astralsorcery:IndependentCrystalSource";
        }
    }
}

