/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.base.TileInventoryBase;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTUtils;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

public class TileAttunementRelay
extends TileInventoryBase {
    private static final float MAX_DST = (float)(Math.sqrt(Math.sqrt(2.0) + 1.0) * 16.0);
    private BlockPos linked = null;
    private float collectionMultiplier = 1.0f;
    private boolean canSeeSky = false;
    private boolean hasMultiblock = false;

    public TileAttunementRelay() {
        super(1);
    }

    public void updatePositionData(@Nullable BlockPos closestAltar, double dstSqOtherRelay) {
        this.linked = closestAltar;
        this.collectionMultiplier = (dstSqOtherRelay = Math.sqrt(dstSqOtherRelay)) <= 1.0E-4 ? 1.0f : 1.0f - (float)(MathHelper.func_151237_a((double)dstSqOtherRelay, (double)0.0, (double)MAX_DST) / (double)MAX_DST);
        this.markForUpdate();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if ((this.ticksExisted & 0xF) == 0) {
            this.updateSkyState();
        }
        if ((this.ticksExisted & 0x1F) == 0) {
            this.updateMultiblockState();
        }
        ItemStack slotted = this.getInventoryHandler().getStackInSlot(0);
        if (!this.field_145850_b.field_72995_K) {
            if (slotted != null) {
                if (!this.field_145850_b.func_175623_d(this.field_174879_c.func_177984_a())) {
                    ItemStack in = this.getInventoryHandler().getStackInSlot(0);
                    ItemStack out = ItemUtils.copyStackWithSize(in, in.field_77994_a);
                    ItemUtils.dropItem(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), out);
                    this.getInventoryHandler().setStackInSlot(0, null);
                }
                if (ItemUtils.matchStackLoosely(slotted, ItemCraftingComponent.MetaType.GLASS_LENS.asStack()) && this.linked != null) {
                    TileAltar ta = MiscUtils.getTileAt((IBlockAccess)this.field_145850_b, this.linked, TileAltar.class, true);
                    if (ta == null) {
                        this.linked = null;
                        this.markForUpdate();
                    } else if (this.hasMultiblock && this.doesSeeSky()) {
                        WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler(this.func_145831_w());
                        int yLevel = this.func_174877_v().func_177956_o();
                        if (handle != null && yLevel > 40) {
                            double coll = 0.2;
                            float dstr = yLevel > 140 ? 1.0f : (float)(yLevel - 40) / 100.0f;
                            coll *= (double)dstr;
                            coll *= (double)this.collectionMultiplier;
                            ta.receiveStarlight(null, coll *= 0.2 + 0.8 * (double)ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(this.func_145831_w()));
                        }
                    }
                }
            }
        } else if (slotted != null && this.hasMultiblock && ItemUtils.matchStackLoosely(slotted, ItemCraftingComponent.MetaType.GLASS_LENS.asStack())) {
            Vector3 at;
            if (rand.nextInt(3) == 0) {
                at = new Vector3(this);
                at.add((double)rand.nextFloat() * 2.6 - 0.8, 0.0, (double)rand.nextFloat() * 2.6 - 0.8);
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
                p.setAlphaMultiplier(0.7f);
                p.setMaxAge((int)(30.0f + rand.nextFloat() * 50.0f));
                p.gravity(0.01).scale(0.3f + rand.nextFloat() * 0.1f);
                if (rand.nextBoolean()) {
                    p.setColor(Color.WHITE);
                }
            }
            if (this.linked != null && this.doesSeeSky() && rand.nextInt(4) == 0) {
                at = new Vector3(this);
                Vector3 dir = new Vector3(this.linked).subtract(new Vector3(this)).normalize().multiply(0.05);
                at.add((double)rand.nextFloat() * 0.4 + 0.3, (double)rand.nextFloat() * 0.3 + 0.1, (double)rand.nextFloat() * 0.4 + 0.3);
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
                p.setAlphaMultiplier(0.7f);
                p.motion(dir.getX(), dir.getY(), dir.getZ());
                p.setMaxAge((int)(15.0f + rand.nextFloat() * 30.0f));
                p.gravity(0.015).scale(0.2f + rand.nextFloat() * 0.04f);
                if (rand.nextBoolean()) {
                    p.setColor(Color.WHITE);
                }
            }
        }
    }

    private void updateMultiblockState() {
        boolean found = MultiBlockArrays.patternCollectorRelay.matches(this.field_145850_b, this.func_174877_v());
        boolean update = this.hasMultiblock != found;
        this.hasMultiblock = found;
        if (update) {
            this.markForUpdate();
        }
    }

    private void updateSkyState() {
        boolean seesSky = this.field_145850_b.func_175678_i(this.func_174877_v());
        boolean update = this.canSeeSky != seesSky;
        this.canSeeSky = seesSky;
        if (update) {
            this.markForUpdate();
        }
    }

    public boolean doesSeeSky() {
        return this.canSeeSky;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74757_a("seesSky", this.canSeeSky);
        compound.func_74757_a("mbState", this.hasMultiblock);
        compound.func_74776_a("colMultiplier", this.collectionMultiplier);
        if (this.linked != null) {
            NBTTagCompound pos = new NBTTagCompound();
            NBTUtils.writeBlockPosToNBT(this.linked, pos);
            compound.func_74782_a("linked", (NBTBase)pos);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.canSeeSky = compound.func_74767_n("seesSky");
        this.hasMultiblock = compound.func_74767_n("mbState");
        this.collectionMultiplier = compound.func_74760_g("colMultiplier");
        this.linked = compound.func_74764_b("linked") ? NBTUtils.readBlockPosFromNBT(compound.func_74775_l("linked")) : null;
    }
}

