/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXCrystalBurst;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.block.BlockCelestialCrystals;
import hellfirepvp.astralsorcery.common.block.BlockCustomOre;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.data.DataActiveCelestials;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.tile.base.TileSkybound;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileCelestialCrystals
extends TileSkybound {
    private static final Random rand = new Random();

    public int getGrowth() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (!(state.func_177230_c() instanceof BlockCelestialCrystals)) {
            return 0;
        }
        return (Integer)state.func_177229_b((IProperty)BlockCelestialCrystals.STAGE);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            double mul = 1.0;
            IBlockState downState = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b());
            if (downState.func_177230_c() == BlocksAS.customOre && downState.func_177229_b(BlockCustomOre.ORE_TYPE) == BlockCustomOre.OreType.STARMETAL) {
                mul *= 0.3;
                if (rand.nextInt(300) == 0) {
                    this.field_145850_b.func_175656_a(this.func_174877_v().func_177977_b(), Blocks.field_150366_p.func_176223_P());
                }
            }
            this.tryGrowth(mul);
        } else {
            IBlockState downState = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b());
            if (downState.func_177230_c() == BlocksAS.customOre && downState.func_177229_b(BlockCustomOre.ORE_TYPE) == BlockCustomOre.OreType.STARMETAL) {
                this.playStarmetalOreParticles();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playStarmetalOreParticles() {
        if (rand.nextInt(5) == 0) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle((float)this.field_174879_c.func_177958_n() + rand.nextFloat(), (float)this.field_174879_c.func_177977_b().func_177956_o() + rand.nextFloat(), (float)this.field_174879_c.func_177952_p() + rand.nextFloat());
            p.motion(0.0, (double)rand.nextFloat() * 0.05, 0.0);
            p.scale(0.2f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void breakParticles(PktParticleEvent event) {
        BlockPos at = event.getVec().toBlockPos();
        int id = 19;
        id ^= at.func_177958_n();
        id ^= at.func_177956_o();
        EffectHandler.getInstance().registerFX(new EntityFXCrystalBurst(id ^= at.func_177952_p(), (double)at.func_177958_n() + 0.5, (double)at.func_177956_o() + 0.2, (double)at.func_177952_p() + 0.5, 1.5f));
    }

    @Override
    protected void onFirstTick() {
    }

    public void grow() {
        IBlockState current = this.field_145850_b.func_180495_p(this.func_174877_v());
        int stage = (Integer)current.func_177229_b((IProperty)BlockCelestialCrystals.STAGE);
        if (stage < 4) {
            IBlockState next = BlocksAS.celestialCrystals.func_176203_a(stage + 1);
            this.field_145850_b.func_175656_a(this.func_174877_v(), next);
        }
    }

    public void tryGrowth(double mul) {
        double dstr;
        int r = 24000;
        WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler(this.field_145850_b);
        if (this.doesSeeSky() && handle != null && (dstr = (double)ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(this.field_145850_b)) > 0.0) {
            Collection<IConstellation> activeConstellations = ((DataActiveCelestials)SyncDataHolder.getDataClient("AstralConstellations")).getActiveConstellations(this.field_145850_b.field_73011_w.getDimension());
            if (activeConstellations != null) {
                r = 9500;
            }
            r = (int)((double)r * (0.5 + (1.0 - dstr) * 0.5));
        }
        r = (int)((double)r * Math.abs(mul));
        if (this.field_145850_b.field_73012_v.nextInt(Math.max(r = Math.max(1, r), 1)) == 0) {
            this.grow();
        }
    }
}

