/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.compound.CompoundEffectSphere;
import hellfirepvp.astralsorcery.client.effect.compound.CompoundGatewayShield;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.GatewayCache;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileCelestialGateway
extends TileEntityTick {
    private boolean hasMultiblock = false;
    private boolean doesSeeSky = false;
    private boolean gatewayRegistered = false;
    private Object clientSphere = null;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.playEffects();
        } else {
            if ((this.ticksExisted & 0xF) == 0) {
                this.updateSkyState(this.field_145850_b.func_175678_i(this.func_174877_v().func_177984_a()));
            }
            if ((this.ticksExisted & 0xF) == 0) {
                this.updateMultiblockState(MultiBlockArrays.patternCelestialGateway.matches(this.field_145850_b, this.field_174879_c));
            }
            if (this.gatewayRegistered) {
                if (!this.hasMultiblock() || !this.doesSeeSky()) {
                    GatewayCache cache = (GatewayCache)WorldCacheManager.getOrLoadData(this.field_145850_b, WorldCacheManager.SaveKey.GATEWAY_DATA);
                    cache.removePosition(this.field_145850_b, this.field_174879_c);
                    this.gatewayRegistered = false;
                }
            } else if (this.hasMultiblock() && this.doesSeeSky()) {
                GatewayCache cache = (GatewayCache)WorldCacheManager.getOrLoadData(this.field_145850_b, WorldCacheManager.SaveKey.GATEWAY_DATA);
                cache.offerPosition(this.field_145850_b, this.field_174879_c);
                this.gatewayRegistered = true;
            }
        }
    }

    @Override
    protected void onFirstTick() {
    }

    private void updateMultiblockState(boolean matches) {
        boolean update = this.hasMultiblock != matches;
        this.hasMultiblock = matches;
        if (update) {
            this.markForUpdate();
        }
    }

    private void updateSkyState(boolean seeSky) {
        boolean update = this.doesSeeSky != seeSky;
        this.doesSeeSky = seeSky;
        if (update) {
            this.markForUpdate();
        }
    }

    public boolean hasMultiblock() {
        return this.hasMultiblock;
    }

    public boolean doesSeeSky() {
        return this.doesSeeSky;
    }

    @SideOnly(value=Side.CLIENT)
    private void playEffects() {
        boolean prec = this.hasMultiblock && this.doesSeeSky;
        this.setupGatewayUI(prec);
        if (prec) {
            this.playFrameParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void setupGatewayUI(boolean preconditionsFulfilled) {
        if (preconditionsFulfilled) {
            Vector3 sphereVec = new Vector3(this.field_174879_c).add(0.5, 1.62, 0.5);
            if (this.clientSphere == null) {
                CompoundGatewayShield sphere = new CompoundGatewayShield(sphereVec.clone(), Vector3.RotAxis.Y_AXIS, 6.0, 8, 10);
                sphere.setRemoveIfInvisible(true).setAlphaFadeDistance(4.0);
                EffectHandler.getInstance().registerFX(sphere);
                this.clientSphere = sphere;
            }
            double playerDst = new Vector3((Entity)Minecraft.func_71410_x().field_71439_g).distance(sphereVec);
            if (this.clientSphere != null) {
                if (!((CompoundEffectSphere)this.clientSphere).getPosition().equals(sphereVec)) {
                    ((CompoundEffectSphere)this.clientSphere).requestRemoval();
                    CompoundGatewayShield sphere = new CompoundGatewayShield(sphereVec.clone(), Vector3.RotAxis.Y_AXIS, 6.0, 8, 10);
                    sphere.setRemoveIfInvisible(true).setAlphaFadeDistance(4.0);
                    EffectHandler.getInstance().registerFX(sphere);
                    this.clientSphere = sphere;
                }
                if (((EntityComplexFX)this.clientSphere).isRemoved() && playerDst < 5.0) {
                    EffectHandler.getInstance().registerFX((EntityComplexFX)this.clientSphere);
                }
            }
            if (playerDst < 5.5) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
            }
            if (playerDst < 2.5) {
                EffectHandler.getInstance().requestGatewayUIFor(this.field_145850_b, sphereVec, 5.5);
            }
        } else if (this.clientSphere != null && !((EntityComplexFX)this.clientSphere).isRemoved()) {
            ((EntityComplexFX)this.clientSphere).requestRemoval();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playFrameParticles() {
        for (int i = 0; i < 2; ++i) {
            Vector3 offset = new Vector3(this.field_174879_c).add(-2.0, 0.0, -2.0);
            if (rand.nextBoolean()) {
                offset.add(5 * (rand.nextBoolean() ? 1 : 0), 0.0, rand.nextFloat() * 5.0f);
            } else {
                offset.add(rand.nextFloat() * 5.0f, 0.0, 5 * (rand.nextBoolean() ? 1 : 0));
            }
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(offset.getX(), offset.getY(), offset.getZ());
            p.gravity(0.0045).scale(0.25f + rand.nextFloat() * 0.15f).setMaxAge(40 + rand.nextInt(40));
            Color c = new Color(60, 0, 255);
            switch (rand.nextInt(4)) {
                case 0: {
                    c = Color.WHITE;
                    break;
                }
                case 1: {
                    c = new Color(6927871);
                    break;
                }
                case 2: {
                    c = new Color(30975);
                }
            }
            p.setColor(c);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.hasMultiblock = compound.func_74767_n("mbState");
        this.doesSeeSky = compound.func_74767_n("skyState");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74757_a("mbState", this.hasMultiblock);
        compound.func_74757_a("skyState", this.doesSeeSky);
    }
}

