/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.client.effect.texture.TextureSpritePlane;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectRegistry;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.item.crystal.base.ItemTunedCrystalBase;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.NodeConnection;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import hellfirepvp.astralsorcery.common.tile.TileRitualLink;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBaseInventory;
import hellfirepvp.astralsorcery.common.util.CrystalCalculations;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTUtils;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileRitualPedestal
extends TileReceiverBaseInventory {
    public static final int MAX_EFFECT_TICK = 63;
    private TransmissionReceiverRitualPedestal cachePedestal = null;
    private Object spritePlane = null;
    private List<BlockPos> offsetMirrorPositions = new LinkedList<BlockPos>();
    private boolean dirty = false;
    private boolean doesSeeSky = false;
    private boolean hasMultiblock = false;
    private BlockPos ritualLink = null;
    private int effectWorkTick = 0;
    private boolean working = false;
    private UUID ownerUUID = null;

    public TileRitualPedestal() {
        super(1, EnumFacing.UP);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if ((this.ticksExisted & 0xF) == 0) {
                this.updateSkyState(this.field_145850_b.func_175678_i(this.func_174877_v()));
                this.updateLinkTile();
            }
            if ((this.ticksExisted & 0x1F) == 0) {
                this.updateMultiblockState();
            }
            if (this.dirty) {
                this.dirty = false;
                TransmissionReceiverRitualPedestal recNode = this.getUpdateCache();
                if (recNode != null) {
                    recNode.updateSkyState(this.doesSeeSky);
                    recNode.updateMultiblockState(this.hasMultiblock);
                    recNode.updateLink(this.field_145850_b, this.ritualLink);
                    recNode.markDirty(this.field_145850_b);
                }
                this.markForUpdate();
            }
        }
        if (this.working) {
            if (this.effectWorkTick < 63) {
                ++this.effectWorkTick;
            }
        } else if (this.effectWorkTick > 0) {
            --this.effectWorkTick;
        }
        if (this.field_145850_b.field_72995_K && this.working) {
            ConstellationEffect ce;
            IWeakConstellation ch;
            ItemStack crystal;
            EffectLightbeam lightbeam;
            Vector3 from;
            float alphaDaytime = ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(this.field_145850_b);
            boolean isDay = (double)(alphaDaytime *= 0.8f) <= 1.0E-4;
            int tick = this.getEffectWorkTick();
            float percRunning = (float)tick / 63.0f;
            int chance = 15 + (int)((1.0f - percRunning) * 50.0f);
            if (EffectHandler.STATIC_EFFECT_RAND.nextInt(chance) == 0) {
                from = new Vector3(this).add(0.5, 0.05, 0.5);
                MiscUtils.applyRandomOffset(from, EffectHandler.STATIC_EFFECT_RAND, 0.05f);
                lightbeam = EffectHandler.getInstance().lightbeam(from.clone().addY(6.0), from, 1.5);
                lightbeam.setAlphaMultiplier(0.5f + 0.5f * alphaDaytime);
                lightbeam.setMaxAge(64);
            }
            if (this.ritualLink != null && rand.nextBoolean()) {
                Vector3 at = new Vector3(this).add(0.0, 0.1, 0.0);
                at.add((double)rand.nextFloat() * 0.5 + 0.25, 0.0, (double)rand.nextFloat() * 0.5 + 0.25);
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
                p.setAlphaMultiplier(0.7f).setColor(Color.WHITE);
                p.setMaxAge((int)(30.0f + rand.nextFloat() * 50.0f));
                p.gravity(0.09).scale(0.3f + rand.nextFloat() * 0.1f);
            }
            if (this.shouldDoAdditionalEffects() && !isDay && EffectHandler.STATIC_EFFECT_RAND.nextInt(chance * 2) == 0) {
                from = new Vector3(this).add(0.5, 0.1, 0.5);
                MiscUtils.applyRandomOffset(from, EffectHandler.STATIC_EFFECT_RAND, 2.0f);
                from.setY((double)this.func_174877_v().func_177956_o() - 0.6 + (double)(1.0f * EffectHandler.STATIC_EFFECT_RAND.nextFloat() * (float)(EffectHandler.STATIC_EFFECT_RAND.nextBoolean() ? 1 : -1)));
                lightbeam = EffectHandler.getInstance().lightbeam(from.clone().addY(5 + EffectHandler.STATIC_EFFECT_RAND.nextInt(3)), from, 1.3f);
                lightbeam.setAlphaMultiplier(alphaDaytime);
                lightbeam.setMaxAge(64);
            }
            if ((crystal = this.getInventoryHandler().getStackInSlot(0)) != null && crystal.func_77973_b() != null && crystal.func_77973_b() instanceof ItemTunedCrystalBase && (ch = ItemTunedCrystalBase.getMainConstellation(crystal)) != null && (ce = ConstellationEffectRegistry.clientRenderInstance(ch)) != null) {
                BlockPos to = this.func_174877_v();
                if (this.ritualLink != null) {
                    ce.playClientEffect(this.field_145850_b, this.ritualLink, this, percRunning, this.shouldDoAdditionalEffects());
                }
                ce.playClientEffect(this.field_145850_b, this.func_174877_v(), this, percRunning, this.shouldDoAdditionalEffects());
            }
            for (BlockPos expMirror : this.offsetMirrorPositions) {
                if (this.ticksExisted % 32 != 0) continue;
                Vector3 source = new Vector3(this).add(0.5, 0.75, 0.5);
                Vector3 to = new Vector3(this).add((Vec3i)expMirror).add(0.5, 0.5, 0.5);
                EffectHandler.getInstance().lightbeam(to, source, 0.8);
                if (this.ritualLink == null) continue;
                source = new Vector3(this).add(0.5, 5.5, 0.5);
                EffectLightbeam beam = EffectHandler.getInstance().lightbeam(to, source, 0.8);
                beam.setColorOverlay(Color.getHSBColor(rand.nextFloat() * 360.0f, 1.0f, 1.0f));
            }
        }
    }

    private void updateLinkTile() {
        boolean hasLinkNow;
        boolean hasLink = this.ritualLink != null;
        BlockPos link = this.func_174877_v().func_177982_a(0, 5, 0);
        TileRitualLink linkTile = MiscUtils.getTileAt((IBlockAccess)this.field_145850_b, link, TileRitualLink.class, true);
        if (linkTile != null) {
            this.ritualLink = linkTile.getLinkedTo();
            hasLinkNow = this.ritualLink != null;
        } else {
            hasLinkNow = false;
            this.ritualLink = null;
        }
        if (hasLink != hasLinkNow) {
            this.markForUpdate();
            this.flagDirty();
        }
    }

    public boolean isWorking() {
        return this.working;
    }

    public boolean hasMultiblock() {
        return this.hasMultiblock;
    }

    private void updateMultiblockState() {
        boolean found = MultiBlockArrays.patternRitualPedestal.matches(this.field_145850_b, this.func_174877_v());
        boolean update = this.hasMultiblock != found;
        this.hasMultiblock = found;
        if (update) {
            this.markForUpdate();
            this.flagDirty();
        }
    }

    public int getEffectWorkTick() {
        return this.effectWorkTick;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IWeakConstellation getDisplayConstellation() {
        if (this.offsetMirrorPositions.size() != 5) {
            return null;
        }
        return this.getRitualConstellation();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldDoAdditionalEffects() {
        return this.working && this.offsetMirrorPositions.size() > 0;
    }

    @Nullable
    public IWeakConstellation getRitualConstellation() {
        ItemStack crystal = this.getInventoryHandler().getStackInSlot(0);
        if (crystal != null && crystal.func_77973_b() != null && crystal.func_77973_b() instanceof ItemTunedCrystalBase) {
            return ItemTunedCrystalBase.getMainConstellation(crystal);
        }
        return null;
    }

    @Nullable
    public TransmissionReceiverRitualPedestal getUpdateCache() {
        if (this.cachePedestal == null) {
            this.cachePedestal = (TransmissionReceiverRitualPedestal)this.tryGetNode();
        }
        if (this.cachePedestal != null && !this.cachePedestal.getPos().equals((Object)this.func_174877_v())) {
            this.cachePedestal = null;
        }
        return this.cachePedestal;
    }

    protected void updateSkyState(boolean seesSky) {
        boolean update = this.doesSeeSky != seesSky;
        this.doesSeeSky = seesSky;
        if (update) {
            this.markForUpdate();
            this.flagDirty();
        }
    }

    public void onLoad() {
        TransmissionReceiverRitualPedestal ped;
        if (!this.field_145850_b.field_72995_K && (ped = this.getUpdateCache()) != null) {
            this.offsetMirrorPositions.clear();
            this.offsetMirrorPositions.addAll(ped.offsetMirrors.keySet());
            this.flagDirty();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public TextureSpritePlane getHaloEffectSprite() {
        TextureSpritePlane spr = (TextureSpritePlane)this.spritePlane;
        if (spr == null || spr.canRemove() || spr.isRemoved()) {
            spr = EffectHandler.getInstance().textureSpritePlane(SpriteLibrary.spriteHalo1, Vector3.RotAxis.Y_AXIS.clone());
            spr.setPosition(new Vector3(this).add(0.5, 0.06, 0.5));
            spr.setAlphaOverDistance(true);
            spr.setNoRotation(45.0f);
            spr.setRefreshFunc(() -> !this.func_145837_r() && this.working);
            spr.setScale(6.5f);
            this.spritePlane = spr;
        }
        return spr;
    }

    @Override
    protected void onInventoryChanged(int slotChanged) {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack in = this.getInventoryHandler().getStackInSlot(0);
            if (in != null && in.func_77973_b() != null && in.func_77973_b() instanceof ItemTunedCrystalBase) {
                CrystalProperties properties = CrystalProperties.getCrystalProperties(in);
                IWeakConstellation tuned = ItemTunedCrystalBase.getMainConstellation(in);
                IMinorConstellation trait = ItemTunedCrystalBase.getTrait(in);
                TransmissionReceiverRitualPedestal recNode = this.getUpdateCache();
                if (recNode != null) {
                    recNode.updateCrystalProperties(this.field_145850_b, properties, tuned, trait);
                } else {
                    AstralSorcery.log.warn("[AstralSorcery] Updated inventory and tried to update pedestal state.");
                    AstralSorcery.log.warn("[AstralSorcery] Tried to find receiver node at dimId=" + this.field_145850_b.field_73011_w.getDimension() + " pos=" + this.func_174877_v() + " - couldn't find it.");
                }
            } else {
                TransmissionReceiverRitualPedestal recNode = this.getUpdateCache();
                if (recNode != null) {
                    recNode.updateCrystalProperties(this.field_145850_b, null, null, null);
                } else {
                    AstralSorcery.log.warn("[AstralSorcery] Updated inventory and tried to update pedestal state.");
                    AstralSorcery.log.warn("[AstralSorcery] Tried to find receiver node at dimId=" + this.field_145850_b.field_73011_w.getDimension() + " pos=" + this.func_174877_v() + " - couldn't find it.");
                }
            }
            this.markForUpdate();
        }
    }

    private void updatePositions(Collection<BlockPos> offsetMirrors) {
        this.offsetMirrorPositions.clear();
        this.offsetMirrorPositions.addAll(offsetMirrors);
        this.markForUpdate();
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.working = compound.func_74767_n("working");
        this.ownerUUID = compound.func_74764_b("ownerMost") ? compound.func_186857_a("owner") : UUID.randomUUID();
        this.doesSeeSky = compound.func_74767_n("seesSky");
        this.hasMultiblock = compound.func_74767_n("hasMultiblock");
        this.ritualLink = compound.func_74764_b("ritualLinkPos") ? NBTUtils.readBlockPosFromNBT(compound.func_74775_l("ritualLinkPos")) : null;
        this.offsetMirrorPositions.clear();
        NBTTagList listPos = compound.func_150295_c("positions", 10);
        for (int i = 0; i < listPos.func_74745_c(); ++i) {
            this.offsetMirrorPositions.add(NBTUtils.readBlockPosFromNBT(listPos.func_150305_b(i)));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74757_a("working", this.working);
        if (this.ownerUUID != null) {
            compound.func_186854_a("owner", this.ownerUUID);
        }
        compound.func_74757_a("hasMultiblock", this.hasMultiblock);
        compound.func_74757_a("seesSky", this.doesSeeSky);
        if (this.ritualLink != null) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTUtils.writeBlockPosToNBT(this.ritualLink, tag);
            compound.func_74782_a("ritualLinkPos", (NBTBase)tag);
        }
        NBTTagList listPositions = new NBTTagList();
        for (BlockPos pos : this.offsetMirrorPositions) {
            NBTTagCompound cmp = new NBTTagCompound();
            NBTUtils.writeBlockPosToNBT(pos, cmp);
            listPositions.func_74742_a((NBTBase)cmp);
        }
        compound.func_74782_a("positions", (NBTBase)listPositions);
    }

    public void flagDirty() {
        this.dirty = true;
    }

    @Override
    @Nullable
    public String getUnLocalizedDisplayName() {
        return "tile.BlockRitualPedestal.name";
    }

    @Override
    @Nonnull
    public ITransmissionReceiver provideEndpoint(BlockPos at) {
        return new TransmissionReceiverRitualPedestal(at, this.doesSeeSky);
    }

    public void setOwner(UUID uniqueID) {
        this.ownerUUID = uniqueID;
        this.markForUpdate();
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Nullable
    public EntityPlayer getOwningPlayerInWorld(World world) {
        UUID uuid = this.getOwnerUUID();
        return uuid == null ? null : world.func_152378_a(uuid);
    }

    public static class PedestalReceiverProvider
    implements TransmissionClassRegistry.TransmissionProvider {
        @Override
        public TransmissionReceiverRitualPedestal provideEmptyNode() {
            return new TransmissionReceiverRitualPedestal(null, false);
        }

        @Override
        public String getIdentifier() {
            return "astralsorcery:TransmissionReceiverRitualPedestal";
        }
    }

    public static class TransmissionReceiverRitualPedestal
    extends SimpleTransmissionReceiver {
        private static final int MAX_MIRROR_COUNT = 5;
        private static final int[] secToNext = new int[]{10, 10, 6, 10, 10};
        private static final int[] chanceToNext = new int[]{2, 2, 2, 2, 2};
        private static final BlockPos[] possibleOffsets = new BlockPos[]{new BlockPos(4, 2, 0), new BlockPos(4, 2, 1), new BlockPos(3, 2, 2), new BlockPos(2, 2, 3), new BlockPos(1, 2, 4), new BlockPos(0, 2, 4), new BlockPos(-1, 2, 4), new BlockPos(-2, 2, 3), new BlockPos(-3, 2, 2), new BlockPos(-4, 2, 1), new BlockPos(-4, 2, 0), new BlockPos(-4, 2, -1), new BlockPos(-3, 2, -2), new BlockPos(-2, 2, -3), new BlockPos(-1, 2, -4), new BlockPos(0, 2, -4), new BlockPos(1, 2, -4), new BlockPos(2, 2, -3), new BlockPos(3, 2, -2), new BlockPos(4, 2, -1)};
        private int ticksTicking = 0;
        private boolean doesSeeSky;
        private boolean hasMultiblock;
        private BlockPos ritualLinkTo = null;
        private IWeakConstellation channeling;
        private IMinorConstellation trait;
        private CrystalProperties properties;
        private int channeled = 0;
        private ConstellationEffect ce;
        private Map<BlockPos, Boolean> offsetMirrors = new HashMap<BlockPos, Boolean>();
        private double collectionChannelBuffer = 0.0;
        private double collectionTraitBuffer = 0.0;
        private boolean doesWorkBuffer = false;

        public TransmissionReceiverRitualPedestal(BlockPos thisPos, boolean doesSeeSky) {
            super(thisPos);
            this.doesSeeSky = doesSeeSky;
        }

        @Override
        public void update(World world) {
            ++this.ticksTicking;
            if (this.channeling != null && this.properties != null && this.hasMultiblock) {
                TileRitualPedestal pedestal;
                if (this.ce == null) {
                    this.ce = this.channeling.getRitualEffect();
                }
                if (this.ticksTicking % 20 == 0) {
                    WorldNetworkHandler handle = WorldNetworkHandler.getNetworkHandler(world);
                    List<BlockPos> toNodes = this.getSources();
                    for (BlockPos pos : new LinkedList<BlockPos>(this.offsetMirrors.keySet())) {
                        BlockPos act = pos.func_177971_a((Vec3i)this.getPos());
                        if (!toNodes.contains(act)) {
                            this.offsetMirrors.put(pos, false);
                            continue;
                        }
                        IPrismTransmissionNode node = handle.getTransmissionNode(act);
                        if (node == null) continue;
                        boolean found = false;
                        for (NodeConnection<IPrismTransmissionNode> n : node.queryNext(handle)) {
                            if (!n.getTo().equals((Object)this.getPos())) continue;
                            this.offsetMirrors.put(pos, n.canConnect());
                            found = true;
                        }
                        if (found) continue;
                        this.offsetMirrors.put(pos, false);
                    }
                }
                if (this.ticksTicking % 60 == 0 && (pedestal = this.getTileAtPos(world, TileRitualPedestal.class)) != null && pedestal.offsetMirrorPositions.size() != this.offsetMirrors.size()) {
                    this.updateMirrorPositions(world);
                }
                if (this.doesSeeSky) {
                    double perc = 0.2 + 0.8 * (double)ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(world);
                    WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler(world);
                    double collect = 0.0;
                    if (handle != null) {
                        collect = perc * (double)CrystalCalculations.getCollectionAmt(this.properties, handle.getCurrentDistribution(this.channeling, in -> Float.valueOf(0.2f + 0.8f * in.floatValue())).floatValue());
                    }
                    this.collectionChannelBuffer += collect / 2.0;
                }
                if (this.collectionChannelBuffer > 0.0) {
                    this.doMainEffect(world, this.ce, this.trait, this.trait != null && this.collectionTraitBuffer > 0.0);
                    if (this.tryIncrementChannelingTimer()) {
                        ++this.channeled;
                    }
                    this.flagAsWorking(world);
                    if (this.trait != null && this.collectionTraitBuffer > 0.0) {
                        this.doTraitEffect(world, this.ce);
                    }
                } else {
                    this.flagAsInactive(world);
                    this.ce = null;
                }
            } else {
                this.flagAsInactive(world);
                this.ce = null;
            }
        }

        private void doTraitEffect(World world, ConstellationEffect ce) {
            boolean consumeCompletely;
            double maxDrain = 7.0;
            maxDrain /= CrystalCalculations.getMaxRitualReduction(this.properties);
            int executeTimes = MathHelper.func_76128_c((double)(this.collectionChannelBuffer / (maxDrain /= (double)Math.max(1, this.getCollectedBackmirrors() - 1))));
            boolean bl = consumeCompletely = executeTimes == 0;
            if (ce != null && !consumeCompletely && ce.mayExecuteMultipleTrait()) {
                this.collectionTraitBuffer = Math.max(0.0, this.collectionTraitBuffer - (double)executeTimes * maxDrain);
                BlockPos to = this.getPos();
                if (this.ritualLinkTo != null) {
                    to = this.ritualLinkTo;
                }
                if (ce.playTraitEffectMultiple(world, to, this.trait, executeTimes)) {
                    this.markDirty(world);
                }
            } else {
                for (int i = 0; i <= executeTimes; ++i) {
                    float perc;
                    if (this.collectionTraitBuffer >= maxDrain) {
                        this.collectionTraitBuffer -= maxDrain;
                        perc = 1.0f;
                    } else {
                        if (!consumeCompletely) continue;
                        this.collectionTraitBuffer = 0.0;
                        perc = (float)(this.collectionTraitBuffer / maxDrain);
                    }
                    if (ce == null) continue;
                    BlockPos to = this.getPos();
                    if (this.ritualLinkTo != null) {
                        to = this.ritualLinkTo;
                    }
                    if (!ce.playTraitEffect(world, to, this.trait, perc)) continue;
                    this.markDirty(world);
                }
            }
        }

        private void doMainEffect(World world, ConstellationEffect ce, @Nullable IMinorConstellation trait, boolean mayDoTrait) {
            boolean consumeCompletely;
            double maxDrain = 7.0;
            maxDrain /= CrystalCalculations.getMaxRitualReduction(this.properties);
            int executeTimes = MathHelper.func_76128_c((double)(this.collectionChannelBuffer / (maxDrain /= (double)Math.max(1, this.getCollectedBackmirrors() - 1))));
            boolean bl = consumeCompletely = executeTimes == 0;
            if (ce != null && !consumeCompletely && ce.mayExecuteMultipleMain()) {
                this.collectionChannelBuffer = Math.max(0.0, this.collectionChannelBuffer - (double)executeTimes * maxDrain);
                BlockPos to = this.getPos();
                if (this.ritualLinkTo != null) {
                    to = this.ritualLinkTo;
                }
                if (ce.playMainEffectMultiple(world, to, executeTimes, mayDoTrait, trait)) {
                    this.markDirty(world);
                }
            } else {
                for (int i = 0; i <= executeTimes; ++i) {
                    float perc;
                    if (this.collectionChannelBuffer >= maxDrain) {
                        this.collectionChannelBuffer -= maxDrain;
                        perc = 1.0f;
                    } else {
                        if (!consumeCompletely) continue;
                        perc = (float)(this.collectionChannelBuffer / maxDrain);
                        this.collectionChannelBuffer = 0.0;
                    }
                    if (ce == null) continue;
                    BlockPos to = this.getPos();
                    if (this.ritualLinkTo != null) {
                        to = this.ritualLinkTo;
                    }
                    if (!ce.playMainEffect(world, to, perc, mayDoTrait, trait)) continue;
                    this.markDirty(world);
                }
            }
        }

        private int getCollectedBackmirrors() {
            int amt = 1;
            for (boolean f : this.offsetMirrors.values()) {
                if (!f) continue;
                ++amt;
            }
            return amt;
        }

        private void flagAsInactive(World world) {
            if (this.doesWorkBuffer) {
                this.doesWorkBuffer = false;
                this.channeled = 0;
                TileRitualPedestal ped = this.getTileAtPos(world, TileRitualPedestal.class);
                if (ped != null) {
                    ped.working = false;
                    ped.markForUpdate();
                }
                this.clearAllMirrorPositions(world);
            }
        }

        private void flagAsWorking(World world) {
            if (!this.doesWorkBuffer) {
                this.doesWorkBuffer = true;
                TileRitualPedestal ped = this.getTileAtPos(world, TileRitualPedestal.class);
                if (ped != null) {
                    ped.working = true;
                    ped.markForUpdate();
                }
            }
        }

        @Override
        public void onStarlightReceive(World world, boolean isChunkLoaded, IWeakConstellation type, double amount) {
            if (this.channeling != null && this.hasMultiblock) {
                if (this.channeling == type) {
                    this.collectionChannelBuffer += amount;
                    this.tryGainMirrorPos(world);
                    return;
                }
                if (this.trait != null && this.trait == type) {
                    this.collectionTraitBuffer += amount;
                }
            }
        }

        private boolean tryIncrementChannelingTimer() {
            if (this.offsetMirrors.size() < 0 || this.offsetMirrors.size() >= 5) {
                return false;
            }
            if (this.getCollectedBackmirrors() - 1 < this.offsetMirrors.size()) {
                return false;
            }
            int step = secToNext[this.offsetMirrors.size()];
            return this.channeled <= step;
        }

        private void tryGainMirrorPos(World world) {
            if (this.offsetMirrors.size() < 0 || this.offsetMirrors.size() >= 5) {
                return;
            }
            int mirrors = this.offsetMirrors.size();
            if (this.getCollectedBackmirrors() - 1 < mirrors) {
                return;
            }
            int step = secToNext[mirrors];
            if (this.channeled > step && world.field_73012_v.nextInt(chanceToNext[mirrors]) == 0) {
                this.findPossibleMirror(world);
            }
        }

        private void findPossibleMirror(World world) {
            BlockPos offset = possibleOffsets[world.field_73012_v.nextInt(possibleOffsets.length)];
            RaytraceAssist ray = new RaytraceAssist(this.getPos(), this.getPos().func_177971_a((Vec3i)offset));
            Vector3 from = new Vector3(0.5, 0.7, 0.5);
            Vector3 newDir = new Vector3(offset).add(0.5, 0.5, 0.5).subtract(from);
            for (BlockPos p : this.offsetMirrors.keySet()) {
                Vector3 toDir = new Vector3(p).add(0.5, 0.5, 0.5).subtract(from);
                if (Math.toDegrees(toDir.angle(newDir)) <= 30.0) {
                    return;
                }
                if (!(offset.func_177951_i((Vec3i)p) <= 3.0)) continue;
                return;
            }
            if (ray.isClear(world)) {
                this.addMirrorPosition(world, offset);
            }
        }

        public void addMirrorPosition(World world, BlockPos offset) {
            this.offsetMirrors.put(offset, false);
            this.updateMirrorPositions(world);
            this.markDirty(world);
        }

        public void clearAllMirrorPositions(World world) {
            this.offsetMirrors.clear();
            this.updateMirrorPositions(world);
            this.markDirty(world);
        }

        @Override
        public boolean needsUpdate() {
            return true;
        }

        public void updateMirrorPositions(World world) {
            TileRitualPedestal ped = this.getTileAtPos(world, TileRitualPedestal.class);
            if (ped != null) {
                ped.updatePositions(this.offsetMirrors.keySet());
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            super.readFromNBT(compound);
            this.doesSeeSky = compound.func_74767_n("doesSeeSky");
            this.hasMultiblock = compound.func_74767_n("hasMultiblock");
            this.channeled = compound.func_74762_e("channeled");
            this.properties = CrystalProperties.readFromNBT(compound);
            IConstellation c = IConstellation.readFromNBT(compound, IConstellation.getDefaultSaveKey() + "Normal");
            if (c != null && !(c instanceof IWeakConstellation)) {
                AstralSorcery.log.warn("[AstralSorcery] Tried to load RitualPedestal from NBT with a non-Major constellation as effect. Ignoring constellation...");
                AstralSorcery.log.warn("[AstralSorcery] Block affected is at " + this.getPos());
            } else {
                this.channeling = c == null ? null : (IWeakConstellation)c;
            }
            c = IConstellation.readFromNBT(compound, IConstellation.getDefaultSaveKey() + "Trait");
            if (c != null && !(c instanceof IMinorConstellation)) {
                AstralSorcery.log.warn("[AstralSorcery] Tried to load RitualPedestal from NBT with a non-Minor constellation as trait. Ignoring constellation...");
                AstralSorcery.log.warn("[AstralSorcery] Block affected is at " + this.getPos());
            } else {
                this.trait = c == null ? null : (IMinorConstellation)c;
            }
            this.offsetMirrors.clear();
            NBTTagList listPos = compound.func_150295_c("positions", 10);
            for (int i = 0; i < listPos.func_74745_c(); ++i) {
                this.offsetMirrors.put(NBTUtils.readBlockPosFromNBT(listPos.func_150305_b(i)), false);
            }
            this.ritualLinkTo = compound.func_74764_b("ritualLinkPos") ? NBTUtils.readBlockPosFromNBT(compound.func_74775_l("ritualLinkPos")) : null;
            if (this.channeling != null) {
                this.ce = this.channeling.getRitualEffect();
                if (compound.func_74764_b("effect") && this.ce != null) {
                    NBTTagCompound cmp = compound.func_74775_l("effect");
                    this.ce.readFromNBT(cmp);
                }
            }
        }

        @Override
        public void writeToNBT(NBTTagCompound compound) {
            NBTTagCompound tag;
            super.writeToNBT(compound);
            compound.func_74757_a("doesSeeSky", this.doesSeeSky);
            compound.func_74757_a("hasMultiblock", this.hasMultiblock);
            compound.func_74768_a("channeled", this.channeled);
            NBTTagList listPositions = new NBTTagList();
            for (BlockPos pos : this.offsetMirrors.keySet()) {
                NBTTagCompound cmp = new NBTTagCompound();
                NBTUtils.writeBlockPosToNBT(pos, cmp);
                listPositions.func_74742_a((NBTBase)cmp);
            }
            compound.func_74782_a("positions", (NBTBase)listPositions);
            if (this.properties != null) {
                this.properties.writeToNBT(compound);
            }
            if (this.channeling != null) {
                this.channeling.writeToNBT(compound, IConstellation.getDefaultSaveKey() + "Normal");
            }
            if (this.trait != null) {
                this.trait.writeToNBT(compound, IConstellation.getDefaultSaveKey() + "Trait");
            }
            if (this.ritualLinkTo != null) {
                tag = new NBTTagCompound();
                NBTUtils.writeBlockPosToNBT(this.ritualLinkTo, tag);
                compound.func_74782_a("ritualLinkPos", (NBTBase)tag);
            }
            if (this.ce != null) {
                tag = new NBTTagCompound();
                this.ce.writeToNBT(tag);
                compound.func_74782_a("effect", (NBTBase)tag);
            }
        }

        @Override
        public TransmissionClassRegistry.TransmissionProvider getProvider() {
            return new PedestalReceiverProvider();
        }

        public void updateSkyState(boolean doesSeeSky) {
            this.doesSeeSky = doesSeeSky;
        }

        public void updateMultiblockState(boolean hasMultiblock) {
            this.hasMultiblock = hasMultiblock;
        }

        public void updateCrystalProperties(World world, CrystalProperties properties, IWeakConstellation channeling, IMinorConstellation trait) {
            this.properties = properties;
            this.channeling = channeling;
            this.trait = trait;
            this.clearAllMirrorPositions(world);
            this.markDirty(world);
        }

        public void updateLink(@Nonnull World world, @Nullable BlockPos ritualLink) {
            BlockPos prev = this.ritualLinkTo;
            this.ritualLinkTo = ritualLink;
            if (prev == null && this.ritualLinkTo == null) {
                return;
            }
            if (!(prev != null && prev.equals((Object)this.ritualLinkTo) || this.ce == null)) {
                this.ce.clearCache();
                this.markDirty(world);
            }
        }
    }
}

