/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import hellfirepvp.astralsorcery.common.tile.TileFakeTree;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBase;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.TreeCaptureHelper;
import hellfirepvp.astralsorcery.common.util.data.NonDuplicateCappedList;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.data.WorldBlockPos;
import hellfirepvp.astralsorcery.common.util.nbt.NBTUtils;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileTreeBeacon
extends TileReceiverBase {
    private static final Random rand = new Random();
    private TreeCaptureHelper.TreeWatcher treeWatcher = null;
    private double starlightCharge = 0.0;
    private NonDuplicateCappedList<BlockPos> treePositions = new NonDuplicateCappedList(MathHelper.func_76141_d((float)ConfigEntryTreeBeacon.maxCount));

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.playEffects();
        } else {
            if (this.treePositions.getCap() != ConfigEntryTreeBeacon.maxCount) {
                this.treePositions.setCap(MathHelper.func_76141_d((float)ConfigEntryTreeBeacon.maxCount));
            }
            boolean changed = false;
            if (this.treeWatcher != null) {
                List<WorldBlockPos> possibleTreePositions = TreeCaptureHelper.getAndClearCachedEntries(this.treeWatcher);
                if (this.treePositions.getSize() + 30 <= ConfigEntryTreeBeacon.maxCount && this.searchForTrees(possibleTreePositions)) {
                    changed = true;
                }
            }
            int runs = MathHelper.func_76143_f((double)(this.starlightCharge * 1.7));
            this.starlightCharge = 0.0;
            for (int i = 0; i < Math.max(1, runs); ++i) {
                BlockPos randPos = this.treePositions.getRandomElementByChance(rand, ConfigEntryTreeBeacon.speedLimiter);
                if (randPos == null) continue;
                TileFakeTree tft = MiscUtils.getTileAt((IBlockAccess)this.field_145850_b, randPos, TileFakeTree.class, false);
                if (tft != null && tft.getFakedState() != null) {
                    IBlockState fake = tft.getFakedState();
                    if (this.tryHarvestBlock(this.field_145850_b, this.field_174879_c, randPos, fake)) {
                        this.field_145850_b.func_175698_g(randPos);
                        if (this.treePositions.removeElement(randPos)) {
                            changed = true;
                        }
                    }
                    PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.TREE_VORTEX, (Vec3i)randPos);
                    PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(this.field_145850_b, randPos, 32.0));
                    continue;
                }
                if (!this.treePositions.removeElement(randPos)) continue;
                changed = true;
            }
            if (changed) {
                this.markForUpdate();
            }
        }
    }

    private boolean tryHarvestBlock(World world, BlockPos out, BlockPos treeBlockPos, IBlockState fakedState) {
        if (rand.nextInt(ConfigEntryTreeBeacon.dropsChance) == 0) {
            Block b = fakedState.func_177230_c();
            List drops = b.getDrops((IBlockAccess)world, treeBlockPos, fakedState, 0);
            if (rand.nextBoolean()) {
                drops.addAll(b.getDrops((IBlockAccess)world, treeBlockPos, fakedState, 0));
            }
            if (rand.nextBoolean()) {
                drops.addAll(b.getDrops((IBlockAccess)world, treeBlockPos, fakedState, 0));
            }
            for (ItemStack i : drops) {
                if (i == null || i.func_77973_b() == null) continue;
                ItemUtils.dropItemNaturally(world, (float)out.func_177958_n() + rand.nextFloat() * 3.0f * (float)(rand.nextBoolean() ? 1 : -1), (float)out.func_177956_o() + rand.nextFloat() * 3.0f, (float)out.func_177952_p() + rand.nextFloat() * 3.0f * (float)(rand.nextBoolean() ? 1 : -1), i);
            }
        }
        return rand.nextInt(ConfigEntryTreeBeacon.breakChance) == 0;
    }

    private boolean searchForTrees(List<WorldBlockPos> possibleTreePositions) {
        for (WorldBlockPos possibleSapling : possibleTreePositions) {
            IBlockState state = possibleSapling.getStateAt();
            Block b = state.func_177230_c();
            if (b instanceof IGrowable) {
                if (!TreeCaptureHelper.oneTimeCatches.contains((Object)possibleSapling)) {
                    TreeCaptureHelper.oneTimeCatches.add(possibleSapling);
                }
                int tries = 8;
                this.field_145850_b.captureBlockSnapshots = true;
                do {
                    --tries;
                    try {
                        ((IGrowable)b).func_176474_b(this.field_145850_b, rand, (BlockPos)possibleSapling, state);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                } while (TreeCaptureHelper.oneTimeCatches.contains((Object)possibleSapling) || tries > 0);
                this.field_145850_b.captureBlockSnapshots = false;
                return this.updatePositionsFromSnapshots(this.field_145850_b, possibleSapling, this.field_174879_c);
            }
            if (!b.func_149653_t()) continue;
            if (!TreeCaptureHelper.oneTimeCatches.contains((Object)possibleSapling)) {
                TreeCaptureHelper.oneTimeCatches.add(possibleSapling);
            }
            int ticksToExecute = 250;
            this.field_145850_b.captureBlockSnapshots = true;
            do {
                --ticksToExecute;
                try {
                    b.func_180650_b(this.field_145850_b, (BlockPos)possibleSapling, state, rand);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (TreeCaptureHelper.oneTimeCatches.contains((Object)possibleSapling) || ticksToExecute > 0);
            this.field_145850_b.captureBlockSnapshots = false;
            return this.updatePositionsFromSnapshots(this.field_145850_b, possibleSapling, this.field_174879_c);
        }
        return false;
    }

    private boolean updatePositionsFromSnapshots(World world, WorldBlockPos saplingPos, BlockPos origin) {
        boolean ret = false;
        if (!TreeCaptureHelper.oneTimeCatches.remove((Object)saplingPos) && !world.capturedBlockSnapshots.isEmpty() && world.capturedBlockSnapshots.size() > 2) {
            if (this.treePositions.getSize() + world.capturedBlockSnapshots.size() <= ConfigEntryTreeBeacon.maxCount) {
                for (BlockSnapshot snapshot : world.capturedBlockSnapshots) {
                    IBlockState setBlock = snapshot.getCurrentBlock();
                    if (setBlock.func_177230_c().equals((Object)BlocksAS.blockFakeTree) || setBlock.func_177230_c().equals(Blocks.field_150346_d) || setBlock.func_177230_c().equals(Blocks.field_150349_c)) continue;
                    world.func_175656_a(snapshot.getPos(), BlocksAS.blockFakeTree.func_176223_P());
                    TileFakeTree tft = MiscUtils.getTileAt((IBlockAccess)world, snapshot.getPos(), TileFakeTree.class, true);
                    if (tft != null) {
                        tft.setupTile(origin, setBlock);
                    }
                    if (!this.treePositions.offerElement(snapshot.getPos())) continue;
                    ret = true;
                }
            } else {
                for (BlockSnapshot snapshot : world.capturedBlockSnapshots) {
                    IBlockState current = world.func_180495_p(snapshot.getPos());
                    world.func_184138_a(snapshot.getPos(), current, current, 3);
                }
            }
        }
        world.capturedBlockSnapshots.clear();
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    private void playEffects() {
        if (rand.nextInt(3) == 0) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle((double)((float)this.field_174879_c.func_177958_n() + rand.nextFloat() * 5.0f * (float)(rand.nextBoolean() ? 1 : -1)) + 0.5, (double)((float)this.field_174879_c.func_177956_o() + rand.nextFloat() * 2.0f) + 0.5, (double)((float)this.field_174879_c.func_177952_p() + rand.nextFloat() * 5.0f * (float)(rand.nextBoolean() ? 1 : -1)) + 0.5);
            p.motion(rand.nextFloat() * 0.03f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.03f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.03f * (float)(rand.nextBoolean() ? 1 : -1));
            p.scale(0.45f).setColor(new Color(63, 255, 63)).gravity(0.008).setMaxAge(55);
        }
        if (this.ticksExisted % 32 == 0) {
            float alphaDaytime = ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(this.field_145850_b);
            Vector3 from = new Vector3(this).add(0.5, 0.05, 0.5);
            MiscUtils.applyRandomOffset(from, EffectHandler.STATIC_EFFECT_RAND, 0.05f);
            EffectLightbeam lightbeam = EffectHandler.getInstance().lightbeam(from.clone().addY(7.0), from, 1.5);
            lightbeam.setAlphaMultiplier(alphaDaytime *= 0.8f);
            lightbeam.setColorOverlay(0.24705882f, 1.0f, 0.24705882f, 1.0f);
            lightbeam.setMaxAge(64);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void playParticles(PktParticleEvent event) {
        BlockPos fakeTree = event.getVec().toBlockPos();
        TileFakeTree tft = MiscUtils.getTileAt((IBlockAccess)Minecraft.func_71410_x().field_71441_e, fakeTree, TileFakeTree.class, false);
        if (tft != null && tft.getReference() != null) {
            Vector3 to = new Vector3(tft.getReference()).add(0.5, 0.5, 0.5);
            for (int i = 0; i < 10; ++i) {
                Vector3 from = new Vector3(fakeTree).add(rand.nextFloat(), rand.nextFloat(), rand.nextFloat());
                Vector3 mov = to.clone().subtract(from).normalize().multiply(0.1 + 0.1 * (double)rand.nextFloat());
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(from.getX(), from.getY(), from.getZ());
                p.motion(mov.getX(), mov.getY(), mov.getZ()).setMaxAge(30 + rand.nextInt(25));
                p.gravity(0.004).scale(0.25f).setColor(Color.GREEN);
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        TreeCaptureHelper.getAndClearCachedEntries(this.treeWatcher);
        this.treeWatcher = null;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.treeWatcher = new TreeCaptureHelper.TreeWatcher(this.field_145850_b.field_73011_w.getDimension(), this.func_174877_v(), ConfigEntryTreeBeacon.treeBeaconRange);
        TreeCaptureHelper.offerWeakWatcher(this.treeWatcher);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.starlightCharge = compound.func_74769_h("starlight");
        this.treePositions.clear();
        NBTTagList list = compound.func_150295_c("positions", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            BlockPos pos = NBTUtils.readBlockPosFromNBT(tag);
            this.treePositions.offerElement(pos);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74780_a("starlight", this.starlightCharge);
        NBTTagList listPositions = new NBTTagList();
        for (BlockPos pos : this.treePositions) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTUtils.writeBlockPosToNBT(pos, tag);
            listPositions.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("positions", (NBTBase)listPositions);
    }

    @Override
    @Nullable
    public String getUnLocalizedDisplayName() {
        return "tile.BlockTreeBeacon.name";
    }

    @Override
    @Nonnull
    public ITransmissionReceiver provideEndpoint(BlockPos at) {
        return new TransmissionReceiverTreeBeacon(at);
    }

    private void receiveStarlight(IWeakConstellation type, double amount) {
        this.starlightCharge += amount;
        if (type == Constellations.aevitas) {
            this.starlightCharge += amount * 2.0;
        }
    }

    public static class ConfigEntryTreeBeacon
    extends ConfigEntry {
        public static final ConfigEntryTreeBeacon instance = new ConfigEntryTreeBeacon();
        public static double treeBeaconRange = 16.0;
        public static int maxCount = 600;
        public static int dropsChance = 5;
        public static int breakChance = 500;
        public static float speedLimiter = 1.0f;

        private ConfigEntryTreeBeacon() {
            super(ConfigEntry.Section.MACHINERY, "treeBeacon");
        }

        @Override
        public void loadFromConfig(Configuration cfg) {
            speedLimiter = cfg.getFloat(this.getKey() + "EfficiencyLimiter", this.getConfigurationSection(), 1.0f, 0.0f, 1.0f, "Percentage, how hard the speed limiter should slow down production of the tree beacon. 1=max, 0=no limiter");
            maxCount = cfg.getInt(this.getKey() + "Count", this.getConfigurationSection(), 600, 1, 4000, "Defines the amount of blocks the treeBeacon can support at max count");
            treeBeaconRange = cfg.getFloat(this.getKey() + "Range", this.getConfigurationSection(), 16.0f, 4.0f, 64.0f, "Defines the Range where the TreeBeacon will scan for Tree's to grow.");
            dropsChance = cfg.getInt(this.getKey() + "DropsChance", this.getConfigurationSection(), 5, 1, Integer.MAX_VALUE, "Defines the chance that a drop is generated per random-selection tick. The higher the value the lower the chance.");
            breakChance = cfg.getInt(this.getKey() + "BreakChance", this.getConfigurationSection(), 500, 20, Integer.MAX_VALUE, "Defines the chance that the block harvested is going to break per random-selection tick. The higher the value the lower the chance");
        }
    }

    public static class TreeBeaconReceiverProvider
    implements TransmissionClassRegistry.TransmissionProvider {
        @Override
        public TransmissionReceiverTreeBeacon provideEmptyNode() {
            return new TransmissionReceiverTreeBeacon(null);
        }

        @Override
        public String getIdentifier() {
            return "astralsorcery:TransmissionReceiverTreeBeacon";
        }
    }

    public static class TransmissionReceiverTreeBeacon
    extends SimpleTransmissionReceiver {
        public TransmissionReceiverTreeBeacon(BlockPos thisPos) {
            super(thisPos);
        }

        @Override
        public void onStarlightReceive(World world, boolean isChunkLoaded, IWeakConstellation type, double amount) {
            TileTreeBeacon tw;
            if (isChunkLoaded && (tw = MiscUtils.getTileAt((IBlockAccess)world, this.getPos(), TileTreeBeacon.class, false)) != null) {
                tw.receiveStarlight(type, amount);
            }
        }

        @Override
        public TransmissionClassRegistry.TransmissionProvider getProvider() {
            return new TreeBeaconReceiverProvider();
        }
    }
}

