/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXCrystalBurst;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.base.WellLiquefaction;
import hellfirepvp.astralsorcery.common.block.fluid.FluidLiquidStarlight;
import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.entities.EntityFlare;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBaseInventory;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import hellfirepvp.astralsorcery.common.util.block.PrecisionSingleFluidCapabilityTank;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileWell
extends TileReceiverBaseInventory {
    private static final Random rand = new Random();
    private static final int MAX_CAPACITY = 2000;
    private WellLiquefaction.LiquefactionEntry running = null;
    private PrecisionSingleFluidCapabilityTank tank = new PrecisionSingleFluidCapabilityTank(2000, EnumFacing.DOWN);
    private double starlightBuffer = 0.0;

    public TileWell() {
        super(1, EnumFacing.UP);
        this.tank.setAllowInput(false);
    }

    @Override
    protected TileReceiverBaseInventory.ItemHandlerTile createNewItemHandler() {
        return new CatalystItemHandler(this);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack;
            if (this.field_145850_b.func_175678_i(this.func_174877_v())) {
                double sbDayDistribution = ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(this.field_145850_b);
                int yLevel = this.func_174877_v().func_177956_o();
                float dstr = yLevel > 120 ? 1.0f : (float)yLevel / 120.0f;
                this.starlightBuffer += Math.max(1.0E-4, sbDayDistribution *= (double)dstr);
            }
            if ((stack = this.getInventoryHandler().getStackInSlot(0)) != null) {
                if (!this.field_145850_b.func_175623_d(this.func_174877_v().func_177984_a())) {
                    this.breakCatalyst();
                } else {
                    this.running = WellLiquefaction.getLiquefactionEntry(stack);
                    if (this.running != null && stack.func_77973_b() != null) {
                        double gain = Math.sqrt(this.starlightBuffer) * (double)this.running.productionMultiplier;
                        if (gain > 0.0 && this.tank.getFluidAmount() <= 2000) {
                            if (this.tank.getFluidAmount() <= 2000) {
                                this.markForUpdate();
                            }
                            this.fillAndDiscardRest(this.running, gain);
                            if (rand.nextInt(2000) == 0) {
                                EntityFlare.spawnAmbient(this.field_145850_b, new Vector3(this).add(-3.0f + rand.nextFloat() * 7.0f, 0.6, -3.0f + rand.nextFloat() * 7.0f));
                            }
                        }
                        this.starlightBuffer = 0.0;
                        if (rand.nextInt(1 + (int)(1000.0f * this.running.shatterMultiplier)) == 0) {
                            this.breakCatalyst();
                            EntityFlare.spawnAmbient(this.field_145850_b, new Vector3(this).add(-3.0f + rand.nextFloat() * 7.0f, 0.6, -3.0f + rand.nextFloat() * 7.0f));
                        }
                    }
                }
                this.starlightBuffer = 0.0;
            } else {
                this.starlightBuffer = 0.0;
            }
        } else {
            ItemStack stack = this.getInventoryHandler().getStackInSlot(0);
            if (stack != null && stack.func_77973_b() != null) {
                this.running = WellLiquefaction.getLiquefactionEntry(stack);
                if (this.running != null) {
                    Color color = Color.WHITE;
                    if (this.running.catalystColor != null) {
                        color = this.running.catalystColor;
                    }
                    this.doCatalystEffect(color);
                }
            }
            if (this.tank.getFluidAmount() > 0 && this.tank.getTankFluid() != null && this.tank.getTankFluid() instanceof FluidLiquidStarlight) {
                this.doStarlightEffect();
            }
        }
    }

    public void breakCatalyst() {
        this.getInventoryHandler().setStackInSlot(0, null);
        PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.WELL_CATALYST_BREAK, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(this.field_145850_b, this.func_174877_v(), 32.0));
        SoundHelper.playSoundAround(SoundEvents.field_187561_bM, this.func_145831_w(), (Vec3i)this.func_174877_v(), 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    private void doStarlightEffect() {
        if (rand.nextInt(3) == 0) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.4, (double)this.func_174877_v().func_177952_p() + 0.5);
            p.offset(0.0, (double)this.getPercFilled() * 0.5, 0.0);
            p.offset((double)rand.nextFloat() * 0.35 * (double)(rand.nextBoolean() ? 1 : -1), 0.0, (double)rand.nextFloat() * 0.35 * (double)(rand.nextBoolean() ? 1 : -1));
            p.scale(0.16f).gravity(0.006).setColor(BlockCollectorCrystalBase.CollectorCrystalType.ROCK_CRYSTAL.displayColor);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doCatalystEffect(Color color) {
        if (rand.nextInt(6) == 0) {
            Entity rView = Minecraft.func_71410_x().func_175606_aa();
            if (rView == null) {
                rView = Minecraft.func_71410_x().field_71439_g;
            }
            if (rView.func_174818_b(this.func_174877_v()) > (double)Config.maxEffectRenderDistanceSq) {
                return;
            }
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.3, (double)this.func_174877_v().func_177952_p() + 0.5);
            p.offset((double)rand.nextFloat() * 0.1 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.1, (double)rand.nextFloat() * 0.1 * (double)(rand.nextBoolean() ? 1 : -1));
            p.scale(0.2f).gravity(-0.004).setAlphaMultiplier(1.0f).setColor(color);
        }
    }

    private void receiveStarlight(IWeakConstellation type, double amount) {
        this.starlightBuffer += amount;
    }

    private void fillAndDiscardRest(WellLiquefaction.LiquefactionEntry entry, double gain) {
        if (this.tank.getTankFluid() == null) {
            this.tank.setFluid(entry.producing);
        } else if (!entry.producing.equals(this.tank.getTankFluid())) {
            return;
        }
        this.tank.addAmount(gain);
    }

    @SideOnly(value=Side.CLIENT)
    public static void catalystBurst(PktParticleEvent event) {
        BlockPos at = event.getVec().toBlockPos();
        EffectHandler.getInstance().registerFX(new EntityFXCrystalBurst(rand.nextInt(), (double)at.func_177958_n() + 0.5, (double)at.func_177956_o() + 1.3, (double)at.func_177952_p() + 0.5, 1.5f));
    }

    @Override
    @Nullable
    public String getUnLocalizedDisplayName() {
        return "tile.BlockWell.name";
    }

    @Override
    @Nonnull
    public ITransmissionReceiver provideEndpoint(BlockPos at) {
        return new TransmissionReceiverWell(at);
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    @Nullable
    public Fluid getHeldFluid() {
        return this.tank.getTankFluid();
    }

    public float getPercFilled() {
        return this.tank.getPercentageFilled();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a("tank", (NBTBase)this.tank.writeNBT());
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.tank = PrecisionSingleFluidCapabilityTank.deserialize(compound.func_74775_l("tank"));
        if (!this.tank.hasCapability(EnumFacing.DOWN)) {
            this.tank.accessibleSides.add(EnumFacing.DOWN);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.tank.hasCapability(facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability != CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || !this.hasCapability(capability, facing)) {
            return null;
        }
        return (T)this.tank.getCapability(facing);
    }

    public static class WellReceiverProvider
    implements TransmissionClassRegistry.TransmissionProvider {
        @Override
        public TransmissionReceiverWell provideEmptyNode() {
            return new TransmissionReceiverWell(null);
        }

        @Override
        public String getIdentifier() {
            return "astralsorcery:TransmissionReceiverWell";
        }
    }

    public static class TransmissionReceiverWell
    extends SimpleTransmissionReceiver {
        public TransmissionReceiverWell(BlockPos thisPos) {
            super(thisPos);
        }

        @Override
        public void onStarlightReceive(World world, boolean isChunkLoaded, IWeakConstellation type, double amount) {
            TileWell tw;
            if (isChunkLoaded && (tw = MiscUtils.getTileAt((IBlockAccess)world, this.getPos(), TileWell.class, false)) != null) {
                tw.receiveStarlight(type, amount);
            }
        }

        @Override
        public TransmissionClassRegistry.TransmissionProvider getProvider() {
            return new WellReceiverProvider();
        }
    }

    public static class CatalystItemHandler
    extends TileReceiverBaseInventory.ItemHandlerTileFiltered {
        public CatalystItemHandler(TileReceiverBaseInventory inv) {
            super(inv);
        }

        @Override
        public int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        @Override
        public boolean canInsertItem(int slot, ItemStack toAdd, @Nullable ItemStack existing) {
            if (toAdd == null) {
                return true;
            }
            return WellLiquefaction.getLiquefactionEntry(toAdd) != null && existing == null;
        }
    }
}

