/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile.base;

import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBase;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileReceiverBaseInventory
extends TileReceiverBase {
    protected int inventorySize;
    private ItemHandlerTile handle;
    private List<EnumFacing> applicableSides;

    public TileReceiverBaseInventory() {
        this(0);
    }

    public TileReceiverBaseInventory(int inventorySize) {
        this(inventorySize, EnumFacing.field_82609_l);
    }

    public TileReceiverBaseInventory(int inventorySize, EnumFacing ... applicableSides) {
        this.inventorySize = inventorySize;
        this.handle = this.createNewItemHandler();
        this.applicableSides = Arrays.asList(applicableSides);
    }

    protected ItemHandlerTile createNewItemHandler() {
        return new ItemHandlerTile(this);
    }

    public ItemHandlerTile getInventoryHandler() {
        return this.handle;
    }

    private boolean hasHandlerForSide(EnumFacing facing) {
        return facing == null || this.applicableSides.contains(facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.hasHandlerForSide(facing) ? capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY : super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.hasHandlerForSide(facing) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.handle);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.handle = this.createNewItemHandler();
        this.handle.deserializeNBT(compound.func_74775_l("inventory"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a("inventory", (NBTBase)this.handle.serializeNBT());
    }

    public int getInventorySize() {
        return this.inventorySize;
    }

    protected void onInventoryChanged(int slotChanged) {
    }

    public static class ItemHandlerTile
    extends ItemStackHandler {
        private final TileReceiverBaseInventory tile;

        public ItemHandlerTile(TileReceiverBaseInventory inv) {
            super(inv.inventorySize);
            this.tile = inv;
        }

        public void onContentsChanged(int slot) {
            this.tile.onInventoryChanged(slot);
            this.tile.markForUpdate();
        }

        public void clearInventory() {
            for (int i = 0; i < this.getSlots(); ++i) {
                this.setStackInSlot(i, null);
                this.onContentsChanged(i);
            }
        }

        public int getStackLimit(int slot, ItemStack stack) {
            return super.getStackLimit(slot, stack);
        }
    }

    public static class ItemHandlerTileFiltered
    extends ItemHandlerTile {
        public ItemHandlerTileFiltered(TileReceiverBaseInventory inv) {
            super(inv);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            if (this.canInsertItem(slot, stack, this.getStackInSlot(slot))) {
                super.setStackInSlot(slot, stack);
            }
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.canInsertItem(slot, stack, this.getStackInSlot(slot))) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public boolean canInsertItem(int slot, ItemStack toAdd, @Nullable ItemStack existing) {
            return true;
        }
    }
}

