/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationBotania;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class ItemUtils {
    private static final Random rand = new Random();

    public static EntityItem dropItem(World world, double x, double y, double z, ItemStack stack) {
        if (world.field_72995_K) {
            return null;
        }
        EntityItem ei = new EntityItem(world, x, y, z, stack);
        ei.field_70159_w = 0.0;
        ei.field_70181_x = 0.0;
        ei.field_70179_y = 0.0;
        world.func_72838_d((Entity)ei);
        ei.func_174869_p();
        return ei;
    }

    public static EntityItem dropItemNaturally(World world, double x, double y, double z, ItemStack stack) {
        if (world.field_72995_K) {
            return null;
        }
        EntityItem ei = new EntityItem(world, x, y, z, stack);
        ItemUtils.applyRandomDropOffset(ei);
        world.func_72838_d((Entity)ei);
        ei.func_174869_p();
        return ei;
    }

    private static void applyRandomDropOffset(EntityItem item) {
        item.field_70159_w = (double)(rand.nextFloat() * 0.3f) - 0.15;
        item.field_70181_x = (double)(rand.nextFloat() * 0.3f) - 0.15;
        item.field_70179_y = (double)(rand.nextFloat() * 0.3f) - 0.15;
    }

    @Nullable
    public static ItemStack createBlockStack(IBlockState state) {
        Item i = Item.func_150898_a((Block)state.func_177230_c());
        if (i == null) {
            return null;
        }
        int meta = state.func_177230_c().func_180651_a(state);
        return new ItemStack(i, 1, meta);
    }

    @Nullable
    public static IBlockState createBlockState(ItemStack stack) {
        Block b = Block.func_149634_a((Item)stack.func_77973_b());
        if (b == Blocks.field_150350_a) {
            return null;
        }
        try {
            return b.func_176203_a(stack.func_77960_j());
        }
        catch (Exception exc) {
            return b.func_176223_P();
        }
    }

    public static Collection<ItemStack> scanInventoryFor(IItemHandler handler, Item i) {
        LinkedList<ItemStack> out = new LinkedList<ItemStack>();
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack s = handler.getStackInSlot(j);
            if (s == null || s.func_77973_b() == null || s.func_77973_b() != i) continue;
            out.add(ItemUtils.copyStackWithSize(s, s.field_77994_a));
        }
        return out;
    }

    public static Collection<ItemStack> scanInventoryForMatching(IItemHandler handler, ItemStack match, boolean strict) {
        return ItemUtils.findItemsInInventory(handler, match, strict);
    }

    public static Collection<ItemStack> findItemsInPlayerInventory(EntityPlayer player, ItemStack match, boolean strict) {
        return ItemUtils.findItemsInInventory((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), match, strict);
    }

    public static Collection<ItemStack> findItemsInInventory(IItemHandler handler, ItemStack match, boolean strict) {
        LinkedList<ItemStack> stacksOut = new LinkedList<ItemStack>();
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack s = handler.getStackInSlot(j);
            if (!(strict ? ItemUtils.matchStacks(s, match) : ItemUtils.matchStackLoosely(s, match))) continue;
            stacksOut.add(ItemUtils.copyStackWithSize(s, s.field_77994_a));
        }
        return stacksOut;
    }

    public static Map<Integer, ItemStack> findItemsIndexedInInventory(IItemHandler handler, ItemStack match, boolean strict) {
        HashMap<Integer, ItemStack> stacksOut = new HashMap<Integer, ItemStack>();
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack s = handler.getStackInSlot(j);
            if (!(strict ? ItemUtils.matchStacks(s, match) : ItemUtils.matchStackLoosely(s, match))) continue;
            stacksOut.put(j, ItemUtils.copyStackWithSize(s, s.field_77994_a));
        }
        return stacksOut;
    }

    public static boolean consumeFromPlayerInventory(EntityPlayer player, ItemStack requestingItemStack, ItemStack toConsume, boolean simulate) {
        ItemStack tryConsume;
        IBlockState consumeState;
        if (toConsume == null || toConsume.func_77973_b() == null) {
            return false;
        }
        int consumed = 0;
        if (Mods.BOTANIA.isPresent() && (consumeState = ItemUtils.createBlockState(toConsume)) != null) {
            Block b = consumeState.func_177230_c();
            int meta = b.func_180651_a(consumeState);
            for (int i = 0; i < toConsume.field_77994_a; ++i) {
                ItemStack res = ModIntegrationBotania.requestFromInventory(player, requestingItemStack, b, meta, simulate);
                if (res == null || res.func_77973_b() == null) continue;
                ++consumed;
            }
        }
        return (tryConsume = ItemUtils.copyStackWithSize(toConsume, toConsume.field_77994_a - consumed)) == null || tryConsume.func_77973_b() == null || ItemUtils.consumeFromInventory((IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), tryConsume, simulate);
    }

    public static boolean tryConsumeFromInventory(IItemHandler handler, ItemStack toConsume, boolean simulate) {
        return handler instanceof IItemHandlerModifiable && ItemUtils.consumeFromInventory((IItemHandlerModifiable)handler, toConsume, simulate);
    }

    public static boolean consumeFromInventory(IItemHandlerModifiable handler, ItemStack toConsume, boolean simulate) {
        Map<Integer, ItemStack> contents = ItemUtils.findItemsIndexedInInventory((IItemHandler)handler, toConsume, false);
        if (contents.isEmpty()) {
            return false;
        }
        int cAmt = toConsume.field_77994_a;
        for (int slot : contents.keySet()) {
            ItemStack inSlot = contents.get(slot);
            int toRemove = cAmt > inSlot.field_77994_a ? inSlot.field_77994_a : cAmt;
            cAmt -= toRemove;
            if (!simulate) {
                handler.setStackInSlot(slot, ItemUtils.copyStackWithSize(inSlot, inSlot.field_77994_a - toRemove));
            }
            if (cAmt > 0) continue;
            break;
        }
        return cAmt <= 0;
    }

    public static void dropInventory(IItemHandler handle, World worldIn, BlockPos pos) {
        if (worldIn.field_72995_K) {
            return;
        }
        for (int i = 0; i < handle.getSlots(); ++i) {
            ItemStack stack = handle.getStackInSlot(i);
            if (stack == null) continue;
            ItemUtils.dropItemNaturally(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        }
    }

    public static ItemStack drainFluidFromItem(ItemStack stack, Fluid fluid, int mbAmount, boolean doDrain) {
        return ItemUtils.drainFluidFromItem(stack, new FluidStack(fluid, mbAmount), doDrain);
    }

    public static ItemStack drainFluidFromItem(ItemStack stack, FluidStack fluidStack, boolean doDrain) {
        return FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)FluidHandlerVoid.INSTANCE, (int)fluidStack.amount, null, (boolean)doDrain);
    }

    public static void decrStackInInventory(ItemStackHandler handler, int slot) {
        if (slot < 0 || slot >= handler.getSlots()) {
            return;
        }
        ItemStack st = handler.getStackInSlot(slot);
        if (st == null) {
            return;
        }
        --st.field_77994_a;
        if (st.field_77994_a <= 0) {
            handler.setStackInSlot(slot, null);
        }
    }

    public static boolean tryPlaceItemInInventory(ItemStack stack, IItemHandler handler) {
        return ItemUtils.tryPlaceItemInInventory(stack, handler, 0, handler.getSlots());
    }

    public static boolean tryPlaceItemInInventory(ItemStack stack, IItemHandler handler, int start, int end) {
        ItemStack toAdd = stack.func_77946_l();
        if (!ItemUtils.hasInventorySpace(toAdd, handler, start, end)) {
            return false;
        }
        int max = stack.func_77976_d();
        for (int i = start; i < end; ++i) {
            ItemStack in = handler.getStackInSlot(i);
            if (in == null) {
                int added = Math.min(stack.field_77994_a, max);
                stack.field_77994_a -= added;
                handler.insertItem(i, ItemUtils.copyStackWithSize(stack, added), false);
                return true;
            }
            if (!ItemUtils.stackEqualsNonNBT(stack, in) || !ItemUtils.matchTags(stack, in)) continue;
            int space = max - in.field_77994_a;
            int added = Math.min(stack.field_77994_a, space);
            stack.field_77994_a -= added;
            handler.getStackInSlot((int)i).field_77994_a += added;
            if (stack.field_77994_a > 0) continue;
            return true;
        }
        return stack.field_77994_a == 0;
    }

    public static boolean hasInventorySpace(ItemStack stack, IItemHandler handler, int rangeMin, int rangeMax) {
        int size = stack.field_77994_a;
        int max = stack.func_77976_d();
        for (int i = rangeMin; i < rangeMax && size > 0; ++i) {
            ItemStack in = handler.getStackInSlot(i);
            if (in == null) {
                size -= max;
                continue;
            }
            if (!ItemUtils.stackEqualsNonNBT(stack, in) || !ItemUtils.matchTags(stack, in)) continue;
            int space = max - in.field_77994_a;
            size -= space;
        }
        return size <= 0;
    }

    public static boolean stackEqualsNonNBT(ItemStack stack, ItemStack other) {
        if (stack == null && other == null) {
            return true;
        }
        if (stack == null || other == null || stack.func_77973_b() == null || other.func_77973_b() == null) {
            return false;
        }
        Item sItem = stack.func_77973_b();
        Item oItem = other.func_77973_b();
        if (sItem.func_77614_k() || oItem.func_77614_k()) {
            return sItem.equals(other.func_77973_b()) && (stack.func_77952_i() == other.func_77952_i() || stack.func_77952_i() == Short.MAX_VALUE || other.func_77952_i() == Short.MAX_VALUE);
        }
        return sItem.equals(other.func_77973_b());
    }

    public static ItemStack copyStackWithSize(ItemStack stack, int amount) {
        if (stack == null || stack.func_77973_b() == null || amount <= 0) {
            return null;
        }
        ItemStack s = stack.func_77946_l();
        s.field_77994_a = amount;
        return s;
    }

    public static boolean hasOreNamePart(ItemStack stack, String namePart) {
        namePart = namePart.toLowerCase();
        List<String> oreNames = ItemUtils.getOreDictNames(stack);
        for (String s : oreNames) {
            if (!s.contains(namePart)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOreName(ItemStack stack, String name) {
        name = name.toLowerCase();
        return ItemUtils.getOreDictNames(stack).contains(name);
    }

    private static List<String> getOreDictNames(ItemStack stack) {
        ArrayList out = Lists.newArrayList();
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            out.add(OreDictionary.getOreName((int)id).toLowerCase());
        }
        return out;
    }

    public static boolean matchTags(ItemStack stack, ItemStack other) {
        return ItemStack.func_77970_a((ItemStack)stack, (ItemStack)other);
    }

    public static boolean matchStacksStrict(ItemStack stack, ItemStack other) {
        return ItemStack.func_77989_b((ItemStack)stack, (ItemStack)other);
    }

    public static boolean matchStacks(ItemStack stack, ItemStack other) {
        if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)other)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack, (ItemStack)other);
    }

    public static boolean matchStackLoosely(ItemStack stack, ItemStack other) {
        if (stack == null) {
            return other == null;
        }
        return stack.func_77969_a(other);
    }

    public static boolean matchesOreDict(String oreDictKey, ItemStack other) {
        List stacks = OreDictionary.getOres((String)oreDictKey);
        for (ItemStack stack : stacks) {
            if (stack == null || !ItemUtils.matchStackLoosely(stack, other)) continue;
            return true;
        }
        return false;
    }

    private static class FluidHandlerVoid
    implements IFluidHandler {
        private static FluidHandlerVoid INSTANCE = new FluidHandlerVoid();

        private FluidHandlerVoid() {
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[0];
        }

        public int fill(FluidStack resource, boolean doFill) {
            return resource.amount;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }
}

