/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world;

import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.world.WorldGenAttribute;
import hellfirepvp.astralsorcery.common.world.WorldGenAttributeCommon;
import hellfirepvp.astralsorcery.common.world.attributes.GenAttributeAquamarine;
import hellfirepvp.astralsorcery.common.world.attributes.GenAttributeGlowstoneFlower;
import hellfirepvp.astralsorcery.common.world.attributes.GenAttributeMarble;
import hellfirepvp.astralsorcery.common.world.attributes.GenAttributeRockCrystals;
import hellfirepvp.astralsorcery.common.world.retrogen.ChunkVersionController;
import hellfirepvp.astralsorcery.common.world.structure.StructureAncientShrine;
import hellfirepvp.astralsorcery.common.world.structure.StructureDesertShrine;
import hellfirepvp.astralsorcery.common.world.structure.StructureSmallShrine;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class AstralWorldGenerator
implements IWorldGenerator {
    public static final int CURRENT_WORLD_GENERATOR_VERSION = 1;
    private List<WorldGenAttributeCommon> structures = new LinkedList<WorldGenAttributeCommon>();
    private List<WorldGenAttribute> decorators = new LinkedList<WorldGenAttribute>();
    private List<WorldGenAttribute> worldGenAttributes = new LinkedList<WorldGenAttribute>();

    public void pushConfigEntries() {
        this.structures.add(new StructureAncientShrine());
        this.structures.add(new StructureDesertShrine());
        this.structures.add(new StructureSmallShrine());
        this.decorators.add(new GenAttributeGlowstoneFlower());
    }

    public AstralWorldGenerator setupAttributes() {
        if (Config.spawnRockCrystalOres) {
            this.decorators.add(new GenAttributeRockCrystals());
        }
        if (Config.marbleAmount > 0) {
            this.decorators.add(new GenAttributeMarble());
        }
        if (Config.aquamarineAmount > 0) {
            this.decorators.add(new GenAttributeAquamarine());
        }
        this.worldGenAttributes.addAll(this.decorators);
        this.worldGenAttributes.addAll(this.structures);
        return this;
    }

    public void handleRetroGen(World world, ChunkPos pos, Integer lastKnownChunkVersion) {
        ChunkVersionController.instance.setGenerationVersion(pos, 1);
        this.generateWithLastKnownVersion(pos.field_77276_a, pos.field_77275_b, world, lastKnownChunkVersion);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.func_175624_G().equals(WorldType.field_77138_c)) {
            return;
        }
        ChunkVersionController.instance.setGenerationVersion(new ChunkPos(chunkX, chunkZ), 1);
        this.generateWithLastKnownVersion(chunkX, chunkZ, world, -1);
    }

    private void generateWithLastKnownVersion(int chunkX, int chunkZ, World world, int lastKnownChunkVersion) {
        long worldSeed = world.func_72905_C();
        Random rand = new Random(worldSeed);
        long xSeed = rand.nextLong() >> 3;
        long zSeed = rand.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
        for (WorldGenAttribute attribute : this.worldGenAttributes) {
            if (attribute.attributeVersion <= lastKnownChunkVersion) continue;
            rand.setSeed(chunkSeed);
            attribute.generate(rand, chunkX, chunkZ, world);
        }
    }
}

