/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.attributes;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.block.BlockCustomFlower;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.world.WorldGenAttributeCommon;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public class GenAttributeGlowstoneFlower
extends WorldGenAttributeCommon {
    private static boolean isGeneratingAdditional = false;
    private boolean ignoreSnowCondition = false;

    public GenAttributeGlowstoneFlower() {
        super(1, 6, false, "glowstone_flower", BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD);
    }

    private boolean isApplicableBiome(World world, BlockPos pos) {
        if (this.cfgEntry.shouldIgnoreBiomeSpecifications()) {
            return true;
        }
        Biome b = world.func_180494_b(pos);
        ArrayList types = Lists.newArrayList((Object[])BiomeDictionary.getTypesForBiome((Biome)b));
        if (types.isEmpty()) {
            return false;
        }
        boolean applicable = false;
        for (BiomeDictionary.Type t : types) {
            if (!this.cfgEntry.getTypes().contains(t)) continue;
            applicable = true;
        }
        return applicable;
    }

    @Override
    protected void loadAdditionalConfigEntries(Configuration cfg) {
        this.ignoreSnowCondition = cfg.getBoolean("ignoreSnowCondition", this.cfgEntry.getConfigurationSection(), false, "Set this to true and the decorator will ignore the spawn-condition if snow is/can fall in the area.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(BlockPos pos, World world, Random rand) {
        world.func_175656_a(pos, BlocksAS.customFlower.func_176223_P().func_177226_a(BlockCustomFlower.FLOWER_TYPE, (Comparable)((Object)BlockCustomFlower.FlowerType.GLOW_FLOWER)));
        if (!isGeneratingAdditional) {
            isGeneratingAdditional = true;
            try {
                for (int i = 0; i < 8; ++i) {
                    if (rand.nextInt(4) != 0) continue;
                    this.tryGenerateAtPosition(this.randomOffset(world, pos, rand, 7), world, rand);
                }
            }
            finally {
                isGeneratingAdditional = false;
            }
        }
    }

    private BlockPos randomOffset(World world, BlockPos origin, Random random, int offsetRand) {
        int rX = origin.func_177958_n() - offsetRand + random.nextInt(offsetRand * 2 + 1);
        int rZ = origin.func_177952_p() - offsetRand + random.nextInt(offsetRand * 2 + 1);
        int rY = world.func_175725_q(new BlockPos(rX, 0, rZ)).func_177956_o();
        return new BlockPos(rX, rY, rZ);
    }

    @Override
    public boolean fulfillsSpecificConditions(BlockPos pos, World world, Random random) {
        return this.isApplicableBiome(world, pos) && pos.func_177956_o() >= this.cfgEntry.getMinY() && pos.func_177956_o() <= this.cfgEntry.getMaxY() && world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && (this.ignoreSnowCondition || world.func_175708_f(pos, true));
    }

    @Override
    public BlockPos getGenerationPosition(int chX, int chZ, World world, Random rand) {
        int rX = chX * 16 + rand.nextInt(16) + 8;
        int rZ = chZ * 16 + rand.nextInt(16) + 8;
        int rY = world.func_175725_q(new BlockPos(rX, 0, rZ)).func_177956_o();
        return new BlockPos(rX, rY, rZ);
    }
}

