/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.retrogen;

import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.ChunkVersionBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ChunkVersionController {
    private static final String AS_VERSION_KEY = "AS-ChunkGen-Version";
    public static ChunkVersionController instance = new ChunkVersionController();
    private Map<ChunkPos, Integer> versionBuffer = new ConcurrentHashMap<ChunkPos, Integer>();
    private Collection<ChunkPos> queuedSaveBuffer = new ConcurrentLinkedDeque<ChunkPos>();

    private ChunkVersionController() {
    }

    @Nullable
    public Integer getGenerationVersion(ChunkPos pos) {
        return this.versionBuffer.get(pos);
    }

    public void setGenerationVersion(ChunkPos pos, Integer version) {
        this.versionBuffer.put(pos, version);
    }

    @SubscribeEvent
    public void onChUnload(ChunkEvent.Unload ev) {
        if (ev.getChunk().func_177412_p().field_72995_K) {
            return;
        }
        ChunkPos cp = new ChunkPos(ev.getChunk().field_76635_g, ev.getChunk().field_76647_h);
        if (!this.queuedSaveBuffer.contains(cp)) {
            this.queuedSaveBuffer.add(cp);
        }
    }

    @SubscribeEvent
    public void onChDataLoad(ChunkDataEvent.Load ev) {
        ChunkPos cp = new ChunkPos(ev.getChunk().field_76635_g, ev.getChunk().field_76647_h);
        NBTTagCompound tag = ev.getData();
        if (tag.func_74764_b(AS_VERSION_KEY)) {
            this.versionBuffer.put(cp, tag.func_74762_e(AS_VERSION_KEY));
        } else {
            ChunkVersionBuffer buf = (ChunkVersionBuffer)WorldCacheManager.getOrLoadData(ev.getWorld(), WorldCacheManager.SaveKey.CHUNK_VERSIONING);
            Integer savedVersion = buf.getGenerationVersion(cp);
            if (savedVersion != null) {
                this.versionBuffer.put(cp, savedVersion);
            } else {
                this.versionBuffer.put(cp, -1);
            }
        }
    }

    @SubscribeEvent
    public void onChDataSave(ChunkDataEvent.Save ev) {
        ChunkPos cp = new ChunkPos(ev.getChunk().field_76635_g, ev.getChunk().field_76647_h);
        Integer buf = this.versionBuffer.get(cp);
        if (buf != null) {
            ev.getData().func_74768_a(AS_VERSION_KEY, buf.intValue());
        } else {
            ev.getData().func_74768_a(AS_VERSION_KEY, -1);
        }
    }
}

