/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.structure;

import hellfirepvp.astralsorcery.common.data.world.data.StructureGenBuffer;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.world.structure.WorldGenAttributeStructure;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class StructureSmallShrine
extends WorldGenAttributeStructure {
    public StructureSmallShrine() {
        super(0, "smallShrine", () -> MultiBlockArrays.smallShrine, StructureGenBuffer.StructureType.SMALL, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.FOREST);
        this.idealDistance = 256.0f;
    }

    @Override
    public void generate(BlockPos pos, World world, Random rand) {
        this.getStructureTemplate().placeInWorld(world, pos);
        this.getBuffer(world).markStructureGeneration(pos, this.getStructureType());
    }

    @Override
    public boolean fulfillsSpecificConditions(BlockPos pos, World world, Random random) {
        if (!this.isApplicableBiome(world, pos)) {
            return false;
        }
        if (!this.canSpawnShrineCorner(world, pos.func_177982_a(-4, 0, 4))) {
            return false;
        }
        if (!this.canSpawnShrineCorner(world, pos.func_177982_a(4, 0, -4))) {
            return false;
        }
        if (!this.canSpawnShrineCorner(world, pos.func_177982_a(4, 0, 4))) {
            return false;
        }
        return this.canSpawnShrineCorner(world, pos.func_177982_a(-4, 0, -4));
    }

    private boolean canSpawnShrineCorner(World world, BlockPos pos) {
        int dY = world.func_175672_r(pos).func_177956_o();
        if (dY >= this.cfgEntry.getMinY() && dY <= this.cfgEntry.getMaxY() && Math.abs(dY - pos.func_177956_o()) <= 1 && this.isApplicableBiome(world, pos)) {
            return !world.func_180495_p(new BlockPos(pos.func_177958_n(), dY, pos.func_177952_p())).func_185904_a().func_76224_d();
        }
        return false;
    }

    private boolean isApplicableBiome(World world, BlockPos pos) {
        if (this.cfgEntry.shouldIgnoreBiomeSpecifications()) {
            return true;
        }
        Biome b = world.func_180494_b(pos);
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((Biome)b);
        if (types == null || types.length == 0) {
            return false;
        }
        boolean applicable = false;
        for (BiomeDictionary.Type t : types) {
            if (!this.cfgEntry.getTypes().contains(t)) continue;
            applicable = true;
        }
        return applicable;
    }

    @Override
    public BlockPos getGenerationPosition(int chX, int chZ, World world, Random rand) {
        int rX = chX * 16 + rand.nextInt(16) + 8;
        int rZ = chZ * 16 + rand.nextInt(16) + 8;
        int rY = world.func_175672_r(new BlockPos(rX, 0, rZ)).func_177956_o();
        return new BlockPos(rX, rY, rZ);
    }
}

