/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.core.transform;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import hellfirepvp.astralsorcery.core.ASMTransformationException;
import hellfirepvp.astralsorcery.core.ClassPatch;
import hellfirepvp.astralsorcery.core.SubClassTransformer;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import org.objectweb.asm.tree.ClassNode;

public class AstralPatchTransformer
implements SubClassTransformer {
    private static final String PATCH_PACKAGE = "hellfirepvp.astralsorcery.core.patch";
    private static ClassPatch currentPatch = null;
    private Map<String, List<ClassPatch>> availablePatches = new HashMap<String, List<ClassPatch>>();

    public AstralPatchTransformer() throws IOException {
        FMLLog.info((String)"[AstralTransformer] Loading patches...", (Object[])new Object[0]);
        int loaded = this.loadClassPatches();
        FMLLog.info((String)("[AstralTransformer] Initialized! Loaded " + loaded + " class patches!"), (Object[])new Object[0]);
    }

    private int loadClassPatches() throws IOException {
        ImmutableSet classes = ClassPath.from((ClassLoader)Thread.currentThread().getContextClassLoader()).getTopLevelClassesRecursive(PATCH_PACKAGE);
        LinkedList<Class> patchClasses = new LinkedList<Class>();
        for (ClassPath.ClassInfo info : classes) {
            if (!info.getName().startsWith(PATCH_PACKAGE)) continue;
            patchClasses.add(info.load());
        }
        int load = 0;
        for (Class patchClass : patchClasses) {
            if (!ClassPatch.class.isAssignableFrom(patchClass) || Modifier.isAbstract(patchClass.getModifiers())) continue;
            try {
                ClassPatch patch = (ClassPatch)patchClass.newInstance();
                if (!this.availablePatches.containsKey(patch.getClassName())) {
                    this.availablePatches.put(patch.getClassName(), new LinkedList());
                }
                this.availablePatches.get(patch.getClassName()).add(patch);
                ++load;
            }
            catch (Exception exc) {
                throw new IllegalStateException("Could not load ClassPatch: " + patchClass.getSimpleName(), exc);
            }
        }
        return load;
    }

    @Override
    public void transformClassNode(ClassNode cn, String transformedClassName, String obfName) {
        if (!this.availablePatches.isEmpty()) {
            List<ClassPatch> patches = this.availablePatches.get(transformedClassName);
            if (patches != null && !patches.isEmpty()) {
                FMLLog.info((String)("[AstralTransformer] Transforming " + obfName + " : " + transformedClassName + " with " + patches.size() + " patches!"), (Object[])new Object[0]);
                try {
                    Iterator<ClassPatch> iterator = patches.iterator();
                    while (iterator.hasNext()) {
                        ClassPatch patch;
                        currentPatch = patch = iterator.next();
                        patch.transform(cn);
                        FMLLog.info((String)("[AstralTransformer] Applied patch " + patch.getClass().getSimpleName().toUpperCase()), (Object[])new Object[0]);
                        currentPatch = null;
                    }
                }
                catch (Exception exc) {
                    throw new ASMTransformationException("Applying ClassPatches failed (ClassName: " + obfName + " - " + transformedClassName + ") - Rethrowing exception!", exc);
                }
            }
            this.availablePatches.remove(transformedClassName);
        }
    }

    @Override
    public String getIdentifier() {
        return "Patch based transformer";
    }

    @Override
    public void addErrorInformation() {
        if (currentPatch != null) {
            FMLLog.warning((String)("Patcher was in active patch: " + currentPatch.getClass().getSimpleName()), (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isTransformRequired(String transformedClassName) {
        return this.availablePatches.containsKey(transformedClassName);
    }
}

