/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IFlowerProvider;
import forestry.api.genetics.IPollinatable;
import forestry.core.utils.StringUtil;
import java.util.Collections;
import java.util.EnumSet;
import net.minecraftforge.common.EnumPlantType;

public class FlowerProviderVanilla
implements IFlowerProvider {
    @Override
    public boolean isAcceptedFlower(yc world, IBeeGenome species, int x, int y2, int z) {
        int blockid = world.a(x, y2, z);
        int meta = world.h(x, y2, z);
        if (blockid == amq.cf.cm) {
            return this.checkFlowerPot(meta);
        }
        ur flower = new ur(blockid, 1, meta);
        for (ur stack : FlowerManager.plainFlowers) {
            if (!flower.a(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedPollinatable(yc world, IPollinatable pollinatable) {
        EnumSet types = pollinatable.getPlantType();
        return types.size() > 1 || !types.contains(EnumPlantType.Nether);
    }

    private boolean checkFlowerPot(int meta) {
        return meta == 1 || meta == 2;
    }

    @Override
    public boolean growFlower(yc world, IBeeGenome species, int x, int y2, int z) {
        int blockid = world.a(x, y2, z);
        if (blockid != 0) {
            if (blockid == amq.cf.cm) {
                return this.growInPot(world, x, y2, z);
            }
            return false;
        }
        int groundid = world.a(x, y2 - 1, z);
        if (groundid != amq.y.cm && groundid != amq.x.cm) {
            return false;
        }
        Collections.shuffle(FlowerManager.plainFlowers);
        ur flower = (ur)FlowerManager.plainFlowers.get(world.t.nextInt(FlowerManager.plainFlowers.size() - 1));
        world.d(x, y2, z, flower.c, flower.j());
        return true;
    }

    private boolean growInPot(yc world, int x, int y2, int z) {
        if (world.t.nextBoolean()) {
            world.d(x, y2, z, amq.cf.cm, 1);
        } else {
            world.d(x, y2, z, amq.cf.cm, 2);
        }
        return true;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("flowers.vanilla");
    }

    @Override
    public ur[] affectProducts(yc world, IBeeGenome genome, int x, int y2, int z, ur[] products) {
        return products;
    }

    @Override
    public ur[] getItemStacks() {
        return FlowerManager.plainFlowers.toArray(new ur[0]);
    }
}

