/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.plugins.PluginForestryApiculture;
import java.util.List;

public class AlleleEffectMiasmic
extends AlleleEffectThrottled {
    private int infectionChance = 50;

    public AlleleEffectMiasmic(String uid) {
        super(uid, "misasmic", false, 50, false);
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        yc world = housing.getWorld();
        if (this.isThrottled(storedData)) {
            return storedData;
        }
        aoe infectionBox = this.getBounding(genome, housing, 1.0f);
        List list = world.a(qx.class, infectionBox);
        for (Object obj : list) {
            if (world.t.nextInt(1000) >= this.infectionChance) continue;
            qx player = (qx)obj;
            int duration = 800;
            int count = ItemArmorApiarist.wearsItems(player);
            if (count > 3) continue;
            if (count > 2) {
                duration = 200;
            } else if (count > 1) {
                duration = 400;
            } else if (count > 0) {
                duration = 600;
            }
            player.d(new lm(ll.u.H, duration, 0));
        }
        return storedData;
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int[] area = this.getModifiedArea(genome, housing);
        if (housing.getWorld().t.nextBoolean()) {
            PluginForestryApiculture.proxy.addBeeHiveFX("/gfx/forestry/particles/swarm_bee.png", housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), genome.getPrimaryAsBee().getPrimaryColor(), area[0], area[1], area[2]);
        } else {
            PluginForestryApiculture.proxy.addBeeHiveFX("/gfx/forestry/particles/poison.png", housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), 0xFFFFFF, area[0], area[1], area[2]);
        }
        return storedData;
    }
}

