/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IApiaristTracker;
import forestry.api.genetics.IMutation;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.apiculture.items.ItemBeeGE;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.EnumMutateChance;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.GuiForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemInventory;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.opengl.GL11;

public class GuiApiaristInventory
extends GuiForestry {
    private la inventory;
    private IApiaristTracker breedingTracker;
    private HashMap iconStacks = new HashMap();

    public GuiApiaristInventory(qx player, ContainerForestry container, la inventory) {
        super("/gfx/forestry/gui/apiaristinventory.png", container, inventory, 5, 25);
        this.inventory = inventory;
        this.xSize = 196;
        this.ySize = 202;
        ArrayList beeList = new ArrayList();
        ((ItemBeeGE)ForestryItem.beeDroneGE).addCreativeItems(beeList, false);
        for (ur beeStack : beeList) {
            this.iconStacks.put(BeeManager.beeInterface.getBee(beeStack).getIdent(), beeStack);
        }
        this.breedingTracker = BeeManager.breedingManager.getApiaristTracker(player.p, player.bR);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        int tex = this.f.o.b(this.textureFile);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f.o.b(tex);
        this.b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        String header = StringUtil.localize("gui.page") + " " + (this.pageCurrent + 1) + "/" + this.pageMax;
        this.l.b(header, this.guiLeft + 95 + this.getCenteredOffset(header, 98), this.guiTop + 10, this.fontColor.get("gui.title"));
        IBee bee = this.getBeeAtPosition(i, j);
        if (bee == null) {
            this.displayBreedingStatistics(10);
        }
        if (bee != null) {
            arw.c();
            this.startPage();
            this.displaySpeciesInformation(true, bee.getGenome().getPrimaryAsBee(), (ur)this.iconStacks.get(bee.getIdent()), 10);
            if (!bee.isPureBred(EnumBeeChromosome.SPECIES)) {
                this.displaySpeciesInformation(bee.isAnalyzed(), bee.getGenome().getSecondaryAsBee(), (ur)this.iconStacks.get(bee.getGenome().getSecondaryAsBee().getUID()), 10);
            }
            this.endPage();
        }
    }

    @Override
    public void b() {
        super.b();
        if (this.f.g == null) {
            return;
        }
        if (this.inventorySlots instanceof ContainerItemInventory) {
            ((ContainerItemInventory)this.inventorySlots).purgeBag((qx)this.f.g);
        }
        if (!Proxies.common.isSimulating(Proxies.common.getRenderWorld())) {
            return;
        }
        if (this.inventory instanceof ItemInventory) {
            ItemInventory inv = (ItemInventory)this.inventory;
            if (inv.isItemInventory) {
                inv.onGuiSaved((qx)this.f.g);
            }
        }
    }

    @Override
    public void A_() {
        super.A_();
        this.i.add(new atb(1, this.guiLeft + 99, this.guiTop + 7, 10, 12, "<"));
        this.i.add(new atb(2, this.guiLeft + 179, this.guiTop + 7, 10, 12, ">"));
    }

    protected void a(atb guibutton) {
        super.a(guibutton);
        if (guibutton.f == 1 && this.pageCurrent > 0) {
            this.flipPage(this.pageCurrent - 1);
        } else if (guibutton.f == 2 && this.pageCurrent < this.pageMax - 1) {
            this.flipPage(this.pageCurrent + 1);
        }
    }

    private IBee getBeeAtPosition(int x, int y2) {
        sr slot = this.getSlotAtPosition(x, y2);
        if (slot == null) {
            return null;
        }
        if (!slot.d()) {
            return null;
        }
        if (!slot.c().o()) {
            return null;
        }
        if (!BeeManager.beeInterface.isBee(slot.c())) {
            return null;
        }
        return BeeManager.beeInterface.getBee(slot.c());
    }

    private void displayBreedingStatistics(int x) {
        this.startPage();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.speciescount") + ": " + this.breedingTracker.getSpeciesBred() + "/" + BeeManager.breedingManager.getBeeSpeciesCount(), x);
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.queens") + ": " + this.breedingTracker.getQueenCount(), x);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.princesses") + ": " + this.breedingTracker.getPrincessCount(), x);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.drones") + ": " + this.breedingTracker.getDroneCount(), x);
        this.newLine();
        this.endPage();
    }

    private void displaySpeciesInformation(boolean analyzed, IAlleleBeeSpecies species, ur iconStack, int x) {
        if (!analyzed) {
            this.drawLine(StringUtil.localize("gui.unknown"), x);
            return;
        }
        this.drawLine(species.getName(), x);
        itemRenderer.a(this.l, this.f.o, iconStack, this.adjustToFactor(this.guiLeft + x + 69), this.adjustToFactor(this.guiTop + this.getLineY() - 2));
        itemRenderer.c(this.l, this.f.o, iconStack, this.adjustToFactor(this.guiLeft + x + 69), this.adjustToFactor(this.guiTop + this.getLineY() - 2));
        this.newLine();
        int columnWidth = 16;
        int column = 10;
        for (IMutation combination : BeeTemplates.getCombinations(species)) {
            if (combination.isSecret()) continue;
            if (this.breedingTracker.isDiscovered(combination)) {
                this.drawMutationIcon(combination, species, column);
            } else {
                this.drawUnknownIcon(combination, column);
            }
            if ((column += columnWidth) <= 75) continue;
            column = 10;
            this.newLine(18);
        }
        this.newLine();
        this.newLine();
    }

    private void drawMutationIcon(IMutation combination, IAlleleBeeSpecies species, int x) {
        itemRenderer.a(this.l, this.f.o, (ur)this.iconStacks.get(combination.getPartner(species).getUID()), this.adjustToFactor(this.guiLeft + x), this.adjustToFactor(this.guiTop + this.getLineY()));
        itemRenderer.c(this.l, this.f.o, (ur)this.iconStacks.get(combination.getPartner(species).getUID()), this.adjustToFactor(this.guiLeft + x), this.adjustToFactor(this.guiTop + this.getLineY()));
        int line = 48;
        int column = 0;
        EnumMutateChance chance = EnumMutateChance.rateChance(combination.getBaseChance());
        if (chance == EnumMutateChance.HIGHEST) {
            line += 16;
            column = 228;
        } else if (chance == EnumMutateChance.HIGHER) {
            line += 16;
            column = 212;
        } else if (chance == EnumMutateChance.HIGH) {
            line += 16;
            column = 196;
        } else if (chance == EnumMutateChance.NORMAL) {
            line += 0;
            column = 228;
        } else if (chance == EnumMutateChance.LOW) {
            line += 0;
            column = 212;
        } else {
            line += 0;
            column = 196;
        }
        this.f.o.b(this.f.o.b("/gfx/forestry/gui/apiaristinventory.png"));
        this.b(this.adjustToFactor(this.guiLeft + x), this.adjustToFactor(this.guiTop + this.getLineY()), column, line, 16, 16);
    }

    private void drawUnknownIcon(IMutation mutation, int x) {
        int chance = mutation.getBaseChance();
        int line = 0;
        int column = 0;
        if (chance >= 20) {
            line = 16;
            column = 228;
        } else if (chance >= 15) {
            line = 16;
            column = 212;
        } else if (chance >= 12) {
            line = 16;
            column = 196;
        } else if (chance >= 10) {
            line = 0;
            column = 228;
        } else if (chance >= 5) {
            line = 0;
            column = 212;
        } else {
            line = 0;
            column = 196;
        }
        this.f.o.b(this.f.o.b("/gfx/forestry/gui/apiaristinventory.png"));
        this.b(this.adjustToFactor(this.guiLeft + x), this.adjustToFactor(this.guiTop + this.getLineY()), column, line, 16, 16);
    }
}

