/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.EnumTolerance;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.TileMachine;
import forestry.core.genetics.ClimateHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ComponentVillageBeeHouse
extends afs {
    protected ur[] buildingBlocks = new ur[]{new ur(ForestryBlock.planks, 1, 15), new ur(amq.M, 1, 0)};
    protected int averageGroundLevel = -1;

    public ComponentVillageBeeHouse(afp startPiece, int componentType, Random random, acn boundingBox, int coordBaseMode) {
        super(startPiece, componentType);
        this.f = coordBaseMode;
        this.e = boundingBox;
    }

    public static ComponentVillageBeeHouse buildComponent(afp startPiece, List par1List, Random random, int par3, int par4, int par5, int par6, int par7) {
        acn bbox = acn.a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)9, (int)9, (int)6, (int)par6);
        return ComponentVillageBeeHouse.a((acn)bbox) && aez.a((List)par1List, (acn)bbox) == null ? new ComponentVillageBeeHouse(startPiece, par7, random, bbox, par6) : null;
    }

    protected boolean isDesertVillage() {
        return this.k.b;
    }

    public boolean a(yc world, Random random, acn structBoundingBox) {
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.b(world, structBoundingBox);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.e.a(0, this.averageGroundLevel - this.e.e + 8 - 1, 0);
        }
        this.a(world, structBoundingBox, 1, 1, 1, 7, 4, 4, 0, 0, false);
        this.a(world, structBoundingBox, 2, 1, 6, 8, 4, 10, 0, 0, false);
        this.buildGarden(world, structBoundingBox);
        this.a(world, structBoundingBox, 1, 1, 6, 1, 1, 10, amq.bc.cm, amq.bc.cm, false);
        this.a(world, structBoundingBox, 8, 1, 6, 8, 1, 10, amq.bc.cm, amq.bc.cm, false);
        this.a(world, structBoundingBox, 2, 1, 10, 7, 1, 10, amq.bc.cm, amq.bc.cm, false);
        this.plantFlowerGarden(world, structBoundingBox, 2, 1, 5, 7, 1, 9);
        this.buildApiaries(world, structBoundingBox, 3, 1, 4, 6, 1, 8);
        this.a(world, structBoundingBox, 1, 0, 1, 7, 0, 4, amq.A.cm, amq.A.cm, false);
        this.a(world, structBoundingBox, 0, 0, 0, 0, 3, 5, amq.z.cm, amq.z.cm, false);
        this.a(world, structBoundingBox, 8, 0, 0, 8, 3, 5, amq.z.cm, amq.z.cm, false);
        this.a(world, structBoundingBox, 1, 0, 0, 7, 1, 0, amq.z.cm, amq.z.cm, false);
        this.a(world, structBoundingBox, 1, 0, 5, 7, 1, 5, amq.z.cm, amq.z.cm, false);
        this.fillBoxWith(world, structBoundingBox, 1, 2, 0, 7, 3, 0, this.buildingBlocks[0], false);
        this.fillBoxWith(world, structBoundingBox, 1, 2, 5, 7, 3, 5, this.buildingBlocks[0], false);
        this.fillBoxWith(world, structBoundingBox, 0, 4, 1, 8, 4, 1, this.buildingBlocks[0], false);
        this.fillBoxWith(world, structBoundingBox, 0, 4, 4, 8, 4, 4, this.buildingBlocks[0], false);
        this.fillBoxWith(world, structBoundingBox, 0, 5, 2, 8, 5, 3, this.buildingBlocks[0], false);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[0], 0, 4, 2, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[0], 0, 4, 3, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[0], 8, 4, 2, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[0], 8, 4, 3, structBoundingBox);
        this.buildRoof(world, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[1], 0, 2, 1, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[1], 0, 2, 4, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[1], 8, 2, 1, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[1], 8, 2, 4, structBoundingBox);
        this.a(world, amq.bt.cm, 0, 0, 2, 2, structBoundingBox);
        this.a(world, amq.bt.cm, 0, 0, 2, 3, structBoundingBox);
        this.a(world, amq.bt.cm, 0, 8, 2, 2, structBoundingBox);
        this.a(world, amq.bt.cm, 0, 8, 2, 3, structBoundingBox);
        this.a(world, amq.bt.cm, 0, 2, 2, 5, structBoundingBox);
        this.a(world, amq.bt.cm, 0, 3, 2, 5, structBoundingBox);
        this.a(world, amq.bt.cm, 0, 4, 2, 5, structBoundingBox);
        this.a(world, amq.bt.cm, 0, 5, 2, 0, structBoundingBox);
        this.a(world, amq.bt.cm, 0, 6, 2, 5, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[0], 1, 1, 3, structBoundingBox);
        this.a(world, 0, 0, 2, 1, 0, structBoundingBox);
        this.a(world, 0, 0, 2, 2, 0, structBoundingBox);
        this.a(world, structBoundingBox, random, 2, 1, 0, this.c(amq.aH.cm, 1));
        if (this.a(world, 2, 0, -1, structBoundingBox) == 0 && this.a(world, 2, -1, -1, structBoundingBox) != 0) {
            this.a(world, amq.aK.cm, this.c(amq.aK.cm, 3), 2, 0, -1, structBoundingBox);
        }
        this.a(world, 0, 0, 6, 1, 5, structBoundingBox);
        this.a(world, 0, 0, 6, 2, 5, structBoundingBox);
        this.a(world, ForestryBlock.candle.cm, 0, 2, 3, 4, structBoundingBox);
        this.a(world, ForestryBlock.candle.cm, 0, 6, 3, 4, structBoundingBox);
        this.a(world, ForestryBlock.candle.cm, 0, 2, 3, 1, structBoundingBox);
        this.a(world, ForestryBlock.candle.cm, 0, 6, 3, 1, structBoundingBox);
        this.a(world, structBoundingBox, random, 6, 1, 5, this.c(amq.aH.cm, 1));
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.b(world, j, 7, i, structBoundingBox);
                this.b(world, amq.z.cm, 0, j, -1, i, structBoundingBox);
            }
        }
        this.a(world, this.e, 7, 1, 1, 1);
        return true;
    }

    private void buildRoof(yc world, acn structBoundingBox) {
        int rotatedMetaDoor = this.c(amq.aw.cm, 3);
        int rotatedMetaGarden = this.c(amq.aw.cm, 2);
        for (int i = -1; i <= 2; ++i) {
            for (int j = 0; j <= 8; ++j) {
                this.a(world, amq.aw.cm, rotatedMetaDoor, j, 4 + i, i, structBoundingBox);
                this.a(world, amq.aw.cm, rotatedMetaGarden, j, 4 + i, 5 - i, structBoundingBox);
            }
        }
    }

    protected void buildGarden(yc world, acn box) {
        int groundId = amq.y.cm;
        if (this.isDesertVillage()) {
            groundId = amq.H.cm;
        }
        for (int i = 1; i <= 8; ++i) {
            for (int j = 6; j <= 10; ++j) {
                this.b(world, groundId, 0, i, 0, j, box);
            }
        }
    }

    protected void plantFlowerGarden(yc world, acn box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (this.isDesertVillage()) {
            this.a(world, amq.aY.cm, 0, 4, 1, 7, box);
            return;
        }
        for (int i = minY; i <= maxY; ++i) {
            for (int j = minX; j <= maxX; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    int zCoord;
                    int yCoord;
                    int xCoord;
                    if (!world.t.nextBoolean() || !amq.ah.d(world, xCoord = this.a(j, k), yCoord = this.a(i), zCoord = this.b(j, k))) continue;
                    ur flower = (ur)FlowerManager.plainFlowers.get(world.t.nextInt(FlowerManager.plainFlowers.size()));
                    this.a(world, flower.c, flower.j(), j, i, k, box);
                }
            }
        }
    }

    protected void buildApiaries(yc world, acn box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.populateApiary(world, box, 3, 1, 8);
        this.populateApiary(world, box, 6, 1, 8);
    }

    private void populateApiary(yc world, acn box, int x, int y2, int z) {
        int zCoord;
        int yCoord;
        int xCoord = this.a(x, z);
        if (box.b(xCoord, yCoord = this.a(y2), zCoord = this.b(x, z)) && world.a(xCoord, yCoord, zCoord) != ForestryBlock.machine.cm && world.f(xCoord, yCoord - 1, zCoord)) {
            world.d(xCoord, yCoord, zCoord, ForestryBlock.machine.cm, 7);
            ForestryBlock.machine.g(world, xCoord, yCoord, zCoord);
            any tile = world.q(xCoord, yCoord, zCoord);
            if (tile instanceof TileMachine) {
                TileMachine apiary = (TileMachine)tile;
                apiary.initialize();
                apiary.a(0, BeeManager.beeInterface.getBeeStack(this.getVillageBee(world, xCoord, yCoord, zCoord), EnumBeeType.PRINCESS));
                apiary.a(1, BeeManager.beeInterface.getBeeStack(this.getVillageBee(world, xCoord, yCoord, zCoord), EnumBeeType.DRONE));
                for (int i = 9; i < 12; ++i) {
                    float roll = world.t.nextFloat();
                    if (roll < 0.2f) {
                        apiary.a(i, new ur(ForestryItem.frameUntreated));
                        continue;
                    }
                    if (roll < 0.4f) {
                        apiary.a(i, new ur(ForestryItem.frameImpregnated));
                        continue;
                    }
                    if (!((double)roll < 0.6)) continue;
                    apiary.a(i, new ur(ForestryItem.frameProven));
                }
            }
        }
    }

    private IBee getVillageBee(yc world, int xCoord, int yCoord, int zCoord) {
        yy biome = world.a(xCoord, zCoord);
        ArrayList candidates = BeeManager.villageBees[1] != null && BeeManager.villageBees[1].size() > 0 && world.t.nextDouble() < 0.2 ? BeeManager.villageBees[1] : BeeManager.villageBees[0];
        ArrayList<IBeeGenome> valid = new ArrayList<IBeeGenome>();
        for (IBeeGenome genome : candidates) {
            if (!this.checkBiomeHazard(genome, biome.F, biome.G)) continue;
            valid.add(genome);
        }
        if (valid.isEmpty()) {
            return BeeManager.beeInterface.getBee(world, (IBeeGenome)BeeManager.villageBees[0].get(world.t.nextInt(BeeManager.villageBees[0].size())));
        }
        return BeeManager.beeInterface.getBee(world, (IBeeGenome)valid.get(world.t.nextInt(valid.size())));
    }

    private boolean checkBiomeHazard(IBeeGenome genome, float temperature, float humidity) {
        EnumTemperature beeTemperature = genome.getPrimaryAsBee().getTemperature();
        EnumTolerance temperatureTolerance = genome.getToleranceTemp();
        ArrayList toleratedTemperatures = ClimateHelper.getToleratedTemperature(beeTemperature, temperatureTolerance);
        boolean validTemp = false;
        validTemp = toleratedTemperatures.contains((Object)ClimateHelper.getTemperature(temperature));
        if (!validTemp) {
            return false;
        }
        EnumHumidity beeHumidity = genome.getPrimaryAsBee().getHumidity();
        EnumTolerance humidityTolerance = genome.getToleranceHumid();
        ArrayList toleratedHumidity = ClimateHelper.getToleratedHumidity(beeHumidity, humidityTolerance);
        boolean validHumidity = false;
        validHumidity = toleratedHumidity.contains((Object)ClimateHelper.getHumidity(humidity));
        return validHumidity;
    }

    protected void fillBoxWith(yc world, acn box, int par3, int par4, int par5, int par6, int par7, int par8, ur buildingBlock, boolean replace) {
        for (int var14 = par4; var14 <= par7; ++var14) {
            for (int var15 = par3; var15 <= par6; ++var15) {
                for (int var16 = par5; var16 <= par8; ++var16) {
                    if (replace && this.a(world, var15, var14, var16, box) == 0) continue;
                    this.a(world, buildingBlock.c, buildingBlock.j(), var15, var14, var16, box);
                }
            }
        }
    }

    protected void placeBlockAtCurrentPosition(yc world, ur buildingBlock, int par4, int par5, int par6, acn par7StructureBoundingBox) {
        int var10;
        int var9;
        int var8 = this.a(par4, par6);
        if (par7StructureBoundingBox.b(var8, var9 = this.a(par5), var10 = this.b(par4, par6))) {
            world.c(var8, var9, var10, buildingBlock.c, buildingBlock.j());
        }
    }

    protected int b(int villagerCount) {
        return 80;
    }
}

