/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.FruitProviderNone;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FruitProviderRipening
extends FruitProviderNone {
    String key;
    IFruitFamily family;
    HashMap products = new HashMap();
    int textureIndex;
    int ripeningPeriod = 10;
    int colourRipe = 0xFFFFFF;
    int colourCallow = 0xFFFFFF;
    int diffR;
    int diffG;
    int diffB = 0;

    public FruitProviderRipening(String key, IFruitFamily family, ur product, float modifier, int textureIndex) {
        this.key = key;
        this.family = family;
        this.products.put(product, Float.valueOf(modifier));
        this.textureIndex = textureIndex;
    }

    public FruitProviderRipening setColours(int ripe, int callow) {
        this.colourRipe = ripe;
        this.colourCallow = callow;
        this.diffR = (ripe >> 16 & 0xFF) - (callow >> 16 & 0xFF);
        this.diffG = (ripe >> 8 & 0xFF) - (callow >> 8 & 0xFF);
        this.diffB = (ripe & 0xFF) - (callow & 0xFF);
        return this;
    }

    public FruitProviderRipening setRipeningPeriod(int period) {
        this.ripeningPeriod = period;
        return this;
    }

    @Override
    public IFruitFamily getFamily() {
        return this.family;
    }

    private float getRipeningStage(int ripeningTime) {
        if (ripeningTime >= this.ripeningPeriod) {
            return 1.0f;
        }
        return (float)ripeningTime / (float)this.ripeningPeriod;
    }

    @Override
    public ur[] getFruits(ITreeGenome genome, yc world, int x, int y2, int z, int ripeningTime) {
        ArrayList<ur> product = new ArrayList<ur>();
        float stage = this.getRipeningStage(ripeningTime);
        if (stage < 0.5f) {
            return new ur[0];
        }
        for (Map.Entry entry : this.products.entrySet()) {
            if (!(world.t.nextFloat() <= genome.getYield() * ((Float)entry.getValue()).floatValue() * 5.0f * stage)) continue;
            product.add(((ur)entry.getKey()).l());
        }
        return product.toArray(new ur[0]);
    }

    @Override
    public ur[] getProducts() {
        return this.products.keySet().toArray(new ur[0]);
    }

    @Override
    public ur[] getSpecialty() {
        return new ur[0];
    }

    @Override
    public int getRipeningPeriod() {
        return this.ripeningPeriod;
    }

    @Override
    public boolean markAsFruitLeaf(ITreeGenome genome, yc world, int x, int y2, int z) {
        return true;
    }

    @Override
    public int getColour(ITreeGenome genome, ym world, int x, int y2, int z, int ripeningTime) {
        float stage = this.getRipeningStage(ripeningTime);
        int r = (this.colourCallow >> 16 & 0xFF) + (int)((float)this.diffR * stage);
        int g = (this.colourCallow >> 8 & 0xFF) + (int)((float)this.diffG * stage);
        int b = (this.colourCallow & 0xFF) + (int)((float)this.diffB * stage);
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    @Override
    public String getDescription() {
        return "fruits." + this.key;
    }

    @Override
    public int getTextureIndex(ITreeGenome genome, ym world, int x, int y2, int z, int ripeningTime, boolean fancy) {
        return this.textureIndex;
    }
}

