/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.arboriculture.gadgets.TileTreeContainer;
import forestry.core.genetics.Allele;
import forestry.core.network.ForestryPacket;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.plugins.PluginForestryArboriculture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraftforge.common.EnumPlantType;

public class TileLeaves
extends TileTreeContainer
implements IPollinatable,
IFruitBearer {
    private int colourLeaves;
    private int colourFruits;
    private int textureIndexFancy = 48;
    private int textureIndexPlain = 64;
    private int textureIndexFruits = -1;
    private boolean isFruitLeaf;
    private int ripeningTime;

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.isFruitLeaf = nbttagcompound.n("FL");
        this.ripeningTime = nbttagcompound.e("RT");
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("FL", this.isFruitLeaf);
        nbttagcompound.a("RT", this.ripeningTime);
    }

    @Override
    public void onBlockTick() {
        if (!this.hasFruit()) {
            return;
        }
        if (this.ripeningTime >= 32766) {
            return;
        }
        if (this.k.t.nextFloat() < this.getTree().getGenome().getSappiness()) {
            ++this.ripeningTime;
            this.sendNetworkUpdateRipening();
        }
    }

    @Override
    public void setTree(ITree tree) {
        if (tree.canBearFruit()) {
            this.isFruitLeaf = tree.getGenome().getFruitProvider().markAsFruitLeaf(tree.getGenome(), this.k, this.l, this.m, this.n);
        }
        super.setTree(tree);
    }

    public int getFoliageColour() {
        return this.colourLeaves;
    }

    public int getFruitColour() {
        return this.colourFruits;
    }

    public int getTextureIndex(boolean fancy) {
        if (fancy) {
            return this.textureIndexFancy;
        }
        return this.textureIndexPlain;
    }

    public int getTextureFruits() {
        return this.textureIndexFruits;
    }

    public int getRipeningTime() {
        return this.ripeningTime;
    }

    @Override
    public EnumSet getPlantType() {
        if (this.getTree() == null) {
            return EnumSet.noneOf(EnumPlantType.class);
        }
        return this.getTree().getPlantTypes();
    }

    @Override
    public boolean canMateWith(IIndividual individual) {
        if (this.getTree() == null) {
            return false;
        }
        if (this.getTree().getMate() != null) {
            return false;
        }
        return !this.getTree().getGenome().isGeneticEqual(individual.getGenome());
    }

    @Override
    public void mateWith(IIndividual individual) {
        if (this.getTree() == null) {
            return;
        }
        this.getTree().mate((ITree)individual);
    }

    @Override
    public IIndividual getPollen() {
        return this.getTree();
    }

    private int determineFoliageColour() {
        if (this.getTree() == null) {
            return PluginForestryArboriculture.proxy.getFoliageColorBasic();
        }
        int colour = this.getTree().getGenome().getPrimaryAsTree().getPrimaryColor();
        if (this.getTree().getMate() != null) {
            return this.getTree().getGenome().getPrimaryAsTree().getSecondaryColor();
        }
        return colour;
    }

    private int determineFruitColour() {
        if (this.getTree() == null) {
            return 0xFFFFFF;
        }
        IFruitProvider fruit = this.getTree().getGenome().getFruitProvider();
        return fruit.getColour(this.getTree().getGenome(), (ym)this.k, this.l, this.m, this.n, this.getRipeningTime());
    }

    private int determineTextureIndex(boolean fancy) {
        if (this.getTree() != null) {
            return this.getTree().getGenome().getPrimaryAsTree().getLeafTextureIndex(this.getTree(), fancy);
        }
        return 48;
    }

    private int determineOverlayIndex() {
        if (this.getTree() == null) {
            return -1;
        }
        if (!this.hasFruit()) {
            return -1;
        }
        IFruitProvider fruit = this.getTree().getGenome().getFruitProvider();
        if (this.getTree().getGenome().getPrimary() == Allele.treeOak && fruit == ((IAlleleFruit)((Object)Allele.fruitApple)).getProvider()) {
            return -1;
        }
        return fruit.getTextureIndex(this.getTree().getGenome(), (ym)this.k, this.l, this.m, this.n, this.getRipeningTime(), true);
    }

    @Override
    public ef l() {
        return this.toPacket().getPacket();
    }

    @Override
    public void sendNetworkUpdate() {
        Proxies.net.sendNetworkPacket(this.toPacket(), this.l, this.m, this.n);
    }

    private void sendNetworkUpdateRipening() {
        Proxies.net.sendNetworkPacket(new PacketUpdate(1, this.l, this.m, this.n, this.determineFruitColour()), this.l, this.m, this.n);
    }

    private ForestryPacket toPacket() {
        PacketPayload payload = new PacketPayload(2, 5);
        payload.shortPayload[0] = (short)this.ripeningTime;
        if (this.isFruitLeaf) {
            payload.shortPayload[1] = 1;
        }
        if (this.getTree() != null) {
            payload.intPayload[0] = this.determineFruitColour();
            payload.intPayload[1] = this.determineFoliageColour();
            payload.shortPayload[2] = (short)this.determineTextureIndex(true);
            payload.shortPayload[3] = (short)this.determineTextureIndex(false);
            payload.shortPayload[4] = (short)this.determineOverlayIndex();
        }
        return new PacketUpdate(1, this.l, this.m, this.n, payload);
    }

    @Override
    public void fromPacket(ForestryPacket packetRaw) {
        PacketUpdate packet = (PacketUpdate)packetRaw;
        if (packet.payload.shortPayload.length > 0) {
            this.ripeningTime = packet.payload.shortPayload[0];
            this.isFruitLeaf = packet.payload.intPayload[1] > 0;
            this.textureIndexFancy = packet.payload.shortPayload[2];
            this.textureIndexPlain = packet.payload.shortPayload[3];
            this.textureIndexFruits = packet.payload.shortPayload[4];
        }
        if (packet.payload.intPayload.length > 0) {
            this.colourFruits = packet.payload.intPayload[0];
        }
        if (packet.payload.intPayload.length > 1) {
            this.colourLeaves = packet.payload.intPayload[1];
        }
        this.k.o(this.l, this.m, this.n);
    }

    @Override
    public Collection pickFruit(ur tool) {
        if (!this.hasFruit()) {
            return new ArrayList();
        }
        if (this.getTree() == null) {
            return new ArrayList();
        }
        ArrayList<ur> picked = new ArrayList<ur>(Arrays.asList(this.getTree().produceStacks(this.k, this.l, this.m, this.n, this.getRipeningTime())));
        this.ripeningTime = 0;
        this.sendNetworkUpdateRipening();
        return picked;
    }

    @Override
    public IFruitFamily getFruitFamily() {
        if (this.getTree() == null) {
            return null;
        }
        return this.getTree().getGenome().getFruitProvider().getFamily();
    }

    @Override
    public float getRipeness() {
        if (this.getTree() == null) {
            return 0.0f;
        }
        int ripeningPeriod = this.getTree().getGenome().getFruitProvider().getRipeningPeriod();
        if (ripeningPeriod == 0) {
            return 1.0f;
        }
        return (float)this.ripeningTime / (float)ripeningPeriod;
    }

    @Override
    public boolean hasFruit() {
        return this.isFruitLeaf;
    }

    @Override
    public void addRipeness(float add) {
        if (this.getTree() == null) {
            return;
        }
        this.ripeningTime = (int)((float)this.ripeningTime + (float)this.getTree().getGenome().getFruitProvider().getRipeningPeriod() * add);
        this.sendNetworkUpdateRipening();
    }
}

