/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import forestry.arboriculture.gadgets.BlockLeaves;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.plugins.PluginForestryArboriculture;

public class LeavesRenderingHandler
implements ISimpleBlockRenderingHandler {
    private static final double OVERLAY_SHIFT = 0.01;

    public void renderInventoryBlock(amq block, int metadata, int modelID, bbb renderer) {
    }

    public boolean renderWorldBlock(ym world, int x, int y2, int z, amq block, int modelId, bbb renderer) {
        renderer.q(block, x, y2, z);
        TileLeaves tile = BlockLeaves.getLeafTile(world, x, y2, z);
        int fruitIndex = -1;
        int fruitColor = 0xFFFFFF;
        if (tile != null) {
            fruitIndex = tile.getTextureFruits();
            fruitColor = tile.getFruitColour();
        }
        if (fruitIndex >= 0) {
            this.renderFruitOverlay(world, block, x, y2, z, renderer, fruitIndex, fruitColor);
        }
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return false;
    }

    public int getRenderId() {
        return PluginForestryArboriculture.modelIdLeaves;
    }

    private boolean renderFruitOverlay(ym world, amq block, int x, int y2, int z, bbb renderer, int textureIndex, int multiplier) {
        float mR = (float)(multiplier >> 16 & 0xFF) / 255.0f;
        float mG = (float)(multiplier >> 8 & 0xFF) / 255.0f;
        float mB = (float)(multiplier & 0xFF) / 255.0f;
        if (ban.a) {
            mR = (mR * 30.0f + mG * 59.0f + mB * 11.0f) / 100.0f;
            mG = (mR * 30.0f + mG * 70.0f) / 100.0f;
            mB = (mR * 30.0f + mB * 70.0f) / 100.0f;
        }
        return this.renderFruitOverlayWithColorMultiplier(world, block, x, y2, z, mR, mG, mB, renderer, textureIndex);
    }

    private boolean renderFruitOverlayWithColorMultiplier(ym world, amq block, int x, int y2, int z, float r, float g, float b, bbb renderer, int textureIndex) {
        int mixedBrightness = block.e(world, x, y2, z);
        float adjR = 0.5f * r;
        float adjG = 0.5f * g;
        float adjB = 0.5f * b;
        this.renderBottomFace(world, block, x, y2, z, renderer, textureIndex, mixedBrightness, adjR, adjG, adjB);
        this.renderTopFace(world, block, x, y2, z, renderer, textureIndex, mixedBrightness, adjR, adjG, adjB);
        this.renderEastFace(world, block, x, y2, z, renderer, textureIndex, mixedBrightness, adjR, adjG, adjB);
        this.renderWestFace(world, block, x, y2, z, renderer, textureIndex, mixedBrightness, adjR, adjG, adjB);
        this.renderNorthFace(world, block, x, y2, z, renderer, textureIndex, mixedBrightness, adjR, adjG, adjB);
        this.renderSouthFace(world, block, x, y2, z, renderer, textureIndex, mixedBrightness, adjR, adjG, adjB);
        return true;
    }

    private int determineMixedBrightness(ym world, amq par1Block, int x, int y2, int z, bbb renderer, int mixedBrightness) {
        return renderer.i > 0.0 ? mixedBrightness : par1Block.e(world, x, y2 - 1, z);
    }

    private void renderBottomFace(ym world, amq block, int x, int y2, int z, bbb renderer, int textureIndex, int mixedBrightness, float r, float g, float b) {
        if (!renderer.f && !block.a(world, x, y2 - 1, z, 0)) {
            return;
        }
        baz tesselator = baz.a;
        tesselator.c(this.determineMixedBrightness(world, block, x, y2 - 1, z, renderer, mixedBrightness));
        tesselator.a(r, g, b);
        renderer.a(block, (double)x, (double)y2 - 0.01, (double)z, textureIndex);
    }

    private void renderTopFace(ym world, amq block, int x, int y2, int z, bbb renderer, int textureIndex, int mixedBrightness, float r, float g, float b) {
        if (!renderer.f && !block.a(world, x, y2 + 1, z, 1)) {
            return;
        }
        baz tesselator = baz.a;
        tesselator.c(this.determineMixedBrightness(world, block, x, y2 + 1, z, renderer, mixedBrightness));
        tesselator.a(r, g, b);
        renderer.b(block, (double)x, (double)y2 + 0.01, (double)z, textureIndex);
    }

    private void renderEastFace(ym world, amq block, int x, int y2, int z, bbb renderer, int textureIndex, int mixedBrightness, float r, float g, float b) {
        if (!renderer.f && !block.a(world, x, y2, z - 1, 2)) {
            return;
        }
        baz tesselator = baz.a;
        tesselator.c(this.determineMixedBrightness(world, block, x, y2, z - 1, renderer, mixedBrightness));
        tesselator.a(r, g, b);
        renderer.c(block, (double)x, (double)y2, (double)z - 0.01, textureIndex);
    }

    private void renderWestFace(ym world, amq block, int x, int y2, int z, bbb renderer, int textureIndex, int mixedBrightness, float r, float g, float b) {
        if (!renderer.f && !block.a(world, x, y2, z + 1, 3)) {
            return;
        }
        baz tesselator = baz.a;
        tesselator.c(this.determineMixedBrightness(world, block, x, y2, z + 1, renderer, mixedBrightness));
        tesselator.a(r, g, b);
        renderer.d(block, (double)x, (double)y2, (double)z + 0.01, textureIndex);
    }

    private void renderNorthFace(ym world, amq block, int x, int y2, int z, bbb renderer, int textureIndex, int mixedBrightness, float r, float g, float b) {
        if (!renderer.f && !block.a(world, x - 1, y2, z, 4)) {
            return;
        }
        baz tesselator = baz.a;
        tesselator.c(this.determineMixedBrightness(world, block, x - 1, y2, z, renderer, mixedBrightness));
        tesselator.a(r, g, b);
        renderer.e(block, (double)x - 0.01, (double)y2, (double)z, textureIndex);
    }

    private void renderSouthFace(ym world, amq block, int x, int y2, int z, bbb renderer, int textureIndex, int mixedBrightness, float r, float g, float b) {
        if (!renderer.f && !block.a(world, x + 1, y2, z, 5)) {
            return;
        }
        baz tesselator = baz.a;
        tesselator.c(this.determineMixedBrightness(world, block, x + 1, y2, z, renderer, mixedBrightness));
        tesselator.a(r, g, b);
        renderer.f(block, (double)x + 0.01, (double)y2, (double)z, textureIndex);
    }
}

