/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.BlockTypeVoid;
import forestry.core.utils.Vect;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.WorldGenBase;
import java.util.Random;

public abstract class WorldGenArboriculture
extends WorldGenBase {
    protected ITreeGenData tree;
    protected int startX;
    protected int startY;
    protected int startZ;
    BlockType leaf;
    BlockType wood;
    BlockType vine;
    BlockType air;

    public WorldGenArboriculture(ITreeGenData tree) {
        this.vine = new BlockType(amq.bx.cm, 0);
        this.air = new BlockTypeVoid();
        this.tree = tree;
    }

    @Override
    public boolean a(yc world, Random random, int x, int y2, int z) {
        super.a(world, random, x, y2, z);
        this.startX = x;
        this.startY = y2;
        this.startZ = z;
        this.leaf = this.getLeaf();
        this.wood = this.getWood();
        this.preGenerate();
        if (!this.canGrow()) {
            return false;
        }
        this.generate();
        return true;
    }

    public abstract void preGenerate();

    public abstract void generate();

    public abstract boolean canGrow();

    public abstract BlockType getLeaf();

    public abstract BlockType getWood();

    public final Vect getStartVector() {
        return new Vect(this.startX, this.startY, this.startZ);
    }

    protected void generateTreeTrunk(int height, int width) {
        this.generateTreeTrunk(height, width, 0.0f);
    }

    protected void generateTreeTrunk(int height, int width, float vines) {
        int offset = (width - 1) / 2;
        for (int x = 0; x < width; ++x) {
            for (int y2 = 0; y2 < width; ++y2) {
                for (int i = 0; i < height; ++i) {
                    this.addWood(x - offset, i, y2 - offset, true);
                    if (this.rand.nextFloat() < vines) {
                        this.addVine(x - offset - 1, i, y2 - offset);
                    }
                    if (this.rand.nextFloat() < vines) {
                        this.addVine(x - offset + 1, i, y2 - offset);
                    }
                    if (this.rand.nextFloat() < vines) {
                        this.addVine(x - offset, i, y2 - offset - 1);
                    }
                    if (!(this.rand.nextFloat() < vines)) continue;
                    this.addVine(x - offset, i, y2 - offset + 1);
                }
            }
        }
    }

    protected void generateSupportStems(int height, int girth, float chance, float maxHeight) {
        int offset = 1;
        for (int x = -offset; x < girth + offset; ++x) {
            for (int z = -offset; z < girth + offset; ++z) {
                if (x == -offset && z == -offset || x == girth + offset && z == girth + offset || x == -offset && z == girth + offset || x == girth + offset && z == -offset) continue;
                int stemHeight = this.rand.nextInt(Math.round((float)height * maxHeight));
                if (!(this.rand.nextFloat() < chance)) continue;
                for (int i = 0; i < stemHeight; ++i) {
                    this.addWood(x, i, z, false);
                }
            }
        }
    }

    @Override
    protected void addBlock(int x, int y2, int z, BlockType type, boolean doReplace) {
        if (doReplace || this.world.c(this.startX + x, this.startY + y2, this.startZ + z)) {
            type.setBlock(this.world, this.tree, this.startX + x, this.startY + y2, this.startZ + z);
        }
    }

    protected final void clearBlock(int x, int y2, int z) {
        this.air.setBlock(this.world, this.tree, this.startX + x, this.startY + y2, this.startZ + z);
    }

    protected final void addWood(int x, int y2, int z, boolean doReplace) {
        this.addBlock(x, y2, z, this.wood, doReplace);
    }

    protected final void addLeaf(int x, int y2, int z, boolean doReplace) {
        this.addBlock(x, y2, z, this.leaf, doReplace);
    }

    protected final void addVine(int x, int y2, int z) {
        this.addBlock(x, y2, z, this.vine, false);
    }
}

