/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.config.ForestryBlock;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.WorldGenBase;

public class WorldGenBalsa
extends WorldGenTree {
    public WorldGenBalsa(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int leafSpawn = this.height;
        this.addLeaf(0, leafSpawn--, 0, false);
        this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 1.0f, 1, this.leaf, false);
        if (this.height > 10) {
            this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 1.0f, 1, this.leaf, false);
        }
        --leafSpawn;
        while (leafSpawn > 6) {
            this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 1.0f, 1, this.leaf, false);
            --leafSpawn;
        }
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(6, 6);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }

    @Override
    public BlockType getWood() {
        return new BlockType(ForestryBlock.log3.cm, 3);
    }
}

