/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.config.ForestryBlock;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.WorldGenBase;

public class WorldGenWalnut
extends WorldGenTree {
    public WorldGenWalnut(ITreeGenData tree) {
        super(tree);
        this.minHeight = 7;
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateCylinder(new WorldGenBase.Vector(0.5f, leafSpawn--, 0.5f), 1.0f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenBase.Vector(0.5f, leafSpawn--, 0.5f), 2.5f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenBase.Vector(0.5f, leafSpawn--, 0.5f), 3.5f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenBase.Vector(0.5f, leafSpawn--, 0.5f), 4.0f, 1, this.leaf, false);
        while (leafSpawn > 3) {
            this.generateCylinder(new WorldGenBase.Vector(0.5f, leafSpawn--, 0.5f), 5.0f, 1, this.leaf, false);
        }
        if (this.rand.nextBoolean()) {
            this.generateCylinder(new WorldGenBase.Vector(0.5f, leafSpawn--, 0.5f), 4.0f, 1, this.leaf, false);
        }
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(7, 3);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }

    @Override
    public BlockType getWood() {
        return new BlockType(ForestryBlock.log4.cm, 1);
    }
}

