/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.EntityPackage;
import forestry.core.gadgets.Gadget;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IOwnable;
import forestry.core.network.ForestryPacket;
import forestry.core.network.INetworkedEntity;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketTileUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumAccess;
import forestry.core.utils.Vect;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileForestry
extends any
implements INetworkedEntity,
IOwnable,
IErrorSource {
    protected boolean isInited = false;
    public EntityPackage pack;
    protected int energyConsumed;
    protected int energyLast;
    protected int energyReceived;
    private ForgeDirection orientation = ForgeDirection.WEST;
    public EnumErrorCode errorState = EnumErrorCode.OK;
    public String owner = null;
    private EnumAccess access = EnumAccess.SHARED;

    public Vect Coords() {
        return new Vect(this.l, this.m, this.n);
    }

    public abstract Gadget getMachine();

    public void openGui(qx player) {
    }

    public void g() {
        IPowerReceptor receptor;
        if (!this.isInited) {
            this.initialize();
            this.isInited = true;
        }
        if (!Proxies.common.isSimulating(this.k)) {
            return;
        }
        if (this instanceof IPowerReceptor && (receptor = (IPowerReceptor)((Object)this)).getPowerProvider() != null) {
            IPowerProvider powerProvider = receptor.getPowerProvider();
            powerProvider.update(receptor);
        }
    }

    public abstract void initialize();

    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.access = nbttagcompound.b("Access") ? EnumAccess.values()[nbttagcompound.e("Access")] : EnumAccess.SHARED;
        if (nbttagcompound.b("Owner")) {
            this.owner = nbttagcompound.i("Owner");
        }
        this.orientation = nbttagcompound.b("Orientation") ? ForgeDirection.values()[nbttagcompound.e("Orientation")] : ForgeDirection.WEST;
    }

    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("Access", this.access.ordinal());
        if (this.owner != null) {
            nbttagcompound.a("Owner", this.owner);
        }
        if (this.orientation != null) {
            nbttagcompound.a("Orientation", this.orientation.ordinal());
        }
    }

    @Override
    public void sendNetworkUpdate() {
        PacketTileUpdate packet = new PacketTileUpdate(this);
        Proxies.net.sendNetworkPacket(packet, this.l, this.m, this.n);
    }

    public ef l() {
        PacketTileUpdate packet = new PacketTileUpdate(this);
        return packet.getPacket();
    }

    public abstract PacketPayload getPacketPayload();

    public abstract void fromPacketPayload(PacketPayload var1);

    @Override
    public void fromPacket(ForestryPacket packetRaw) {
        PacketTileUpdate packet = (PacketTileUpdate)packetRaw;
        this.orientation = packet.getOrientation();
        this.errorState = packet.getErrorState();
        this.owner = packet.getOwner();
        this.access = packet.getAccess();
        this.fromPacketPayload(packet.payload);
    }

    public LinkedList getCustomTriggers() {
        return null;
    }

    public void onRemoval() {
    }

    public boolean isActivated() {
        return this.k.B(this.l, this.m, this.n);
    }

    public ForgeDirection getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ForgeDirection orientation) {
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        this.sendNetworkUpdate();
    }

    public void setErrorState(EnumErrorCode state) {
        if (this.errorState == state) {
            return;
        }
        this.errorState = state;
        this.sendNetworkUpdate();
    }

    @Override
    public boolean throwsErrors() {
        return true;
    }

    @Override
    public EnumErrorCode getErrorState() {
        return this.errorState;
    }

    @Override
    public boolean allowsRemoval(qx player) {
        if (!this.isOwnable()) {
            return true;
        }
        if (!this.isOwned()) {
            return true;
        }
        if (this.isOwner(player)) {
            return true;
        }
        if (Proxies.common.isOp(player)) {
            return true;
        }
        return this.getAccess() == EnumAccess.SHARED;
    }

    @Override
    public boolean allowsInteraction(qx player) {
        if (Config.disablePermissions) {
            return true;
        }
        if (!this.isOwnable()) {
            return true;
        }
        if (!this.isOwned()) {
            return true;
        }
        if (this.isOwner(player)) {
            return true;
        }
        if (Proxies.common.isOp(player)) {
            return true;
        }
        return this.getAccess() == EnumAccess.SHARED || this.getAccess() == EnumAccess.VIEWABLE;
    }

    @Override
    public EnumAccess getAccess() {
        return this.access;
    }

    @Override
    public boolean isOwnable() {
        return false;
    }

    @Override
    public boolean isOwned() {
        return this.owner != null && !this.owner.isEmpty();
    }

    @Override
    public String getOwnerName() {
        return this.owner;
    }

    public qx getOwnerEntity() {
        if (this.owner != null) {
            return this.k.a(this.owner);
        }
        return null;
    }

    @Override
    public void setOwner(qx player) {
        this.owner = player.bR;
    }

    @Override
    public boolean isOwner(qx player) {
        if (this.owner != null) {
            return this.owner.equals(player.bR);
        }
        return false;
    }

    @Override
    public boolean switchAccessRule(qx player) {
        if (this.owner != null && !this.owner.isEmpty() && !this.owner.equals(player.bR)) {
            return false;
        }
        this.access = this.access.ordinal() < EnumAccess.values().length - 1 ? EnumAccess.values()[this.access.ordinal() + 1] : EnumAccess.values()[0];
        return true;
    }

    public abstract String b();

    public abstract boolean a_(qx var1);
}

