/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.ILegacyHandler;
import java.util.Random;

public class Chromosome
implements IChromosome {
    private static final String UID0_TAG = "UID0";
    private static final String UID1_TAG = "UID1";
    private IAllele primary;
    private IAllele secondary;

    private Chromosome() {
    }

    public Chromosome(IAllele allele) {
        this.primary = this.secondary = allele;
    }

    public Chromosome(IAllele primary, IAllele secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        if (nbttagcompound.b("PrimaryId")) {
            this.primary = ((ILegacyHandler)((Object)AlleleManager.alleleRegistry)).getFromLegacyMap(nbttagcompound.e("PrimaryId"));
            this.secondary = ((ILegacyHandler)((Object)AlleleManager.alleleRegistry)).getFromLegacyMap(nbttagcompound.e("SecondaryId"));
            if (this.primary == null || this.secondary == null) {
                throw new RuntimeException("Legacy conversion of chromosome failed. Did one of your bee addons not update? No legacy mapping for ids: " + nbttagcompound.e("PrimaryId") + " - " + nbttagcompound.e("SecondaryId"));
            }
            return;
        }
        this.primary = AlleleManager.alleleRegistry.getAllele(nbttagcompound.i(UID0_TAG));
        this.secondary = AlleleManager.alleleRegistry.getAllele(nbttagcompound.i(UID1_TAG));
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a(UID0_TAG, this.primary.getUID());
        nbttagcompound.a(UID1_TAG, this.secondary.getUID());
    }

    @Override
    public IAllele getPrimaryAllele() {
        return this.primary;
    }

    @Override
    public IAllele getSecondaryAllele() {
        return this.secondary;
    }

    @Override
    public IAllele getActiveAllele() {
        if (this.primary.isDominant()) {
            return this.primary;
        }
        if (this.secondary.isDominant()) {
            return this.secondary;
        }
        return this.primary;
    }

    @Override
    public IAllele getInactiveAllele() {
        if (!this.secondary.isDominant()) {
            return this.secondary;
        }
        if (!this.primary.isDominant()) {
            return this.primary;
        }
        return this.secondary;
    }

    public IAllele getRandomAllele(Random rand) {
        if (rand.nextBoolean()) {
            return this.primary;
        }
        return this.secondary;
    }

    public void overrideInvalidAlleles(IAllele template) {
        if (this.primary == null) {
            this.primary = template;
        }
        if (this.secondary == null) {
            this.secondary = template;
        }
    }

    public static Chromosome loadChromosomeFromNBT(bq compound) {
        Chromosome chromosome = new Chromosome();
        chromosome.readFromNBT(compound);
        return chromosome;
    }

    public static IChromosome inheritChromosome(Random rand, IChromosome parent1, IChromosome parent2) {
        IAllele choice1 = rand.nextBoolean() ? parent1.getPrimaryAllele() : parent1.getSecondaryAllele();
        IAllele choice2 = rand.nextBoolean() ? parent2.getPrimaryAllele() : parent2.getSecondaryAllele();
        if (rand.nextBoolean()) {
            return new Chromosome(choice1, choice2);
        }
        return new Chromosome(choice2, choice1);
    }
}

