/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.EnumErrorCode;
import forestry.core.gui.Ledger;
import forestry.core.gui.LedgerManager;
import forestry.core.interfaces.IErrorSource;
import forestry.core.utils.StringUtil;

public class ErrorLedger
extends Ledger {
    IErrorSource tile;

    public ErrorLedger(LedgerManager manager, IErrorSource tile) {
        super(manager);
        this.tile = tile;
        this.maxHeight = 72;
        this.overlayColor = manager.gui.fontColor.get("ledger.error.background");
    }

    @Override
    public void draw(int x2, int y2) {
        EnumErrorCode state = this.tile.getErrorState();
        if (state == EnumErrorCode.OK) {
            return;
        }
        this.drawBackground(x2, y2);
        this.drawIcon("/gfx/forestry/gui/errors.png", state.getIconIndex(), x2 + 3, y2 + 4);
        if (this.isFullyOpened()) {
            this.manager.minecraft.p.a(this.getTooltip(), x2 + 22, y2 + 8, this.manager.gui.fontColor.get("ledger.error.header"));
            this.manager.minecraft.p.a(StringUtil.localize(this.tile.getErrorState().getHelp()), x2 + 22, y2 + 20, this.maxWidth - 28, this.manager.gui.fontColor.get("ledger.error.text"));
        }
    }

    @Override
    public boolean isVisible() {
        EnumErrorCode state = this.tile.getErrorState();
        return state != EnumErrorCode.OK;
    }

    @Override
    public String getTooltip() {
        return StringUtil.localize(this.tile.getErrorState().getDescription());
    }
}

