/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.Ledger;
import forestry.core.gui.LedgerManager;
import forestry.core.interfaces.IHintSource;
import forestry.core.utils.StringUtil;
import java.util.Random;

public class HintLedger
extends Ledger {
    int position;
    String[] hints;

    public HintLedger(LedgerManager manager, IHintSource tile) {
        super(manager);
        this.hints = tile.getHints();
        this.maxHeight = 96;
        this.position = new Random().nextInt(this.hints.length);
        this.overlayColor = manager.gui.fontColor.get("ledger.hint.background");
    }

    @Override
    public void draw(int x2, int y2) {
        this.drawBackground(x2, y2);
        this.drawIcon("/gfx/forestry/gui/misc.png", 1, x2 + 3, y2 + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.manager.minecraft.p.a(StringUtil.localize("gui.didyouknow") + "?", x2 + 22, y2 + 8, this.manager.gui.fontColor.get("ledger.hint.header"));
        this.manager.minecraft.p.a(StringUtil.localize("hints." + this.hints[this.position] + ".desc"), x2 + 22, y2 + 20, this.maxWidth - 28, this.manager.gui.fontColor.get("ledger.hint.text"));
    }

    @Override
    public String getTooltip() {
        return StringUtil.localize("hints." + this.hints[this.position] + ".tag");
    }
}

