/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.gadgets.TileForestry;
import forestry.core.gui.ContainerLiquidTanks;
import forestry.core.gui.ContainerSocketed;
import forestry.core.gui.IGuiSelectable;
import forestry.core.interfaces.ISocketable;
import forestry.core.network.ForestryPacket;
import forestry.core.network.ILocatedPacket;
import forestry.core.network.INetworkedEntity;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketFXSignal;
import forestry.core.network.PacketInventoryStack;
import forestry.core.network.PacketSocketUpdate;
import forestry.core.network.PacketTileNBT;
import forestry.core.network.PacketTileUpdate;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.plugins.PluginManager;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class PacketHandler
implements IPacketHandler {
    public void onPacketData(ce network, di packet, Player player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.c));
        try {
            byte packetId = data.readByte();
            switch (packetId) {
                case 0: {
                    PacketTileUpdate packetT = new PacketTileUpdate();
                    packetT.readData(data);
                    this.onTileUpdate(packetT);
                    break;
                }
                case 1: {
                    PacketUpdate packetUpdate = new PacketUpdate();
                    packetUpdate.readData(data);
                    this.onTileUpdate(packetUpdate);
                    break;
                }
                case 5: {
                    PacketTileNBT packetN = new PacketTileNBT();
                    packetN.readData(data);
                    this.onTileUpdate(packetN);
                    break;
                }
                case 72: {
                    PacketSocketUpdate packetS = new PacketSocketUpdate();
                    packetS.readData(data);
                    this.onSocketUpdate(packetS);
                    break;
                }
                case 3: {
                    PacketInventoryStack packetQ = new PacketInventoryStack();
                    packetQ.readData(data);
                    this.onInventoryStack(packetQ);
                    break;
                }
                case 4: {
                    PacketFXSignal packetF = new PacketFXSignal();
                    packetF.readData(data);
                    packetF.executeFX();
                    break;
                }
                case 40: {
                    PacketUpdate packetU = new PacketUpdate();
                    packetU.readData(data);
                    this.onPipetteClick(packetU, (qx)player);
                    break;
                }
                case 71: {
                    PacketUpdate packetU = new PacketUpdate();
                    packetU.readData(data);
                    this.onSolderingIronClick(packetU, (qx)player);
                    break;
                }
                case 70: {
                    PacketUpdate packetU = new PacketUpdate();
                    packetU.readData(data);
                    this.onChipsetClick(packetU, (qx)player);
                    break;
                }
                case 50: {
                    PacketCoordinates packetC = new PacketCoordinates();
                    packetC.readData(data);
                    this.onAccessSwitch(packetC, (qx)player);
                    break;
                }
                case 32: {
                    PacketUpdate packetI = new PacketUpdate();
                    packetI.readData(data);
                    this.onGuiSelection((qx)player, packetI);
                    break;
                }
                case 30: {
                    PacketUpdate packetZ = new PacketUpdate();
                    packetZ.readData(data);
                    this.onGuiChange((qx)player, packetZ);
                    break;
                }
                default: {
                    for (forestry.api.core.IPacketHandler handler : PluginManager.packetHandlers) {
                        handler.onPacketData(network, packetId, data, player);
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onGuiChange(qx player, PacketUpdate packet) {
        if (!(player.bL instanceof IGuiSelectable)) {
            return;
        }
        ((IGuiSelectable)player.bL).handleSelectionChange(player, packet);
    }

    private void onGuiSelection(qx player, PacketUpdate packet) {
        rq container = player.bL;
        if (!(container instanceof IGuiSelectable)) {
            return;
        }
        ((IGuiSelectable)container).setSelection(packet);
    }

    private void onSocketUpdate(PacketSocketUpdate packet) {
        any tile = Proxies.common.getRenderWorld().q(packet.posX, packet.posY, packet.posZ);
        if (!(tile instanceof ISocketable)) {
            return;
        }
        ISocketable socketable = (ISocketable)tile;
        for (int i = 0; i < packet.itemstacks.length; ++i) {
            socketable.setSocket(i, packet.itemstacks[i]);
        }
    }

    private void onTileUpdate(ForestryPacket packet) {
        any tile = ((ILocatedPacket)((Object)packet)).getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof INetworkedEntity) {
            ((INetworkedEntity)tile).fromPacket(packet);
        }
    }

    private void onInventoryStack(PacketInventoryStack packet) {
        any tile = Proxies.common.getRenderWorld().q(packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        if (!(tile instanceof la)) {
            return;
        }
        ((la)tile).a(packet.slotIndex, packet.itemstack);
    }

    private void onChipsetClick(PacketUpdate packet, qx player) {
        if (!(player.bL instanceof ContainerSocketed)) {
            return;
        }
        ur itemstack = player.bJ.n();
        if (!(itemstack.b() instanceof ItemCircuitBoard)) {
            return;
        }
        ((ContainerSocketed)player.bL).handleChipsetClick(packet.payload.intPayload[0], player, itemstack);
    }

    private void onSolderingIronClick(PacketUpdate packet, qx player) {
        if (!(player.bL instanceof ContainerSocketed)) {
            return;
        }
        ur itemstack = player.bJ.n();
        ((ContainerSocketed)player.bL).handleSolderingIronClick(packet.payload.intPayload[0], player, itemstack);
    }

    private void onAccessSwitch(PacketCoordinates packet, qx playerEntity) {
        TileForestry tile = (TileForestry)playerEntity.p.q(packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        tile.switchAccessRule(playerEntity);
    }

    private void onPipetteClick(PacketUpdate packet, qx player) {
        if (!(player.bL instanceof ContainerLiquidTanks)) {
            return;
        }
        ((ContainerLiquidTanks)player.bL).handlePipetteClick(packet.payload.intPayload[0], player);
    }
}

