/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import cpw.mods.fml.client.FMLTextureFX;
import forestry.core.proxy.Proxies;

public class TextureLiquidsFX
extends FMLTextureFX {
    private final String texture;
    private final int rMin;
    private final int rMax;
    private final int gMin;
    private final int gMax;
    private final int bMin;
    private final int bMax;
    protected float[] red;
    protected float[] green;
    protected float[] blue;
    protected float[] alpha;

    public TextureLiquidsFX(int rMin, int rMax, int gMin, int gMax, int bMin, int bMax, int iconIndex, String textureFile) {
        super(iconIndex);
        this.texture = textureFile;
        this.rMin = rMin;
        this.rMax = rMax;
        this.gMin = gMin;
        this.gMax = gMax;
        this.bMin = bMin;
        this.bMax = bMax;
        this.setup();
    }

    public void setup() {
        super.setup();
        this.red = new float[this.tileSizeSquare];
        this.green = new float[this.tileSizeSquare];
        this.blue = new float[this.tileSizeSquare];
        this.alpha = new float[this.tileSizeSquare];
    }

    public void a(bba renderengine) {
        Proxies.common.bindTexture(this.texture);
    }

    public void a() {
        int g;
        int r;
        float var3;
        int i;
        for (i = 0; i < this.tileSizeBase; ++i) {
            for (int var2 = 0; var2 < this.tileSizeBase; ++var2) {
                var3 = 0.0f;
                for (int j = i - 1; j <= i + 1; ++j) {
                    r = j & this.tileSizeMask;
                    g = var2 & this.tileSizeMask;
                    var3 += this.red[r + g * this.tileSizeBase];
                }
                this.green[i + var2 * this.tileSizeBase] = var3 / 3.3f + this.blue[i + var2 * this.tileSizeBase] * 0.8f;
            }
        }
        for (i = 0; i < this.tileSizeBase; ++i) {
            for (int j = 0; j < this.tileSizeBase; ++j) {
                int n = i + j * this.tileSizeBase;
                this.blue[n] = this.blue[n] + this.alpha[i + j * this.tileSizeBase] * 0.05f;
                if (this.blue[i + j * this.tileSizeBase] < 0.0f) {
                    this.blue[i + j * this.tileSizeBase] = 0.0f;
                }
                int n2 = i + j * this.tileSizeBase;
                this.alpha[n2] = this.alpha[n2] - 0.1f;
                if (!(Math.random() < 0.05)) continue;
                this.alpha[i + j * this.tileSizeBase] = 0.5f;
            }
        }
        float[] var12 = this.green;
        this.green = this.red;
        this.red = var12;
        for (int i2 = 0; i2 < this.tileSizeSquare; ++i2) {
            var3 = this.red[i2];
            if (var3 > 1.0f) {
                var3 = 1.0f;
            }
            if (var3 < 0.0f) {
                var3 = 0.0f;
            }
            float var13 = var3 * var3;
            r = (int)((float)this.rMin + var13 * (float)(this.rMax - this.rMin));
            g = (int)((float)this.gMin + var13 * (float)(this.gMax - this.gMin));
            int b = (int)((float)this.bMin + var13 * (float)(this.bMax - this.bMin));
            int a = (int)(146.0f + var13 * 50.0f);
            if (this.f) {
                int var9 = (r * 30 + g * 59 + b * 11) / 100;
                int var10 = (r * 30 + g * 70) / 100;
                int var11 = (r * 30 + b * 70) / 100;
                r = var9;
                g = var10;
                b = var11;
            }
            this.d[i2 * 4 + 0] = (byte)r;
            this.d[i2 * 4 + 1] = (byte)g;
            this.d[i2 * 4 + 2] = (byte)b;
            this.d[i2 * 4 + 3] = (byte)a;
        }
    }
}

