/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeEntry;
import forestry.core.utils.Vect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public class BlockUtil {
    public static ArrayList getBlockItemStack(yc world, Vect posBlock) {
        amq block = amq.p[world.a(posBlock.x, posBlock.y, posBlock.z)];
        if (block == null) {
            return null;
        }
        int meta = world.h(posBlock.x, posBlock.y, posBlock.z);
        return block.getBlockDropped(world, posBlock.x, posBlock.y, posBlock.z, meta, 0);
    }

    public static la[] getAdjacentInventories(yc world, Vect blockPos, ForgeDirection from) {
        ArrayList<la> inventories = new ArrayList<la>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            any entity;
            if (from != ForgeDirection.UNKNOWN && from != dir.getOpposite() || (entity = world.q(blockPos.x + dir.offsetX, blockPos.y + dir.offsetY, blockPos.z + dir.offsetZ)) == null || !(entity instanceof la) || entity instanceof IPowerReceptor) continue;
            inventories.add((la)entity);
        }
        return inventories.toArray(new la[inventories.size()]);
    }

    public static ForgeDirection[] getPipeDirections(yc world, Vect blockPos, ForgeDirection from) {
        LinkedList<ForgeDirection> possiblePipes = new LinkedList<ForgeDirection>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (from != ForgeDirection.UNKNOWN && from != dir.getOpposite()) continue;
            Position posPipe = new Position(blockPos.x, blockPos.y, blockPos.z, dir);
            posPipe.moveForwards(1.0);
            any pipeEntry = world.q((int)posPipe.x, (int)posPipe.y, (int)posPipe.z);
            if (!(pipeEntry instanceof IPipeEntry) || !((IPipeEntry)pipeEntry).acceptItems()) continue;
            if (from != ForgeDirection.UNKNOWN && pipeEntry instanceof IPipeConnection) {
                if (!((IPipeConnection)pipeEntry).isPipeConnected(from)) continue;
                possiblePipes.add(dir);
                continue;
            }
            possiblePipes.add(dir);
        }
        return possiblePipes.toArray(new ForgeDirection[0]);
    }

    public static ForgeDirection[] filterPipeDirections(ForgeDirection[] all, ForgeDirection[] exclude) {
        LinkedList<ForgeDirection> filtered = new LinkedList<ForgeDirection>();
        ArrayList<ForgeDirection> excludeList = new ArrayList<ForgeDirection>(Arrays.asList(exclude));
        for (int i = 0; i < all.length; ++i) {
            if (excludeList.contains(all[i])) continue;
            filtered.add(all[i]);
        }
        return filtered.toArray(new ForgeDirection[filtered.size()]);
    }

    public static void putFromStackIntoPipe(any tile, ForgeDirection[] pipes, ur stack) {
        if (stack == null) {
            return;
        }
        if (stack.a <= 0) {
            return;
        }
        if (pipes.length <= 0) {
            return;
        }
        int choice = tile.k.t.nextInt(pipes.length);
        Position itemPos = new Position(tile.l, tile.m, tile.n, pipes[choice]);
        itemPos.x += 0.5;
        itemPos.y += 0.25;
        itemPos.z += 0.5;
        itemPos.moveForwards(0.5);
        Position pipePos = new Position(tile.l, tile.m, tile.n, pipes[choice]);
        pipePos.moveForwards(1.0);
        IPipeEntry pipe = (IPipeEntry)tile.k.q((int)pipePos.x, (int)pipePos.y, (int)pipePos.z);
        ur payload = stack.a(1);
        pipe.entityEntering(payload, itemPos.orientation);
    }
}

