/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.proxy.Proxies;
import forestry.core.utils.StructureBlueprint;
import forestry.core.utils.Vect;

public class StructureConstruction {
    private StructureBlueprint blueprint;
    private Vect position;
    private Vect shift;
    private Vect current = new Vect(0, 0, 0);
    public boolean isFinished = false;

    public StructureConstruction() {
    }

    public StructureConstruction(StructureBlueprint bp, Vect p, Vect s2) {
        this.blueprint = bp;
        this.position = p;
        this.shift = s2;
    }

    public int getCurrentBlockId() {
        return this.blueprint.getBlockId(this.current);
    }

    public int getCurrentY() {
        return this.position.y + this.current.y + this.shift.y;
    }

    public int getCurrentX() {
        return this.position.x + this.current.x + this.shift.x;
    }

    public int getCurrentZ() {
        return this.position.z + this.current.z + this.shift.z;
    }

    public Vect getCurrentPos() {
        return new Vect(this.getCurrentX(), this.getCurrentY(), this.getCurrentZ());
    }

    public void advanceStep() {
        if (this.current.z < this.blueprint.getZLength() - 1) {
            ++this.current.z;
        } else {
            this.current.z = 0;
            if (this.current.x < this.blueprint.getXLength() - 1) {
                ++this.current.x;
            } else {
                this.current.x = 0;
                if (this.current.y < this.blueprint.getYLength() - 1) {
                    ++this.current.y;
                } else {
                    this.isFinished = true;
                }
            }
        }
    }

    public void reset() {
        this.current = new Vect(0, 0, 0);
        this.isFinished = false;
    }

    public void readFromNBT(bq nbttagcompound) {
        String ident;
        this.isFinished = nbttagcompound.n("IsFinished");
        if (nbttagcompound.b("BlueprintIdent")) {
            ident = nbttagcompound.i("BlueprintIdent");
        } else {
            int id = nbttagcompound.e("BlueprintId");
            switch (id) {
                case 0: {
                    ident = "defaultArboretum";
                    break;
                }
                case 1: {
                    ident = "saplingSoil";
                    break;
                }
                case 2: {
                    ident = "saplingPlantation";
                    break;
                }
                case 3: {
                    ident = "wheatSoil";
                    break;
                }
                case 4: {
                    ident = "wheatPlantation";
                    break;
                }
                default: {
                    ident = "defaultArboretum";
                }
            }
        }
        if (StructureBlueprint.index.containsKey(ident)) {
            this.blueprint = (StructureBlueprint)StructureBlueprint.index.get(ident);
        } else {
            Proxies.log.severe("Tried to load non-existing structure blueprint identified by " + ident);
        }
        this.position = new Vect(nbttagcompound.e("XPosition"), nbttagcompound.e("YPosition"), nbttagcompound.e("ZPosition"));
        this.shift = new Vect(nbttagcompound.e("XShift"), nbttagcompound.e("YShift"), nbttagcompound.e("ZShift"));
        this.current = new Vect(nbttagcompound.e("XCurrent"), nbttagcompound.e("YCurrent"), nbttagcompound.e("ZCurrent"));
    }

    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("IsFinished", this.isFinished);
        nbttagcompound.a("BlueprintIdent", this.blueprint.id);
        nbttagcompound.a("XPosition", this.position.x);
        nbttagcompound.a("YPosition", this.position.y);
        nbttagcompound.a("ZPosition", this.position.z);
        nbttagcompound.a("XShift", this.shift.x);
        nbttagcompound.a("YShift", this.shift.y);
        nbttagcompound.a("ZShift", this.shift.z);
        nbttagcompound.a("XCurrent", this.current.x);
        nbttagcompound.a("YCurrent", this.current.y);
        nbttagcompound.a("ZCurrent", this.current.z);
    }
}

