/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.worldgen;

import forestry.core.worldgen.BlockType;
import java.util.Random;

public abstract class WorldGenBase
extends abm {
    protected yc world;
    protected Random rand;

    public boolean a(yc world, Random random, int x2, int y2, int z2) {
        this.world = world;
        this.rand = random;
        return true;
    }

    protected abstract void addBlock(int var1, int var2, int var3, BlockType var4, boolean var5);

    protected final void generateCuboid(Vector start, Vector area, BlockType block, boolean doReplace) {
        int x2 = (int)start.x;
        while ((float)x2 < (float)((int)start.x) + area.x) {
            int y2 = (int)start.y;
            while ((float)y2 < (float)((int)start.y) + area.y) {
                int z2 = (int)start.z;
                while ((float)z2 < (float)((int)start.z) + area.z) {
                    this.addBlock(x2, y2, z2, block, doReplace);
                    ++z2;
                }
                ++y2;
            }
            ++x2;
        }
    }

    protected final void generateCylinder(Vector center, float radius, int height, BlockType block, boolean doReplace) {
        Vector start = new Vector(center.x - radius, center.y, center.z - radius);
        Vector area = new Vector(radius * 2.0f + 1.0f, height, radius * 2.0f + 1.0f);
        int x2 = (int)start.x;
        while ((float)x2 < (float)((int)start.x) + area.x) {
            int y2 = (int)start.y;
            while ((float)y2 < (float)((int)start.y) + area.y) {
                int z2 = (int)start.z;
                while ((float)z2 < (float)((int)start.z) + area.z) {
                    Vector vector = new Vector(x2, y2, z2);
                    Vector vector2 = new Vector(center.x, y2, center.z);
                    if (Vector.distance(vector, vector2) <= (double)radius + 0.01) {
                        this.addBlock(x2, y2, z2, block, doReplace);
                    }
                    ++z2;
                }
                ++y2;
            }
            ++x2;
        }
    }

    protected final void generateCircle(Vector center, float radius, int width, int height, BlockType block, boolean doReplace) {
        this.generateCircle(center, radius, width, height, block, 1.0f, doReplace);
    }

    protected final void generateCircle(Vector center, float radius, int width, int height, BlockType block, float chance, boolean doReplace) {
        Vector start = new Vector(center.x - radius, center.y, center.z - radius);
        Vector area = new Vector(radius * 2.0f + 1.0f, height, radius * 2.0f + 1.0f);
        int x2 = (int)start.x;
        while ((float)x2 < (float)((int)start.x) + area.x) {
            int y2 = (int)start.y;
            while ((float)y2 < (float)((int)start.y) + area.y) {
                int z2 = (int)start.z;
                while ((float)z2 < (float)((int)start.z) + area.z) {
                    double distance;
                    if (!(this.rand.nextFloat() > chance) && (double)(radius - (float)width) - 0.01 < (distance = Vector.distance(new Vector(x2, y2, z2), new Vector(center.x, y2, center.z))) && distance <= (double)radius + 0.01) {
                        this.addBlock(x2, y2, z2, block, doReplace);
                    }
                    ++z2;
                }
                ++y2;
            }
            ++x2;
        }
    }

    protected final void generateSphere(Vector center, int radius, BlockType block, boolean doReplace) {
        Vector start = new Vector(center.x - (float)radius, center.y - (float)radius, center.z - (float)radius);
        Vector area = new Vector(radius * 2 + 1, radius * 2 + 1, radius * 2 + 1);
        int x2 = (int)start.x;
        while ((float)x2 < (float)((int)start.x) + area.x) {
            int y2 = (int)start.y;
            while ((float)y2 < (float)((int)start.y) + area.y) {
                int z2 = (int)start.z;
                while ((float)z2 < (float)((int)start.z) + area.z) {
                    Vector vector = new Vector(x2, y2, z2);
                    Vector vector2 = new Vector(center.x, center.y, center.z);
                    if (Vector.distance(vector, vector2) <= (double)radius + 0.01) {
                        this.addBlock(x2, y2, z2, block, doReplace);
                    }
                    ++z2;
                }
                ++y2;
            }
            ++x2;
        }
    }

    public static class Vector {
        float x;
        float y;
        float z;

        public Vector(float f, float h, float g) {
            this.x = f;
            this.y = h;
            this.z = g;
        }

        public static double distance(Vector a, Vector b) {
            return Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0) + Math.pow(a.z - b.z, 2.0));
        }
    }
}

