/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.recipes.ICarpenterManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.items.ItemCrated;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.GenericInventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import forestry.core.utils.TileInventoryAdapter;
import forestry.core.utils.Utils;
import forestry.factory.gui.ContainerCarpenter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class MachineCarpenter
extends Machine {
    public static final int SLOT_CRAFTING_1 = 0;
    public static final int SLOT_BOX = 9;
    public static final int SLOT_PRODUCT = 10;
    public static final int SLOT_CAN_INPUT = 11;
    public static final short SLOT_INVENTORY_1 = 12;
    public static final short SLOT_INVENTORY_COUNT = 18;
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    private TileInventoryAdapter inventory;
    public Recipe currentRecipe;
    public ContainerCarpenter activeContainer;
    private int packageTime;
    private int totalTime;
    private ur currentProduct;
    private ur pendingProduct;

    public ur getBoxStack() {
        return this.inventory.a(9);
    }

    public MachineCarpenter(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("carpenter"));
        this.inventory = new TileInventoryAdapter(tile, 30, "Items");
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.5");
    }

    @Override
    public void openGui(qx player, la tile) {
        player.openGui(ForestryAPI.instance, GuiId.CarpenterGUI.ordinal(), player.p, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("PackageTime", this.packageTime);
        nbttagcompound.a("PackageTotalTime", this.totalTime);
        bq NBTresourceSlot = new bq();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.a("ResourceTank", (cd)NBTresourceSlot);
        this.inventory.writeToNBT(nbttagcompound);
        if (this.pendingProduct != null) {
            bq nbttagcompoundP = new bq();
            this.pendingProduct.b(nbttagcompoundP);
            nbttagcompound.a("PendingProduct", (cd)nbttagcompoundP);
        }
        if (this.currentProduct != null) {
            bq nbttagcompoundC = new bq();
            this.currentProduct.b(nbttagcompoundC);
            nbttagcompound.a("CurrentProduct", (cd)nbttagcompoundC);
        }
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        bq nbttagcompoundP;
        super.readFromNBT(nbttagcompound);
        this.packageTime = nbttagcompound.e("PackageTime");
        this.totalTime = nbttagcompound.e("PackageTotalTime");
        this.resourceTank = new TankSlot(10000);
        if (nbttagcompound.b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.l("ResourceTank"));
        }
        this.inventory.readFromNBT(nbttagcompound);
        if (nbttagcompound.b("PendingProduct")) {
            nbttagcompoundP = nbttagcompound.l("PendingProduct");
            this.pendingProduct = ur.a((bq)nbttagcompoundP);
        }
        if (nbttagcompound.b("CurrentProduct")) {
            nbttagcompoundP = nbttagcompound.l("CurrentProduct");
            this.currentProduct = ur.a((bq)nbttagcompoundP);
        }
        ContainerCarpenter container = new ContainerCarpenter((TileMachine)this.tile);
        this.currentRecipe = RecipeManager.findMatchingRecipe(this.resourceTank.asLiquidStack(), this.getBoxStack(), container.craftMatrix, this.tile.k);
    }

    @Override
    public void updateServerSide() {
        Object container;
        if (this.tile.k.G() % 20L * 10L != 0L) {
            return;
        }
        if (this.inventory.a(11) != null && (container = LiquidHelper.getLiquidContainer(this.inventory.a(11))) != null && RecipeManager.isResourceLiquid(container.stillLiquid)) {
            this.inventory.a(11, StackUtils.replenishByContainer(this.tile, this.inventory.a(11), container, this.resourceTank));
            if (this.inventory.a((int)11).a <= 0) {
                this.inventory.a(11, null);
            }
        }
        if (this.tile.k.G() % 40L * 10L != 0L) {
            return;
        }
        if (this.currentRecipe == null) {
            container = new ContainerCarpenter((TileMachine)this.tile);
            this.currentRecipe = RecipeManager.findMatchingRecipe(this.resourceTank.asLiquidStack(), this.getBoxStack(), container.craftMatrix, this.tile.k);
        }
        if (this.currentRecipe == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        } else if (!this.validateResources()) {
            this.setErrorState(EnumErrorCode.NORESOURCE);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean doWork() {
        if (this.packageTime > 0) {
            --this.packageTime;
            if (this.currentRecipe == null || !this.currentProduct.a(this.currentRecipe.getCraftingResult()) || !this.validateResources()) {
                this.currentProduct = null;
                this.totalTime = 0;
                this.packageTime = 0;
                return false;
            }
            if (this.packageTime <= 0) {
                this.pendingProduct = this.currentProduct;
                this.currentProduct = null;
                this.totalTime = 0;
                this.removeResources(this.currentRecipe);
                if (this.activeContainer != null) {
                    this.activeContainer.updateProductDisplay();
                }
                return this.tryAddPending();
            }
            return true;
        }
        if (this.pendingProduct != null) {
            return this.tryAddPending();
        }
        if (this.currentRecipe != null) {
            if (!this.validateResources()) {
                return false;
            }
            this.packageTime = this.totalTime = this.currentRecipe.packagingTime;
            this.currentProduct = this.currentRecipe.getCraftingResult();
            if (this.activeContainer != null) {
                this.activeContainer.updateProductDisplay();
            }
            return true;
        }
        return false;
    }

    private boolean validateResources() {
        if (this.currentRecipe.liquid != null && this.resourceTank.quantity < ((Recipe)this.currentRecipe).liquid.amount) {
            return false;
        }
        if (this.currentRecipe.box != null && this.inventory.a(9) == null) {
            return false;
        }
        return StackUtils.containsSets(this.inventory.getStacks(0, 9), this.inventory.getStacks(12, 18), true) > 0;
    }

    private void removeResources(Recipe recipe) {
        if (recipe.liquid != null) {
            this.resourceTank.quantity -= ((Recipe)recipe).liquid.amount;
        }
        if (recipe.box != null) {
            this.inventory.a(9, 1);
        }
        this.removeSets(1, this.inventory.getStacks(0, 9));
    }

    private void removeSets(int count, ur[] set) {
        for (int i = 0; i < count; ++i) {
            ur[] condensedSet;
            for (ur req : condensedSet = StackUtils.condenseStacks(set)) {
                for (int j = 12; j < 30; ++j) {
                    ur pol = this.inventory.a(j);
                    if (pol == null || !StackUtils.isItemOreEqual(pol, req)) continue;
                    ur removed = this.inventory.a(j, req.a);
                    req.a -= removed.a;
                }
            }
        }
    }

    private boolean tryAddPending() {
        if (this.inventory.a(10) == null) {
            this.inventory.a(10, this.pendingProduct.l());
            this.pendingProduct = null;
            return true;
        }
        if (this.inventory.a(10).a(this.pendingProduct) && this.inventory.a((int)10).a <= this.inventory.a(10).d() - this.pendingProduct.a) {
            this.inventory.a((int)10).a += this.pendingProduct.a;
            this.pendingProduct = null;
            return true;
        }
        this.setErrorState(EnumErrorCode.NOSPACE);
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.packageTime > 0 || this.pendingProduct != null || this.currentRecipe != null && this.validateResources();
    }

    @Override
    public boolean hasWork() {
        if (this.currentRecipe == null) {
            return false;
        }
        if (this.inventory.a(10) != null && this.inventory.a(10).d() - this.inventory.a((int)10).a < this.currentRecipe.getCraftingResult().a) {
            return false;
        }
        return this.validateResources();
    }

    public int getCraftingProgressScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.packageTime * i / this.totalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    public GenericInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public int k_() {
        return this.inventory.k_() - 9;
    }

    @Override
    public ur a(int i) {
        return this.inventory.a(i + 9);
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventory.a(i + 9, itemstack);
    }

    @Override
    public ur a(int i, int j) {
        return this.inventory.a(i + 9, j);
    }

    @Override
    public ur a_(int slot) {
        return this.inventory.a_(slot);
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0) {
            return 1;
        }
        if (side == 1) {
            return 0;
        }
        return 3;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 0) {
            return 1;
        }
        if (side == 1) {
            return 1;
        }
        return 18;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.packageTime = j;
                break;
            }
            case 1: {
                this.totalTime = j;
                break;
            }
            case 2: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 3: {
                this.resourceTank.quantity = j;
                break;
            }
            case 4: {
                this.resourceTank.liquidMeta = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
        iCrafting.a(container, 0, this.packageTime);
        iCrafting.a(container, 1, this.totalTime);
        iCrafting.a(container, 2, this.resourceTank.liquidId);
        iCrafting.a(container, 3, this.resourceTank.quantity);
        iCrafting.a(container, 4, this.resourceTank.liquidMeta);
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        LiquidContainerData container = LiquidHelper.getLiquidContainer(stack);
        if (container != null && RecipeManager.isResourceLiquid(container.stillLiquid)) {
            return this.inventory.addStack(stack, 11, 1, false, doAdd);
        }
        if (this.currentRecipe != null && this.currentRecipe.isIngredient(stack)) {
            return this.inventory.addStack(stack, 12, 18, false, doAdd);
        }
        if (RecipeManager.isBox(stack)) {
            return this.inventory.addStack(stack, 9, 1, false, doAdd);
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (this.inventory.a(10) == null) {
            return new ur[0];
        }
        if (this.inventory.a((int)10).a <= 0) {
            return new ur[0];
        }
        ur product = new ur(this.inventory.a((int)10).c, 1, this.inventory.a(10).j());
        if (doRemove) {
            this.inventory.a(10, 1);
        }
        return new ur[]{product};
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    public TankSlot[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.resourceTank};
    }

    @Override
    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.resourceTank;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static void initialize() {
        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(ForestryItem.liquidSeedOil, 100), null, new ur(ForestryItem.stickImpregnated, 2), new Object[]{"#", "#", Character.valueOf('#'), "logWood"});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(amq.E.cm, 250), null, new ur(ForestryItem.woodPulp, 4), new Object[]{"#", Character.valueOf('#'), "logWood"});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(amq.E.cm, 250), null, new ur(up.aK, 1), new Object[]{"#", "#", Character.valueOf('#'), "pulpWood"});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryBlock.soil, 9, 0), new Object[]{"###", "#X#", "###", Character.valueOf('#'), amq.y, Character.valueOf('X'), ForestryItem.mulch});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryBlock.soil, 8, 1), new Object[]{"#X#", "XYX", "#X#", Character.valueOf('#'), amq.y, Character.valueOf('X'), amq.H, Character.valueOf('Y'), ForestryItem.mulch});
        RecipeManagers.carpenterManager.addRecipe(75, new LiquidStack(amq.E.cm, 5000), null, new ur(ForestryItem.hardenedCasing), new Object[]{"# #", " Y ", "# #", Character.valueOf('#'), up.n, Character.valueOf('Y'), ForestryItem.sturdyCasing});
        RecipeManagers.carpenterManager.addRecipe(20, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryItem.circuitboards, 1, 0), new Object[]{"R R", "R#R", "R R", Character.valueOf('#'), "ingotTin", Character.valueOf('R'), up.aC});
        RecipeManagers.carpenterManager.addRecipe(40, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryItem.circuitboards, 1, 1), new Object[]{"R#R", "R#R", "R#R", Character.valueOf('#'), "ingotBronze", Character.valueOf('R'), up.aC});
        RecipeManagers.carpenterManager.addRecipe(80, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryItem.circuitboards, 1, 2), new Object[]{"R#R", "R#R", "R#R", Character.valueOf('#'), up.o, Character.valueOf('R'), up.aC});
        RecipeManagers.carpenterManager.addRecipe(80, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryItem.circuitboards, 1, 3), new Object[]{"R#R", "R#R", "R#R", Character.valueOf('#'), up.p, Character.valueOf('R'), up.aC});
        RecipeManagers.carpenterManager.addRecipe(40, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryItem.solderingIron), new Object[]{" # ", "# #", "  B", Character.valueOf('#'), up.o, Character.valueOf('B'), "ingotBronze"});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryItem.iodineCharge, 1), new Object[]{"Z#Z", "#Y#", "X#X", Character.valueOf('#'), ForestryItem.pollen, Character.valueOf('X'), up.M, Character.valueOf('Y'), ForestryItem.canEmpty, Character.valueOf('Z'), ForestryItem.honeyDrop});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryItem.craftingMaterial, 1, 4), new Object[]{"Z#Z", "#Y#", "X#X", Character.valueOf('#'), ForestryItem.royalJelly, Character.valueOf('X'), up.M, Character.valueOf('Y'), ForestryItem.canEmpty, Character.valueOf('Z'), ForestryItem.honeydew});
        RecipeManagers.carpenterManager.addRecipe(100, null, new ur(up.bn, 1), new Object[]{" # ", "###", " # ", Character.valueOf('#'), new ur(ForestryItem.craftingMaterial, 1, 1)});
        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(amq.E.cm, 500), null, new ur(ForestryItem.craftingMaterial, 1, 3), new Object[]{"###", "###", "###", Character.valueOf('#'), new ur(ForestryItem.craftingMaterial, 1, 2)});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryItem.carton, 2), new Object[]{" # ", "# #", " # ", Character.valueOf('#'), "pulpWood"});
        RecipeManagers.carpenterManager.addRecipe(20, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryItem.crate, 24), new Object[]{" # ", "# #", " # ", Character.valueOf('#'), "logWood"});
        RecipeManagers.carpenterManager.addRecipe(20, new LiquidStack(0, 0), new ur(ForestryItem.carton), new ur(ForestryItem.kitPickaxe), new Object[]{"###", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood"});
        RecipeManagers.carpenterManager.addRecipe(20, new LiquidStack(0, 0), new ur(ForestryItem.carton), new ur(ForestryItem.kitShovel), new Object[]{" # ", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood"});
        RecipeManagers.carpenterManager.addRecipe(null, new ur(ForestryItem.ingotBronze.c, 2, ForestryItem.ingotBronze.k()), new Object[]{"#", Character.valueOf('#'), ForestryItem.brokenBronzePickaxe});
        RecipeManagers.carpenterManager.addRecipe(null, ForestryItem.ingotBronze, new Object[]{"#", Character.valueOf('#'), ForestryItem.brokenBronzeShovel});
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedWood));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedCobblestone));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedDirt));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedStone));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedBrick));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedCacti));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedSand));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedObsidian));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedNetherrack));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedSoulsand));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedSandstone));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedBogearth));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedHumus));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedNetherbrick));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedPeat));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedApatite));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedFertilizer));
        ((RecipeManager)RecipeManagers.carpenterManager).addCrating("ingotTin", ForestryItem.ingotTin, new ur((up)ForestryItem.cratedTin));
        ((RecipeManager)RecipeManagers.carpenterManager).addCrating("ingotCopper", ForestryItem.ingotCopper, new ur((up)ForestryItem.cratedCopper));
        ((RecipeManager)RecipeManagers.carpenterManager).addCrating("ingotBronze", ForestryItem.ingotBronze, new ur((up)ForestryItem.cratedBronze));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedWheat));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedMycelium));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedMulch));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedCookies));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedHoneycombs));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedBeeswax));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedPollen));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedPropolis));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedHoneydew));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedRoyalJelly));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedCocoaComb));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedRedstone));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedLapis));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedReeds));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedClay));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedGlowstone));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedApples));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedNetherwart));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedSimmeringCombs));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedStringyCombs));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedFrozenCombs));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedDrippingCombs));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedRefractoryWax));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedPhosphor));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedAsh));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedCharcoal));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedGravel));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedCoal));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedSeeds));
        RecipeManagers.carpenterManager.addCrating(new ur((up)ForestryItem.cratedSaplings));
    }

    public static class RecipeManager
    implements ICarpenterManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addCrating(ur itemStack) {
            ur uncrated = ((ItemCrated)itemStack.b()).getContained(itemStack);
            this.addRecipe(5, new LiquidStack(amq.E.cm, 100), new ur(ForestryItem.crate), itemStack, new Object[]{"###", "###", "###", Character.valueOf('#'), uncrated});
            this.addRecipe(null, new ur(uncrated.c, 9, uncrated.j()), new Object[]{"#", Character.valueOf('#'), itemStack});
        }

        @Override
        public void addCrating(String toCrate, ur unpack, ur crated) {
            this.addRecipe(5, new LiquidStack(amq.E.cm, 100), new ur(ForestryItem.crate), crated, new Object[]{"###", "###", "###", Character.valueOf('#'), toCrate});
            this.addRecipe(null, new ur(unpack.c, 9, unpack.j()), new Object[]{"#", Character.valueOf('#'), crated});
        }

        @Override
        public void addRecipe(ur box, ur product, Object[] materials) {
            this.addRecipe(5, null, box, product, materials);
        }

        @Override
        public void addRecipe(int packagingTime, ur box, ur product, Object[] materials) {
            this.addRecipe(packagingTime, null, box, product, materials);
        }

        @Override
        public void addRecipe(int packagingTime, LiquidStack liquid, ur box, ur product, Object[] materials) {
            recipes.add(new Recipe(packagingTime, liquid, box, ShapedRecipeCustom.createShapedRecipe(materials, product)));
        }

        public static Recipe findMatchingRecipe(LiquidStack liquid, ur item, ry inventorycrafting, yc world) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(liquid, item, inventorycrafting, world)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isResourceLiquid(LiquidStack liquid) {
            for (Recipe recipe : recipes) {
                if (!recipe.hasLiquid(liquid)) continue;
                return true;
            }
            return false;
        }

        public static boolean isBox(ur resource) {
            for (Recipe recipe : recipes) {
                if (!recipe.hasBox(resource)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List getRecipes() {
            return null;
        }
    }

    public static class Recipe {
        private int packagingTime;
        private LiquidStack liquid;
        private ur box;
        private ShapedRecipeCustom internal;

        public Recipe(int packagingTime, LiquidStack liquid, ur box, ShapedRecipeCustom internal) {
            this.packagingTime = packagingTime;
            this.liquid = liquid;
            this.box = box;
            this.internal = internal;
        }

        public ur getCraftingResult() {
            return this.internal.b();
        }

        public boolean matches(LiquidStack resource, ur item, ry inventorycrafting, yc world) {
            if (this.liquid != null && resource == null) {
                return false;
            }
            if (this.liquid != null && !this.liquid.isLiquidEqual(resource)) {
                return false;
            }
            if (this.box != null && item == null) {
                return false;
            }
            if (this.box != null && !this.box.a(item)) {
                return false;
            }
            return this.internal.a(inventorycrafting, world);
        }

        public boolean hasLiquid(LiquidStack resource) {
            if (this.liquid != null && resource != null) {
                return this.liquid.isLiquidEqual(resource);
            }
            return false;
        }

        public boolean hasBox(ur resource) {
            if (this.box == null && resource == null) {
                return true;
            }
            if (this.box == null) {
                return true;
            }
            if (this.box.j() > 0) {
                return this.box.a(resource);
            }
            return this.box.c == resource.c;
        }

        public boolean isIngredient(ur resource) {
            return this.internal.isIngredient(resource);
        }

        public LiquidStack getLiquid() {
            return this.liquid;
        }

        public wp asIRecipe() {
            return this.internal;
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MachineCarpenter((TileMachine)tile);
        }
    }
}

