/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import forestry.api.core.ITileStructure;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmComponent;
import forestry.api.farming.IFarmListener;
import forestry.api.farming.IFarmLogic;
import forestry.core.utils.Vect;
import forestry.farming.gadgets.TileFarm;
import java.util.Collection;
import net.minecraftforge.common.ForgeDirection;

public class TileControl
extends TileFarm
implements IFarmListener {
    public static int TEXTURE_SHIFT = 112;
    private boolean isInited = false;

    public TileControl() {
        this.textureShift = TEXTURE_SHIFT;
    }

    @Override
    protected void updateServerSide() {
        if (!this.isInited) {
            this.registerWithMaster();
        }
    }

    @Override
    public void setCentralTE(any tile) {
        super.setCentralTE(tile);
        this.registerWithMaster();
    }

    private void registerWithMaster() {
        this.isInited = true;
        if (!this.hasMaster()) {
            return;
        }
        ITileStructure central = this.getCentralTE();
        if (!(central instanceof IFarmComponent)) {
            return;
        }
        ((IFarmComponent)central).registerListener(this);
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    protected void createInventory() {
    }

    @Override
    public boolean cancelTask(IFarmLogic logic, ForgeDirection direction) {
        return this.hasRedstoneSignal(direction) || this.hasRedstoneSignal(ForgeDirection.UP) || this.hasRedstoneSignal(ForgeDirection.DOWN);
    }

    private boolean hasRedstoneSignal(ForgeDirection direction) {
        Vect side = new Vect(this.l + direction.offsetX, this.m + direction.offsetY, this.n + direction.offsetZ);
        ForgeDirection opp = direction.getOpposite();
        int dir = opp.offsetZ < 0 ? 2 : (opp.offsetZ > 0 ? 3 : (opp.offsetX < 0 ? 4 : (opp.offsetX > 0 ? 5 : 0)));
        return this.k.l(side.x, side.y, side.z, dir) || this.k.k(side.x, side.y, side.z, dir);
    }

    @Override
    public boolean beforeCropHarvest(ICrop crop) {
        return false;
    }

    @Override
    public void afterCropHarvest(Collection harvested, ICrop crop) {
    }

    @Override
    public void hasCollected(Collection collected, IFarmLogic logic) {
    }

    @Override
    public void hasCultivated(IFarmLogic logic, int x2, int y2, int z2, ForgeDirection direction, int extent) {
    }

    @Override
    public void hasScheduledHarvest(Collection harvested, IFarmLogic logic, int x2, int y2, int z2, ForgeDirection direction, int extent) {
    }
}

