/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.IFarmHousing;
import forestry.api.genetics.IFruitBearer;
import forestry.core.config.ForestryItem;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropFruit;
import forestry.farming.logic.FarmLogic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Stack;
import net.minecraftforge.common.ForgeDirection;

public class FarmLogicOrchard
extends FarmLogic {
    private HashMap lastExtents = new HashMap();

    public FarmLogicOrchard(IFarmHousing housing) {
        super(housing);
    }

    @Override
    public int getIconIndex() {
        return ForestryItem.fruits.b(0);
    }

    @Override
    public String getTextureFile() {
        return "/gfx/forestry/items/items.png";
    }

    @Override
    public String getName() {
        return "Orchard";
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(40.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ur itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ur itemstack) {
        return false;
    }

    @Override
    public Collection collect() {
        return null;
    }

    @Override
    public boolean cultivate(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection harvest(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        int lastExtent;
        this.world = this.housing.getWorld();
        Collection crops = null;
        Vect start = new Vect(x2, y2, z2);
        if (!this.lastExtents.containsKey(start)) {
            this.lastExtents.put(start, 0);
        }
        if ((lastExtent = ((Integer)this.lastExtents.get(start)).intValue()) > extent) {
            lastExtent = 0;
        }
        Vect position = this.translateWithOffset(x2, y2 + 1, z2, direction, lastExtent);
        crops = this.getHarvestBlocks(position);
        this.lastExtents.put(start, ++lastExtent);
        return crops;
    }

    private Collection getHarvestBlocks(Vect position) {
        ArrayList seen = new ArrayList();
        Stack crops = new Stack();
        IFruitBearer bearer = this.getFruitBlock(position);
        int blockid = this.getBlockId(position);
        if (amq.p[blockid] == null) {
            return crops;
        }
        if (!amq.p[blockid].isWood(this.world, position.x, position.y, position.z) && bearer == null) {
            return crops;
        }
        ArrayList candidates = this.processHarvestBlock(crops, seen, position, position);
        ArrayList temp = new ArrayList();
        while (!candidates.isEmpty() && crops.size() < 20) {
            for (Vect candidate : candidates) {
                temp.addAll(this.processHarvestBlock(crops, seen, position, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private ArrayList processHarvestBlock(Stack crops, Collection seen, Vect start, Vect position) {
        ArrayList<Vect> candidates = new ArrayList<Vect>();
        for (int i = -1; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    Vect candidate = new Vect(position.x + i, position.y + j, position.z + k);
                    if (candidate.equals(position) || Math.abs(candidate.x - start.x) > 5 || Math.abs(candidate.z - start.z) > 5) continue;
                    boolean skip = false;
                    for (Vect prcs : seen) {
                        if (!candidate.equals(prcs)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                    IFruitBearer bearer = this.getFruitBlock(candidate);
                    if (bearer != null && bearer.hasFruit()) {
                        if (bearer.getRipeness() >= 0.9f) {
                            crops.push(new CropFruit(this.world, candidate, bearer.getFruitFamily()));
                        }
                        candidates.add(candidate);
                        seen.add(candidate);
                        continue;
                    }
                    if (!this.isWoodBlock(candidate)) continue;
                    candidates.add(candidate);
                    seen.add(candidate);
                }
            }
        }
        return candidates;
    }

    private IFruitBearer getFruitBlock(Vect position) {
        any tile = this.world.q(position.x, position.y, position.z);
        if (!(tile instanceof IFruitBearer)) {
            return null;
        }
        return (IFruitBearer)tile;
    }
}

