/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.Vect;
import forestry.farming.logic.FarmLogic;
import java.util.Collection;
import java.util.Stack;
import net.minecraftforge.common.ForgeDirection;

public class FarmLogicPoale
extends FarmLogic {
    IFarmable[] germlings = ((Collection)Farmables.farmables.get("farmPoales")).toArray(new IFarmable[0]);

    public FarmLogicPoale(IFarmHousing housing) {
        super(housing);
    }

    @Override
    public int getIconIndex() {
        return up.aJ.b(0);
    }

    @Override
    public String getTextureFile() {
        return "/gui/items.png";
    }

    @Override
    public String getName() {
        if (this.isManual) {
            return "Manual Reed Farm";
        }
        return "Managed Reed Farm";
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(20.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ur itemstack) {
        if (this.isManual) {
            return false;
        }
        return itemstack.c == amq.H.cm || itemstack.c == amq.y.cm;
    }

    @Override
    public boolean isAcceptedGermling(ur itemstack) {
        if (this.isManual) {
            return false;
        }
        return itemstack.c == up.aJ.cj;
    }

    @Override
    public Collection collect() {
        return null;
    }

    @Override
    public boolean cultivate(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection harvest(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        this.world = this.housing.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x2, y2 + 1, z2, direction, i);
            for (IFarmable seed : this.germlings) {
                ICrop crop = seed.getCropAt(this.world, position.x, position.y, position.z);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }
}

