/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropBlock;
import forestry.plugins.PluginFarmCraftory;
import java.util.Collection;

public class FarmableFarmCraftory
implements IFarmable {
    Collection germlings;
    Collection windfall;

    public FarmableFarmCraftory(Collection germlings, Collection windfall) {
        this.germlings = germlings;
        this.windfall = windfall;
    }

    @Override
    public boolean isSaplingAt(yc world, int x2, int y2, int z2) {
        if (world.c(x2, y2, z2)) {
            return false;
        }
        int blockid = world.a(x2, y2, z2);
        return blockid == PluginFarmCraftory.blockSingle.cm || blockid == PluginFarmCraftory.blockMulti.cm;
    }

    @Override
    public ICrop getCropAt(yc world, int x2, int y2, int z2) {
        int blockid = world.a(x2, y2, z2);
        if (blockid != PluginFarmCraftory.blockSingle.cm && blockid != PluginFarmCraftory.blockMulti.cm) {
            return null;
        }
        any tile = world.q(x2, y2, z2);
        if (tile == null) {
            return null;
        }
        if (PluginFarmCraftory.getGrowthStage(tile) < 2) {
            return null;
        }
        return new CropBlock(world, blockid, world.h(x2, y2, z2), new Vect(x2, y2, z2));
    }

    @Override
    public boolean isGermling(ur itemstack) {
        for (ur seed : this.germlings) {
            if (!StackUtils.isIdenticalItem(seed, itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean plantSaplingAt(ur germling, yc world, int x2, int y2, int z2) {
        return germling.l().a(Utils.getForestryPlayer(world, x2, y2, z2), world, x2, y2 - 1, z2, 1, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public boolean isWindfall(ur itemstack) {
        for (ur fruit : this.windfall) {
            if (!StackUtils.isIdenticalItem(fruit, itemstack)) continue;
            return true;
        }
        return false;
    }
}

