/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropBlock;

public class FarmableGenericCrop
implements IFarmable {
    private ur seed;
    private int blockid;
    private int mature;

    public FarmableGenericCrop(ur seed, int blockid, int mature) {
        this.seed = seed;
        this.blockid = blockid;
        this.mature = mature;
    }

    @Override
    public boolean isSaplingAt(yc world, int x2, int y2, int z2) {
        if (world.c(x2, y2, z2)) {
            return false;
        }
        return world.a(x2, y2, z2) == this.blockid;
    }

    @Override
    public ICrop getCropAt(yc world, int x2, int y2, int z2) {
        if (world.a(x2, y2, z2) != this.blockid) {
            return null;
        }
        if (world.h(x2, y2, z2) != this.mature) {
            return null;
        }
        return new CropBlock(world, this.blockid, this.mature, new Vect(x2, y2, z2));
    }

    @Override
    public boolean isGermling(ur itemstack) {
        if (this.seed.c != itemstack.c) {
            return false;
        }
        if (this.seed.j() >= 0) {
            return this.seed.j() == itemstack.j();
        }
        return true;
    }

    @Override
    public boolean plantSaplingAt(ur germling, yc world, int x2, int y2, int z2) {
        return germling.l().a(Utils.getForestryPlayer(world, x2, y2, z2), world, x2, y2 - 1, z2, 1, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public boolean isWindfall(ur itemstack) {
        return false;
    }
}

