/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropBlock;

public class FarmableGenericSapling
implements IFarmable {
    final int saplingId;
    final int saplingMeta;
    ur[] windfall;

    public FarmableGenericSapling(int saplingId, int saplingMeta) {
        this(saplingId, saplingMeta, new ur[0]);
    }

    public FarmableGenericSapling(int saplingId, int saplingMeta, ur[] windfall) {
        this.saplingId = saplingId;
        this.saplingMeta = saplingMeta;
        this.windfall = windfall;
    }

    @Override
    public boolean isSaplingAt(yc world, int x2, int y2, int z2) {
        if (world.c(x2, y2, z2)) {
            return false;
        }
        if (world.a(x2, y2, z2) == this.saplingId) {
            return true;
        }
        if (this.saplingMeta >= 0) {
            return world.h(x2, y2, z2) == this.saplingMeta;
        }
        return true;
    }

    @Override
    public ICrop getCropAt(yc world, int x2, int y2, int z2) {
        int blockid = world.a(x2, y2, z2);
        if (amq.p[blockid] == null) {
            return null;
        }
        if (!amq.p[blockid].isWood(world, x2, y2, z2)) {
            return null;
        }
        return new CropBlock(world, blockid, world.h(x2, y2, z2), new Vect(x2, y2, z2));
    }

    @Override
    public boolean isGermling(ur itemstack) {
        if (itemstack.c != this.saplingId) {
            return false;
        }
        if (this.saplingMeta >= 0) {
            return itemstack.j() == this.saplingMeta;
        }
        return true;
    }

    @Override
    public boolean isWindfall(ur itemstack) {
        for (ur drop : this.windfall) {
            if (!drop.a(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean plantSaplingAt(ur germling, yc world, int x2, int y2, int z2) {
        return germling.l().a(Utils.getForestryPlayer(world, x2, y2, z2), world, x2, y2 - 1, z2, 1, 0.0f, 0.0f, 0.0f);
    }
}

