/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.items;

import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.items.ItemInventoried;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemInventory;
import forestry.core.utils.StringUtil;
import forestry.mail.ILetter;
import forestry.mail.Letter;
import java.util.List;

public class ItemLetter
extends ItemInventoried {
    public ItemLetter(int i) {
        super(i);
    }

    public ur a(ur itemstack, yc world, qx entityplayer) {
        if (Proxies.common.isSimulating(world) && itemstack.a == 1) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.LetterGUI.ordinal(), world, (int)entityplayer.t, (int)entityplayer.u, (int)entityplayer.v);
        }
        return itemstack;
    }

    public boolean q() {
        return true;
    }

    public int b(int damage) {
        int state = ItemLetter.getState(damage);
        int size = ItemLetter.getSize(damage);
        int icon = 52;
        if (state > 2) {
            icon = 55;
        } else if (state > 1) {
            icon = 54;
        } else if (state > 0) {
            icon = 53;
        }
        return icon += size * 16;
    }

    public static int encodeMeta(int state, int size) {
        int meta = size << 4;
        size = ItemLetter.getSize(meta |= state);
        state = ItemLetter.getState(meta);
        return meta;
    }

    public static int getState(int meta) {
        return meta & 0xF;
    }

    public static int getSize(int meta) {
        return meta >> 4;
    }

    public void a(ur itemstack, qx player, List list, boolean flag) {
        bq nbttagcompound = itemstack.p();
        if (nbttagcompound == null) {
            list.add("<" + StringUtil.localize("gui.blank") + ">");
            return;
        }
        Letter letter = new Letter(nbttagcompound);
        letter.addTooltip(list);
    }

    public static ILetter getLetter(ur itemstack) {
        if (itemstack == null) {
            return null;
        }
        if (!ItemLetter.isLetter(itemstack)) {
            return null;
        }
        if (itemstack.p() == null) {
            return null;
        }
        return new Letter(itemstack.p());
    }

    public static boolean isLetter(ur itemstack) {
        if (itemstack == null) {
            return false;
        }
        return itemstack.c == ForestryItem.letters.cj;
    }

    public static int getType(ILetter letter) {
        int count = letter.countAttachments();
        if (count > 5) {
            return 2;
        }
        if (count > 1) {
            return 1;
        }
        return 0;
    }

    public static class LetterInventory
    extends ItemInventory
    implements IErrorSource,
    IHintSource {
        ILetter letter;

        protected LetterInventory() {
            super(ItemLetter.class);
        }

        public LetterInventory(ur itemstack) {
            super(ItemLetter.class);
            this.parent = itemstack;
            this.isItemInventory = true;
            this.setUID();
            this.readFromNBT(itemstack.p());
        }

        public ILetter getLetter() {
            return this.letter;
        }

        @Override
        public void onGuiSaved(qx player) {
            super.onGuiSaved(player);
            int state = ItemLetter.getState(this.parent.j());
            if (state >= 2) {
                if (state == 2 && this.letter.countAttachments() <= 0) {
                    this.parent.b(ItemLetter.encodeMeta(3, ItemLetter.getSize(this.parent.j())));
                }
                return;
            }
            int type = ItemLetter.getType(this.letter);
            if (this.parent != null && this.letter.isMailable() && this.letter.isPostPaid()) {
                this.parent.b(ItemLetter.encodeMeta(1, type));
            } else {
                this.parent.b(ItemLetter.encodeMeta(0, type));
            }
        }

        @Override
        public void readFromNBT(bq nbttagcompound) {
            if (nbttagcompound == null) {
                return;
            }
            this.letter = new Letter(nbttagcompound);
        }

        @Override
        public void writeToNBT(bq nbttagcompound) {
            this.letter.writeToNBT(nbttagcompound);
        }

        @Override
        public ur a(int i, int j) {
            return this.letter.a(i, j);
        }

        @Override
        public void a(int i, ur itemstack) {
            this.letter.a(i, itemstack);
        }

        @Override
        public ur a(int i) {
            return this.letter.a(i);
        }

        @Override
        public int k_() {
            return this.letter.k_();
        }

        @Override
        public String b() {
            return this.letter.b();
        }

        @Override
        public int c() {
            return this.letter.c();
        }

        @Override
        public void d() {
            this.letter.d();
        }

        @Override
        public boolean a_(qx entityplayer) {
            return this.letter.a_(entityplayer);
        }

        @Override
        public void l_() {
        }

        @Override
        public void f() {
        }

        @Override
        public ur a_(int slot) {
            return this.letter.a_(slot);
        }

        @Override
        public boolean throwsErrors() {
            return true;
        }

        @Override
        public EnumErrorCode getErrorState() {
            if (!this.letter.hasRecipient()) {
                return EnumErrorCode.NORECIPIENT;
            }
            if (!this.letter.isProcessed() && !this.letter.isPostPaid()) {
                return EnumErrorCode.NOTPOSTPAID;
            }
            return EnumErrorCode.OK;
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("letter") != null && ((String[])Config.hints.get("letter")).length > 0;
        }

        @Override
        public String[] getHints() {
            return (String[])Config.hints.get("letter");
        }
    }
}

