/*
 * Decompiled with CFR 0.152.
 */
package forestry.pipes.network;

import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.network.Player;
import forestry.api.core.IPacketHandler;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketNBT;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.pipes.PipeLogicPropolis;
import forestry.pipes.gui.ContainerPropolisPipe;
import java.io.DataInputStream;

public class PacketHandlerPipes
implements IPacketHandler {
    private Pipe getPipe(yc world, int x2, int y2, int z2) {
        any tile = world.q(x2, y2, z2);
        if (tile == null) {
            return null;
        }
        if (!(tile instanceof TileGenericPipe)) {
            return null;
        }
        return ((TileGenericPipe)tile).pipe;
    }

    @Override
    public void onPacketData(ce network, int packetID, DataInputStream data, Player player) {
        try {
            switch (packetID) {
                case 100: {
                    PacketNBT packetN = new PacketNBT();
                    packetN.readData(data);
                    this.onFilterSet(packetN);
                    break;
                }
                case 101: {
                    PacketCoordinates packetC = new PacketCoordinates();
                    packetC.readData(data);
                    this.onRequestFilterSet((qx)player, packetC);
                    break;
                }
                case 103: {
                    PacketUpdate packetU = new PacketUpdate();
                    packetU.readData(data);
                    this.onTypeFilterChange((qx)player, packetU);
                    break;
                }
                case 102: {
                    PacketUpdate packetU = new PacketUpdate();
                    packetU.readData(data);
                    this.onGenomeFilterChange((qx)player, packetU);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onFilterSet(PacketNBT packet) {
        rq container = Proxies.common.getClientInstance().g.bL;
        if (container instanceof ContainerPropolisPipe) {
            PipeLogicPropolis pipeLogic = ((ContainerPropolisPipe)container).pipeLogic;
            pipeLogic.handleFilterSet(packet);
        }
    }

    private void onTypeFilterChange(qx player, PacketUpdate packet) {
        Pipe pipe = this.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.logic instanceof PipeLogicPropolis) {
            ((PipeLogicPropolis)pipe.logic).handleTypeFilterChange(packet.payload);
        }
    }

    private void onGenomeFilterChange(qx player, PacketUpdate packet) {
        Pipe pipe = this.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.logic instanceof PipeLogicPropolis) {
            ((PipeLogicPropolis)pipe.logic).handleGenomeFilterChange(packet.payload);
        }
    }

    private void onRequestFilterSet(qx player, PacketCoordinates packet) {
        Pipe pipe = this.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.logic instanceof PipeLogicPropolis) {
            ((PipeLogicPropolis)pipe.logic).sendFilterSet(player);
        }
    }
}

