/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.core.IOreDictionaryHandler;
import forestry.api.core.IPacketHandler;
import forestry.api.core.IPickupHandler;
import forestry.api.core.IPlugin;
import forestry.api.core.IResupplyHandler;
import forestry.api.core.ISaveEventHandler;
import forestry.api.core.PluginInfo;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IMutation;
import forestry.apiculture.genetics.AlleleBeeSpecies;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.apiculture.genetics.JubilanceReqRes;
import forestry.apiculture.genetics.MutationEMC;
import forestry.core.config.Config;
import forestry.core.genetics.Allele;
import forestry.core.proxy.Proxies;
import java.lang.reflect.Field;
import java.util.Random;

@PluginInfo(pluginID="EqEx2", name="Equivalent Exchange 2", author="SirSengir", url="http://forestry.sengir.net/", description="Compatibility plugin for Equivalent Exchange 2. Enables the Omega branch of bees. Requires Apiculture to be enabled.")
public class PluginEE
implements IPlugin {
    public IMutation darkenedA;
    public IMutation reddenedA;
    public IMutation omegaA;
    public ur eeBlock1;
    public ur eeBlock2;
    public Class eeRelay2Class;
    public Class eeRelay3Class;
    public Field eeRelay2EMCField;
    public Field eeRelay3EMCField;

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded("mod_EE") && !Config.disableApiculture;
    }

    @Override
    public void postInit() {
        try {
            this.eeBlock1 = new ur((amq)Class.forName("ee.EEBlock").getField("eeStone").get(null), 1, 8);
            this.eeBlock2 = new ur((amq)Class.forName("ee.EEBlock").getField("eeStone").get(null), 1, 9);
            this.eeRelay2Class = Class.forName("ee.TileRelay2");
            this.eeRelay2EMCField = this.eeRelay2Class.getField("scaledEnergy");
            this.eeRelay3Class = Class.forName("ee.TileRelay3");
            this.eeRelay3EMCField = this.eeRelay3Class.getField("scaledEnergy");
        }
        catch (Exception ex) {
            Proxies.log.fine("Necessary block/classes from EE were not found");
            return;
        }
        JubilanceReqRes jubilanceProviderDarkened = new JubilanceReqRes(this.eeBlock1);
        JubilanceReqRes jubilanceProviderReddened = new JubilanceReqRes(this.eeBlock2);
        ((AlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele((String)"forestry.speciesDarkened")).jubilanceProvider = jubilanceProviderDarkened;
        ((AlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele((String)"forestry.speciesReddened")).jubilanceProvider = jubilanceProviderReddened;
        ((AlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele((String)"forestry.speciesOmega")).jubilanceProvider = jubilanceProviderReddened;
        this.darkenedA = new MutationEMC(Allele.speciesModest, Allele.speciesWintry, BeeTemplates.getDarkenedTemplate(), 100, this.eeBlock1, this.eeRelay2Class, this.eeRelay2EMCField, 139264);
        this.reddenedA = new MutationEMC(Allele.speciesDarkened, Allele.speciesTropical, BeeTemplates.getReddenedTemplate(), 100, this.eeBlock2, this.eeRelay3Class, this.eeRelay3EMCField, 466944);
        this.omegaA = new MutationEMC(Allele.speciesDarkened, Allele.speciesReddened, BeeTemplates.getOmegaTemplate(), 100, this.eeBlock2, this.eeRelay3Class, this.eeRelay3EMCField, 933888).restrictBiome(yy.j.N).restrictBiome(yy.d.N);
    }

    @Override
    public String getDescription() {
        return "EquivalentExchange";
    }

    @Override
    public void preInit() {
    }

    @Override
    public void doInit() {
    }

    @Override
    public void generateSurface(yc world, Random rand, int chunkX, int chunkZ) {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return null;
    }

    @Override
    public IResupplyHandler getResupplyHandler() {
        return null;
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return null;
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return null;
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    public y[] getConsoleCommands() {
        return null;
    }
}

