/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.core.IOreDictionaryHandler;
import forestry.api.core.ISaveEventHandler;
import forestry.api.core.PluginInfo;
import forestry.api.recipes.RecipeManagers;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.GadgetManager;
import forestry.core.proxy.Proxies;
import forestry.factory.GuiHandlerFactory;
import forestry.factory.PackagesFactory;
import forestry.factory.gadgets.MachineBottler;
import forestry.factory.gadgets.MachineCarpenter;
import forestry.factory.gadgets.MachineCentrifuge;
import forestry.factory.gadgets.MachineFabricator;
import forestry.factory.gadgets.MachineFermenter;
import forestry.factory.gadgets.MachineMoistener;
import forestry.factory.gadgets.MachineSqueezer;
import forestry.factory.gadgets.MachineStill;
import forestry.factory.recipes.CraftGuideIntegration;
import forestry.plugins.NativePlugin;
import forestry.plugins.PluginIC2;
import net.minecraftforge.liquids.LiquidStack;

@PluginInfo(pluginID="Factory", name="Factory", author="SirSengir", url="http://forestry.sengir.net/", description="Adds a wide variety of machines to craft, produce and process products.")
public class PluginForestryFactory
extends NativePlugin {
    @Override
    public boolean isAvailable() {
        return !Config.disableFactory;
    }

    @Override
    public String getDescription() {
        return "Factory";
    }

    @Override
    public void preInit() {
        super.preInit();
        RecipeManagers.carpenterManager = new MachineCarpenter.RecipeManager();
        RecipeManagers.moistenerManager = new MachineMoistener.RecipeManager();
        RecipeManagers.centrifugeManager = new MachineCentrifuge.RecipeManager();
        RecipeManagers.stillManager = new MachineStill.RecipeManager();
        RecipeManagers.bottlerManager = new MachineBottler.RecipeManager();
        RecipeManagers.squeezerManager = new MachineSqueezer.RecipeManager();
        RecipeManagers.fermenterManager = new MachineFermenter.RecipeManager();
        RecipeManagers.fabricatorManager = new MachineFabricator.RecipeManager();
    }

    @Override
    public void postInit() {
        super.postInit();
        MachineCarpenter.initialize();
        MachineMoistener.initialize();
        MachineStill.initialize();
        MachineBottler.initialize();
        MachineSqueezer.initialize();
        MachineFermenter.initialize();
        MachineFabricator.initialize();
        if (Proxies.common.isModLoaded("craftguide")) {
            CraftGuideIntegration.register();
        } else {
            Proxies.log.info("Skipping CraftGuide integration.");
        }
    }

    @Override
    protected void registerPackages() {
        GadgetManager.registerMachinePackage(0, PackagesFactory.getFermenterPackage());
        GadgetManager.registerMachinePackage(1, PackagesFactory.getStillPackage());
        GadgetManager.registerMachinePackage(2, PackagesFactory.getBottlerPackage());
        GadgetManager.registerMachinePackage(3, PackagesFactory.getRaintankPackage());
        GadgetManager.registerMachinePackage(6, PackagesFactory.getMoistenerPackage());
        GadgetManager.registerMachinePackage(5, PackagesFactory.getCarpenterPackage());
        GadgetManager.registerMachinePackage(8, PackagesFactory.getCentrifugePackage());
        GadgetManager.registerMachinePackage(9, PackagesFactory.getSqueezerPackage());
        GadgetManager.registerMachinePackage(11, PackagesFactory.getFabriactorPackage());
        GadgetManager.registerMillPackage(1, PackagesFactory.getRainmakerPackage());
    }

    @Override
    protected void registerItems() {
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerRecipes() {
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new ur(ForestryItem.tubes, 4, 0), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), up.aC, Character.valueOf('X'), "ingotCopper"});
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new ur(ForestryItem.tubes, 4, 1), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), up.aC, Character.valueOf('X'), "ingotTin"});
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new ur(ForestryItem.tubes, 4, 2), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), up.aC, Character.valueOf('X'), "ingotBronze"});
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new ur(ForestryItem.tubes, 4, 3), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), up.aC, Character.valueOf('X'), up.o});
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new ur(ForestryItem.tubes, 4, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), up.aC, Character.valueOf('X'), up.p});
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new ur(ForestryItem.tubes, 4, 5), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), up.aC, Character.valueOf('X'), up.n});
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new ur(ForestryItem.tubes, 4, 6), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), up.aC, Character.valueOf('X'), amq.as});
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new ur(ForestryItem.tubes, 4, 7), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), up.aC, Character.valueOf('X'), up.bw});
        if (PluginIC2.rubber != null) {
            RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new ur(ForestryItem.tubes, 4, 8), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), up.aC, Character.valueOf('X'), PluginIC2.rubber});
        }
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new ur(ForestryItem.tubes, 4, 9), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), up.aC, Character.valueOf('X'), up.bH});
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new ur(ForestryItem.tubes, 4, 10), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), up.aC, Character.valueOf('X'), ForestryItem.apatite});
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new ur(ForestryItem.tubes, 4, 11), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), up.aC, Character.valueOf('X'), new ur(up.aW, 1, 4)});
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        if (ForestryItem.propolis != null) {
            for (int i = 0; i < 16; ++i) {
                RecipeManagers.fabricatorManager.addRecipe(new ur(ForestryItem.waxCast, 1, -1), new LiquidStack(ForestryItem.liquidGlass, 1000), new ur(ForestryBlock.glass, 1, 15 - i), new Object[]{"#", "X", Character.valueOf('#'), dyes[i], Character.valueOf('X'), new ur(ForestryItem.propolis, 1, -1)});
            }
        }
        RecipeManagers.squeezerManager.addRecipe(10, new ur[]{new ur(up.j)}, new LiquidStack(ForestryItem.liquidJuice, 200), new ur(ForestryItem.mulch), 40);
        RecipeManagers.squeezerManager.addRecipe(10, new ur[]{new ur(up.S)}, new LiquidStack(ForestryItem.liquidSeedOil, GameMode.getGameMode().getSqueezedLiquidPerSeed()));
        RecipeManagers.squeezerManager.addRecipe(10, new ur[]{new ur(up.bg)}, new LiquidStack(ForestryItem.liquidSeedOil, GameMode.getGameMode().getSqueezedLiquidPerSeed()));
        RecipeManagers.squeezerManager.addRecipe(10, new ur[]{new ur(up.bh)}, new LiquidStack(ForestryItem.liquidSeedOil, GameMode.getGameMode().getSqueezedLiquidPerSeed()));
        RecipeManagers.squeezerManager.addRecipe(10, new ur[]{new ur(ForestryItem.phosphor, 2), new ur(amq.z)}, new LiquidStack(amq.G, 1600));
        RecipeManagers.squeezerManager.addRecipe(10, new ur[]{new ur(amq.aY)}, new LiquidStack(amq.E, 500));
        RecipeManagers.squeezerManager.addRecipe(10, new ur[]{new ur(up.aD), new ur(ForestryItem.craftingMaterial, 4, 5)}, new LiquidStack(ForestryItem.liquidIce, 4000));
        RecipeManagers.carpenterManager.addRecipe(50, new LiquidStack(ForestryItem.liquidSeedOil, 250), null, new ur(ForestryItem.impregnatedCasing, 1), new Object[]{"###", "# #", "###", Character.valueOf('#'), "logWood"});
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerFactory();
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }
}

